/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.contribs.queue.nats.config;

import com.netflix.conductor.contribs.queue.nats.config.JetStreamEventQueueProvider;
import com.netflix.conductor.contribs.queue.nats.config.JetStreamProperties;
import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.conductor.core.events.EventQueueProvider;
import com.netflix.conductor.core.events.queue.ObservableQueue;
import com.netflix.conductor.model.TaskModel;
import java.util.EnumMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import rx.Scheduler;

@Configuration
@EnableConfigurationProperties(value={JetStreamProperties.class})
@ConditionalOnProperty(name={"conductor.event-queues.jsm.enabled"}, havingValue="true")
public class JetStreamConfiguration {
    @Bean
    public EventQueueProvider jsmEventQueueProvider(JetStreamProperties properties, Scheduler scheduler, ConductorProperties conductorProperties, ApplicationEventPublisher eventPublisher) {
        return new JetStreamEventQueueProvider(conductorProperties, properties, scheduler, eventPublisher);
    }

    @ConditionalOnProperty(name={"conductor.default-event-queue.type"}, havingValue="jsm")
    @Bean
    public Map<TaskModel.Status, ObservableQueue> getQueues(EventQueueProvider jsmEventQueueProvider, JetStreamProperties properties) {
        TaskModel.Status[] statuses = new TaskModel.Status[]{TaskModel.Status.COMPLETED, TaskModel.Status.FAILED};
        EnumMap<TaskModel.Status, ObservableQueue> queues = new EnumMap<TaskModel.Status, ObservableQueue>(TaskModel.Status.class);
        for (TaskModel.Status status : statuses) {
            String queueName = status.name() + this.getQueueGroup(properties);
            ObservableQueue queue = jsmEventQueueProvider.getQueue(queueName);
            queues.put(status, queue);
        }
        return queues;
    }

    private String getQueueGroup(JetStreamProperties properties) {
        if (properties.getDefaultQueueGroup() == null || properties.getDefaultQueueGroup().isBlank()) {
            return "";
        }
        return ":" + properties.getDefaultQueueGroup();
    }
}

