/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.contribs.queue.nats.config;

import com.netflix.conductor.contribs.queue.nats.JetStreamObservableQueue;
import com.netflix.conductor.contribs.queue.nats.config.JetStreamProperties;
import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.conductor.core.events.EventQueueProvider;
import com.netflix.conductor.core.events.queue.ObservableQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import rx.Scheduler;

public class JetStreamEventQueueProvider
implements EventQueueProvider {
    public static final String QUEUE_TYPE = "jsm";
    private static final Logger LOG = LoggerFactory.getLogger(JetStreamEventQueueProvider.class);
    private final Map<String, ObservableQueue> queues = new ConcurrentHashMap<String, ObservableQueue>();
    private final JetStreamProperties properties;
    private final ConductorProperties conductorProperties;
    private final Scheduler scheduler;
    private final ApplicationEventPublisher eventPublisher;

    public JetStreamEventQueueProvider(ConductorProperties conductorProperties, JetStreamProperties properties, Scheduler scheduler, ApplicationEventPublisher eventPublisher) {
        LOG.info("NATS Event Queue Provider initialized...");
        this.properties = properties;
        this.conductorProperties = conductorProperties;
        this.scheduler = scheduler;
        this.eventPublisher = eventPublisher;
    }

    public String getQueueType() {
        return QUEUE_TYPE;
    }

    @NonNull
    public ObservableQueue getQueue(String queueURI) throws IllegalArgumentException {
        LOG.info("Getting obs queue, quri={}", (Object)queueURI);
        return this.queues.computeIfAbsent(queueURI, q -> new JetStreamObservableQueue(this.conductorProperties, this.properties, this.getQueueType(), queueURI, this.scheduler, this.eventPublisher));
    }
}

