/*
 * Decompiled with CFR 0.152.
 */
package org.conductoross.conductor;

import com.netflix.conductor.rest.config.RestConfiguration;
import java.io.IOException;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.io.FileSystemResource;

@SpringBootApplication(exclude={DataSourceAutoConfiguration.class})
@ComponentScan(basePackages={"com.netflix.conductor", "io.orkes.conductor", "org.conductoross"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={RestConfiguration.class})})
public class Conductor {
    private static final Logger log = LoggerFactory.getLogger(Conductor.class);

    public static void main(String[] args) throws IOException {
        Conductor.loadExternalConfig();
        SpringApplication.run(Conductor.class, (String[])args);
    }

    private static void loadExternalConfig() throws IOException {
        String configFile = System.getProperty("CONDUCTOR_CONFIG_FILE2");
        if (StringUtils.isBlank((CharSequence)configFile)) {
            configFile = System.getenv("CONDUCTOR_CONFIG_FILE2");
        }
        if (StringUtils.isNotBlank((CharSequence)configFile)) {
            log.info("Loading {}", (Object)configFile);
            FileSystemResource resource = new FileSystemResource(configFile);
            if (resource.exists()) {
                Properties properties = new Properties();
                properties.load(resource.getInputStream());
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> System.setProperty((String)key, (String)value)));
                log.info("Loaded {} properties from {}", (Object)properties.size(), (Object)configFile);
            } else {
                log.warn("Ignoring {} since it does not exist", (Object)configFile);
            }
        }
    }
}

