/*
 * Decompiled with CFR 0.152.
 */
package org.conductoross.conductor;

import lombok.Generated;
import org.conductoross.conductor.SpaInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class RestConfiguration
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestConfiguration.class);
    private final SpaInterceptor spaInterceptor;

    public RestConfiguration(SpaInterceptor spaInterceptor) {
        this.spaInterceptor = spaInterceptor;
        log.info("spaInterceptor: {}", (Object)spaInterceptor);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorParameter(false).favorPathExtension(false).ignoreAcceptHeader(true).defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OCTET_STREAM});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        if (this.spaInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)this.spaInterceptor).excludePathPatterns(new String[]{"/api/**"}).excludePathPatterns(new String[]{"/actuator/**"}).excludePathPatterns(new String[]{"/health/**"}).excludePathPatterns(new String[]{"/v3/api-docs"}).excludePathPatterns(new String[]{"/v3/api-docs/**"}).excludePathPatterns(new String[]{"/swagger-ui/**"}).order(Integer.MIN_VALUE);
        }
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (this.spaInterceptor != null) {
            log.info("Serving static resources");
            registry.addResourceHandler(new String[]{"/static/ui/**"}).addResourceLocations(new String[]{"classpath:/static/ui/"});
        }
    }
}

