/*
 * Decompiled with CFR 0.152.
 */
package org.conf4j.consul.source.reload;

import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.cache.KVCache;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.conf4j.consul.source.ConsulConfigurationSource;
import org.conf4j.core.source.reload.ReloadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulWatchReloadStrategy
implements ReloadStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ConsulWatchReloadStrategy.class);
    private final KeyValueClient kvClient;
    private final String pathToWatch;
    private final Duration timeout;
    private KVCache kvCache;

    private ConsulWatchReloadStrategy(KeyValueClient kvClient, String pathToWatch, Duration timeout) {
        this.kvClient = Objects.requireNonNull(kvClient);
        this.pathToWatch = Objects.requireNonNull(pathToWatch);
        this.timeout = Objects.requireNonNull(timeout);
    }

    public void start(Runnable reloadCallback) {
        this.kvCache = KVCache.newCache((KeyValueClient)this.kvClient, (String)this.pathToWatch);
        this.kvCache.addListener(newValues -> reloadCallback.run());
        try {
            this.kvCache.start();
            this.kvCache.awaitInitialized(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            logger.error("Unknown error occurred while initializing consul reload strategy", t);
        }
    }

    public void stop() {
        if (this.kvCache != null) {
            try {
                this.kvCache.stop();
            }
            catch (Throwable t) {
                logger.warn("Unknown error occurred while stopping consul reload strategy", t);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ConsulConfigurationSource source;

        public Builder withConsulConfigurationSource(ConsulConfigurationSource source) {
            this.source = source;
            return this;
        }

        public ConsulWatchReloadStrategy build() {
            Objects.requireNonNull(this.source);
            return new ConsulWatchReloadStrategy(this.source.getKeyValueClient(), this.source.getPathToWatch(), this.source.getWatchTimeout());
        }
    }
}

