/*
 * Decompiled with CFR 0.152.
 */
package org.conf4j.consul.source;

import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.conf4j.consul.source.ConsulConfigurationSource;
import org.conf4j.consul.source.reload.ConsulWatchReloadStrategy;
import org.conf4j.core.source.WatchableConfigurationSource;
import org.conf4j.core.source.reload.ReloadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulFileConfigurationSource
implements WatchableConfigurationSource,
ConsulConfigurationSource {
    private static final Logger logger = LoggerFactory.getLogger(ConsulFileConfigurationSource.class);
    private final KeyValueClient kvClient;
    private final String configurationFilePath;
    private final boolean ignoreMissingResource;
    private final Duration watchTimeout;
    private final AtomicReference<Config> configCache = new AtomicReference();
    private final ConsulWatchReloadStrategy reloadStrategy;

    private ConsulFileConfigurationSource(KeyValueClient kvClient, String configurationFilePath, boolean ignoreMissingFile, boolean reloadOnChange, Duration watchTimeout) {
        this.kvClient = Objects.requireNonNull(kvClient);
        this.configurationFilePath = Objects.requireNonNull(configurationFilePath);
        this.ignoreMissingResource = ignoreMissingFile;
        this.watchTimeout = Objects.requireNonNull(watchTimeout);
        this.configCache.set(this.buildConfigIfAbsent(null));
        this.reloadStrategy = reloadOnChange ? ConsulWatchReloadStrategy.builder().withConsulConfigurationSource(this).build() : null;
    }

    public Config getConfig() {
        return this.configCache.updateAndGet(this::buildConfigIfAbsent);
    }

    public boolean shouldWatchForChange() {
        return this.reloadStrategy != null;
    }

    public ReloadStrategy getReloadStrategy() {
        return this.reloadStrategy;
    }

    public void reload() {
        this.configCache.set(this.buildConfigIfAbsent(null));
    }

    @Override
    public KeyValueClient getKeyValueClient() {
        return this.kvClient;
    }

    @Override
    public String getPathToWatch() {
        return this.configurationFilePath;
    }

    @Override
    public Duration getWatchTimeout() {
        return this.watchTimeout;
    }

    private Config buildConfigIfAbsent(Config currentConfig) {
        if (currentConfig != null) {
            return currentConfig;
        }
        Optional configurationFile = this.kvClient.getValueAsString(this.configurationFilePath);
        if (configurationFile.isPresent()) {
            return ConfigFactory.parseString((String)((String)configurationFile.get()));
        }
        logger.debug("Missing configuration file at path: {}, ignore flag set to: {}", (Object)this.configurationFilePath, (Object)this.ignoreMissingResource);
        if (this.ignoreMissingResource) {
            return ConfigFactory.empty();
        }
        throw new IllegalStateException("Missing required configuration resource at path: " + this.configurationFilePath);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Duration watchTimeout = Duration.ofSeconds(10L);
        private Consul.Builder consulBuilder = Consul.builder().withReadTimeoutMillis(Duration.ofSeconds(30L).toMillis());
        private String configurationFilePath;
        private boolean ignoreMissingResource;
        private boolean reloadOnChange;

        private Builder() {
        }

        public Builder withConsulUrl(String consulUrl) {
            if (!consulUrl.startsWith("http")) {
                consulUrl = "http://" + consulUrl;
            }
            this.consulBuilder.withUrl(consulUrl);
            return this;
        }

        public Builder withAclToken(String aclToken) {
            this.consulBuilder.withAclToken(aclToken);
            return this;
        }

        public Builder withBasicAuth(String username, String password) {
            this.consulBuilder.withBasicAuth(username, password);
            return this;
        }

        public Builder withConnectTimeout(Duration connectTimeout) {
            this.consulBuilder.withConnectTimeoutMillis(connectTimeout.toMillis());
            return this;
        }

        public Builder withReadTimeout(Duration readTimeout) {
            this.consulBuilder.withReadTimeoutMillis(readTimeout.toMillis());
            return this;
        }

        public Builder withWatchTimeout(Duration watchTimeout) {
            this.watchTimeout = watchTimeout;
            return this;
        }

        public Builder withConfigurationFilePath(String configurationFilePath) {
            this.configurationFilePath = configurationFilePath;
            return this;
        }

        public Builder ignoreMissingResource() {
            this.ignoreMissingResource = true;
            return this;
        }

        public Builder reloadOnChange() {
            this.reloadOnChange = true;
            return this;
        }

        public ConsulFileConfigurationSource build() {
            Consul consul = this.consulBuilder.build();
            KeyValueClient kvClient = consul.keyValueClient();
            return new ConsulFileConfigurationSource(kvClient, this.configurationFilePath, this.ignoreMissingResource, this.reloadOnChange, this.watchTimeout);
        }
    }
}

