/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.maven.plugin;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.congocc.app.Main;

@Mojo(name="ccc-generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GeneratorMojo
extends AbstractMojo {
    private static final PathMatcher GRAMMAR_FILE_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*.ccc");
    private static final PathMatcher GRAMMAR_FRAGMENTS_FILE_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*.{*.ccc}");
    @Component
    private MavenProject project;
    @Parameter(property="sourceDirectory", defaultValue="${project.basedir}/src/main/congocc")
    Path sourceDirectory;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/congocc")
    Path outputDirectory;
    @Parameter(property="lang", defaultValue="java")
    String lang;
    @Parameter(property="jdk", defaultValue="8")
    int jdk;
    @Parameter(property="quiet", defaultValue="false")
    boolean quiet;
    private Map<String, String> symbols = new HashMap<String, String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!Files.isDirectory(this.sourceDirectory, new LinkOption[0])) {
                return;
            }
            boolean compile = this.hasChangesToCompile();
            if (compile) {
                List<Path> grammars = this.findGrammarFiles();
                this.getLog().info((CharSequence)(grammars.size() + " grammar(s) found > " + grammars.stream().map(p -> p.toFile().getName()).collect(Collectors.joining(", "))));
                for (Path path : grammars) {
                    int returnValue = Main.mainProgram((Path)path, (Path)this.outputDirectory, (String)this.lang, (int)this.jdk, (boolean)this.quiet, this.symbols);
                    this.getLog().info((CharSequence)("return: " + returnValue));
                }
            } else {
                this.getLog().info((CharSequence)"Thera are not changes to compile ");
            }
            this.project.addCompileSourceRoot(this.outputDirectory.normalize().toString());
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("CongoCC failure", e);
        }
    }

    private List<Path> findGrammarFiles() throws IOException {
        return Files.walk(this.sourceDirectory, new FileVisitOption[0]).filter(GRAMMAR_FILE_MATCHER::matches).filter(path -> !GRAMMAR_FRAGMENTS_FILE_MATCHER.matches((Path)path)).collect(Collectors.toList());
    }

    private boolean hasChangesToCompile() throws IOException {
        long sourceTimestamp = Files.walk(this.sourceDirectory, new FileVisitOption[0]).filter(GRAMMAR_FILE_MATCHER::matches).map(path -> path.toFile().lastModified()).max(Long::compareTo).orElse(-1L);
        long generatedTimestamp = Files.isDirectory(this.outputDirectory, new LinkOption[0]) ? Files.walk(this.outputDirectory, new FileVisitOption[0]).map(path -> path.toFile().lastModified()).max(Long::compareTo).orElse(-1L) : -1L;
        return sourceTimestamp > generatedTimestamp;
    }
}

