/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.dropwizard.camel;

import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.component.metrics.messagehistory.MetricsMessageHistoryFactory;
import org.apache.camel.component.metrics.routepolicy.MetricsRoutePolicyFactory;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.DefaultRegistry;
import org.connectorio.dropwizard.camel.CamelConfiguration;
import org.connectorio.dropwizard.camel.CamelDropwizardLifecycle;
import org.connectorio.dropwizard.camel.hk2.MapPropertiesSource;
import org.connectorio.dropwizard.camel.hk2.MapRepository;

public abstract class CamelBundle<T extends CamelConfiguration>
implements ConfiguredBundle<T> {
    private final String name;
    private DefaultCamelContext context;

    public CamelBundle() {
        this(null);
    }

    public CamelBundle(String name) {
        this.name = name;
    }

    public void run(T configuration, Environment environment) throws Exception {
        this.context = new DefaultCamelContext();
        Optional.ofNullable(this.name).ifPresent(arg_0 -> ((DefaultCamelContext)this.context).setName(arg_0));
        Map<String, Object> properties = configuration.getProperties();
        this.context.getPropertiesComponent().addPropertiesSource((PropertiesSource)new MapPropertiesSource(properties));
        this.context.setRegistry((Registry)new DefaultRegistry(new BeanRepository[]{new MapRepository(this.getBeans(properties))}));
        MetricsRoutePolicyFactory routePolicyFactory = new MetricsRoutePolicyFactory();
        routePolicyFactory.setMetricsRegistry(environment.metrics());
        this.context.addRoutePolicyFactory((RoutePolicyFactory)routePolicyFactory);
        MetricsMessageHistoryFactory messageHistoryFactory = new MetricsMessageHistoryFactory();
        messageHistoryFactory.setMetricsRegistry(environment.metrics());
        this.context.setMessageHistoryFactory((MessageHistoryFactory)messageHistoryFactory);
        environment.lifecycle().manage((Managed)new CamelDropwizardLifecycle((CamelContext)this.context));
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public CamelContext getContext() {
        return (CamelContext)Objects.requireNonNull(this.context);
    }

    protected abstract Map<String, Object> getBeans(Map<String, Object> var1);
}

