/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.dropwizard.camel.hk2;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.spi.BeanRepository;

public class MapRepository
implements BeanRepository {
    private final Map<String, Object> beans;

    public MapRepository(Map<String, Object> beans) {
        this.beans = beans;
    }

    public Object lookupByName(String name) {
        return this.beans.get(name);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object value = this.beans.get(name);
        return type.isInstance(value) ? (T)type.cast(value) : null;
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        return this.beans.entrySet().stream().filter(e -> type.isInstance(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> type.cast(e.getValue()), (e1, e2) -> e1));
    }

    public <T> Set<T> findByType(Class<T> type) {
        return this.beans.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toSet());
    }
}

