/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.EqualsHashCodeBuilder;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.ldap.LdapConstants;
import org.identityconnectors.ldap.LdapUtil;
import org.identityconnectors.ldap.ObjectClassMappingConfig;

public class LdapConfiguration
extends AbstractConfiguration {
    static final int DEFAULT_PORT = 389;
    private String host;
    private int port = 389;
    private boolean ssl;
    private String[] failover = new String[0];
    private String principal;
    private GuardedString credentials;
    private String[] baseContexts = new String[0];
    private String passwordAttribute = "userPassword";
    private String accountSearchFilter = null;
    private String groupMemberAttribute = "uniqueMember";
    private boolean maintainLdapGroupMembership = false;
    private boolean maintainPosixGroupMembership = false;
    private String passwordHashAlgorithm;
    private boolean respectResourcePasswordPolicyChangeAfterReset;
    private boolean useBlocks = true;
    private int blockSize = 100;
    private boolean usePagedResultControl = false;
    private String vlvSortAttribute = "uid";
    private String uidAttribute = "entryUUID";
    private boolean readSchema = true;
    private String[] baseContextsToSynchronize = new String[0];
    private String[] objectClassesToSynchronize = new String[]{"inetOrgPerson"};
    private String[] attributesToSynchronize = new String[0];
    private String[] modifiersNamesToFilterOut = new String[0];
    private String accountSynchronizationFilter;
    private int changeLogBlockSize = 100;
    private String changeNumberAttribute = "changeNumber";
    private boolean filterWithOrInsteadOfAnd;
    private boolean removeLogEntryObjectClassFromFilter = true;
    private boolean synchronizePasswords;
    private String passwordAttributeToSynchronize;
    private GuardedByteArray passwordDecryptionKey;
    private GuardedByteArray passwordDecryptionInitializationVector;
    private final ObjectClassMappingConfig accountConfig = new ObjectClassMappingConfig(ObjectClass.ACCOUNT, CollectionUtil.newList((Object[])new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"}), false, CollectionUtil.newList((Object[])new String[]{"uid", "cn"}), LdapConstants.PASSWORD);
    private final ObjectClassMappingConfig groupConfig = new ObjectClassMappingConfig(ObjectClass.GROUP, CollectionUtil.newList((Object[])new String[]{"top", "groupOfUniqueNames"}), false, Collections.<String>emptyList(), new AttributeInfo[0]);
    private List<LdapName> baseContextsAsLdapNames;
    private List<LdapName> baseContextsToSynchronizeAsLdapNames;
    private Set<LdapName> modifiersNamesToFilterOutAsLdapNames;

    public void validate() {
        this.checkNotBlank(this.host, "host.notBlank");
        if (this.port < 0 || this.port > 65535) {
            this.failValidation("port.legalValue", new Object[0]);
        }
        this.checkNotEmpty(this.baseContexts, "baseContexts.notEmpty");
        this.checkNoBlankValues(this.baseContexts, "baseContexts.noBlankValues");
        this.checkNoInvalidLdapNames(this.baseContexts, "baseContexts.noInvalidLdapNames");
        this.checkNotBlank(this.passwordAttribute, "passwordAttribute.notBlank");
        this.checkNotEmpty(this.accountConfig.getLdapClasses(), "accountObjectClasses.notEmpty");
        this.checkNoBlankValues(this.accountConfig.getLdapClasses(), "accountObjectClasses.noBlankValues");
        this.checkNotEmpty(this.accountConfig.getShortNameLdapAttributes(), "accountUserNameAttributes.notEmpty");
        this.checkNoBlankValues(this.accountConfig.getShortNameLdapAttributes(), "accountUserNameAttributes.noBlankValues");
        this.checkNotBlank(this.groupMemberAttribute, "groupMemberAttribute.notBlank");
        if (this.blockSize <= 0) {
            this.failValidation("blockSize.legalValue", new Object[0]);
        }
        this.checkNotBlank(this.vlvSortAttribute, "vlvSortAttribute.notBlank");
        this.checkNotBlank(this.uidAttribute, "uidAttribute.notBlank");
        if (this.baseContextsToSynchronize != null) {
            this.checkNoBlankValues(this.baseContextsToSynchronize, "baseContextsToSynchronize.noBlankValues");
            this.checkNoInvalidLdapNames(this.baseContextsToSynchronize, "baseContextsToSynchronize.noInvalidLdapNames");
        }
        this.checkNotEmpty(this.objectClassesToSynchronize, "objectClassesToSynchronize.notEmpty");
        this.checkNoBlankValues(this.objectClassesToSynchronize, "objectClassesToSynchronize.noBlankValues");
        if (this.attributesToSynchronize != null) {
            this.checkNoBlankValues(this.attributesToSynchronize, "attributesToSynchronize.noBlankValues");
        }
        if (this.modifiersNamesToFilterOut != null) {
            this.checkNoBlankValues(this.modifiersNamesToFilterOut, "modifiersNamesToFilterOut.noBlankValues");
            this.checkNoInvalidLdapNames(this.modifiersNamesToFilterOut, "modifiersNamesToFilterOut.noInvalidLdapNames");
        }
        this.checkNotBlank(this.changeNumberAttribute, "changeNumberAttribute.notBlank");
        if (this.changeLogBlockSize <= 0) {
            this.failValidation("changeLogBlockSize.legalValue", new Object[0]);
        }
        if (this.synchronizePasswords) {
            this.checkNotBlank(this.passwordAttributeToSynchronize, "passwordAttributeToSynchronize.notBlank");
            this.checkNotBlank(this.passwordDecryptionKey, "decryptionKey.notBlank");
            this.checkNotBlank(this.passwordDecryptionInitializationVector, "decryptionInitializationVector.notBlank");
        }
    }

    private void checkNotBlank(String value, String errorMessage) {
        if (StringUtil.isBlank((String)value)) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNotBlank(GuardedByteArray array, String errorMessage) {
        final int[] length = new int[]{0};
        if (array != null) {
            array.access(new GuardedByteArray.Accessor(){

                public void access(byte[] clearBytes) {
                    length[0] = clearBytes.length;
                }
            });
        }
        if (length[0] == 0) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNotEmpty(Collection<?> collection, String errorMessage) {
        if (collection.size() < 1) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNotEmpty(String[] array, String errorMessage) {
        if (array == null || array.length < 1) {
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNoBlankValues(Collection<String> collection, String errorMessage) {
        for (String each : collection) {
            if (!StringUtil.isBlank((String)each)) continue;
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNoBlankValues(String[] array, String errorMessage) {
        for (String each : array) {
            if (!StringUtil.isBlank((String)each)) continue;
            this.failValidation(errorMessage, new Object[0]);
        }
    }

    private void checkNoInvalidLdapNames(String[] array, String errorMessage) {
        for (String each : array) {
            try {
                new LdapName(each);
            }
            catch (InvalidNameException e) {
                this.failValidation(errorMessage, each);
            }
        }
    }

    private void failValidation(String key, Object ... args) {
        String message = this.getConnectorMessages().format(key, null, args);
        throw new ConfigurationException(message);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String[] getFailover() {
        return (String[])this.failover.clone();
    }

    public void setFailover(String ... failover) {
        this.failover = failover;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @ConfigurationProperty(confidential=true)
    public GuardedString getCredentials() {
        return this.credentials;
    }

    public void setCredentials(GuardedString credentials) {
        this.credentials = credentials != null ? credentials.copy() : null;
    }

    public String[] getBaseContexts() {
        return (String[])this.baseContexts.clone();
    }

    public void setBaseContexts(String ... baseContexts) {
        this.baseContexts = (String[])baseContexts.clone();
    }

    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    public String[] getAccountObjectClasses() {
        List<String> ldapClasses = this.accountConfig.getLdapClasses();
        return ldapClasses.toArray(new String[ldapClasses.size()]);
    }

    public void setAccountObjectClasses(String ... accountObjectClasses) {
        this.accountConfig.setLdapClasses(Arrays.asList(accountObjectClasses));
    }

    public String[] getAccountUserNameAttributes() {
        List<String> shortNameLdapAttributes = this.accountConfig.getShortNameLdapAttributes();
        return shortNameLdapAttributes.toArray(new String[shortNameLdapAttributes.size()]);
    }

    public void setAccountUserNameAttributes(String ... accountUserNameAttributes) {
        this.accountConfig.setShortNameLdapAttributes(Arrays.asList(accountUserNameAttributes));
    }

    public String getAccountSearchFilter() {
        return this.accountSearchFilter;
    }

    public void setAccountSearchFilter(String accountSearchFilter) {
        this.accountSearchFilter = accountSearchFilter;
    }

    public String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    public void setGroupMemberAttribute(String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
    }

    public boolean isMaintainLdapGroupMembership() {
        return this.maintainLdapGroupMembership;
    }

    public void setMaintainLdapGroupMembership(boolean maintainLdapGroupMembership) {
        this.maintainLdapGroupMembership = maintainLdapGroupMembership;
    }

    public boolean isMaintainPosixGroupMembership() {
        return this.maintainPosixGroupMembership;
    }

    public void setMaintainPosixGroupMembership(boolean maintainPosixGroupMembership) {
        this.maintainPosixGroupMembership = maintainPosixGroupMembership;
    }

    public String getPasswordHashAlgorithm() {
        return this.passwordHashAlgorithm;
    }

    public void setPasswordHashAlgorithm(String passwordHashAlgorithm) {
        this.passwordHashAlgorithm = passwordHashAlgorithm;
    }

    public boolean isRespectResourcePasswordPolicyChangeAfterReset() {
        return this.respectResourcePasswordPolicyChangeAfterReset;
    }

    public void setRespectResourcePasswordPolicyChangeAfterReset(boolean respectResourcePasswordPolicyChangeAfterReset) {
        this.respectResourcePasswordPolicyChangeAfterReset = respectResourcePasswordPolicyChangeAfterReset;
    }

    public boolean isUseBlocks() {
        return this.useBlocks;
    }

    public void setUseBlocks(boolean useBlocks) {
        this.useBlocks = useBlocks;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public boolean isUsePagedResultControl() {
        return this.usePagedResultControl;
    }

    public void setUsePagedResultControl(boolean usePagedResultControl) {
        this.usePagedResultControl = usePagedResultControl;
    }

    public String getVlvSortAttribute() {
        return this.vlvSortAttribute;
    }

    public void setVlvSortAttribute(String vlvSortAttribute) {
        this.vlvSortAttribute = vlvSortAttribute;
    }

    public String getUidAttribute() {
        return this.uidAttribute;
    }

    public void setUidAttribute(String uidAttribute) {
        this.uidAttribute = uidAttribute;
    }

    public boolean isReadSchema() {
        return this.readSchema;
    }

    public void setReadSchema(boolean readSchema) {
        this.readSchema = readSchema;
    }

    @ConfigurationProperty(operations={SyncOp.class})
    public String[] getBaseContextsToSynchronize() {
        return (String[])this.baseContextsToSynchronize.clone();
    }

    public void setBaseContextsToSynchronize(String ... baseContextsToSynchronize) {
        this.baseContextsToSynchronize = (String[])baseContextsToSynchronize.clone();
    }

    @ConfigurationProperty(operations={SyncOp.class}, required=true)
    public String[] getObjectClassesToSynchronize() {
        return (String[])this.objectClassesToSynchronize.clone();
    }

    public void setObjectClassesToSynchronize(String ... objectClassesToSynchronize) {
        this.objectClassesToSynchronize = (String[])objectClassesToSynchronize.clone();
    }

    @ConfigurationProperty(operations={SyncOp.class})
    public String[] getAttributesToSynchronize() {
        return (String[])this.attributesToSynchronize.clone();
    }

    public void setAttributesToSynchronize(String ... attributesToSynchronize) {
        this.attributesToSynchronize = (String[])attributesToSynchronize.clone();
    }

    @ConfigurationProperty(operations={SyncOp.class})
    public String[] getModifiersNamesToFilterOut() {
        return (String[])this.modifiersNamesToFilterOut.clone();
    }

    public void setModifiersNamesToFilterOut(String ... modifiersNamesToFilterOut) {
        this.modifiersNamesToFilterOut = (String[])modifiersNamesToFilterOut.clone();
    }

    @ConfigurationProperty(operations={SyncOp.class})
    public String getAccountSynchronizationFilter() {
        return this.accountSynchronizationFilter;
    }

    public void setAccountSynchronizationFilter(String accountSynchronizationFilter) {
        this.accountSynchronizationFilter = accountSynchronizationFilter;
    }

    @ConfigurationProperty(operations={SyncOp.class}, required=true)
    public int getChangeLogBlockSize() {
        return this.changeLogBlockSize;
    }

    public void setChangeLogBlockSize(int changeLogBlockSize) {
        this.changeLogBlockSize = changeLogBlockSize;
    }

    @ConfigurationProperty(operations={SyncOp.class}, required=true)
    public String getChangeNumberAttribute() {
        return this.changeNumberAttribute;
    }

    public void setChangeNumberAttribute(String changeNumberAttribute) {
        this.changeNumberAttribute = changeNumberAttribute;
    }

    @ConfigurationProperty(operations={SyncOp.class})
    public boolean isFilterWithOrInsteadOfAnd() {
        return this.filterWithOrInsteadOfAnd;
    }

    public void setFilterWithOrInsteadOfAnd(boolean filterWithOrInsteadOfAnd) {
        this.filterWithOrInsteadOfAnd = filterWithOrInsteadOfAnd;
    }

    @ConfigurationProperty(operations={SyncOp.class})
    public boolean isRemoveLogEntryObjectClassFromFilter() {
        return this.removeLogEntryObjectClassFromFilter;
    }

    public void setRemoveLogEntryObjectClassFromFilter(boolean removeLogEntryObjectClassFromFilter) {
        this.removeLogEntryObjectClassFromFilter = removeLogEntryObjectClassFromFilter;
    }

    @ConfigurationProperty(operations={SyncOp.class})
    public boolean isSynchronizePasswords() {
        return this.synchronizePasswords;
    }

    public void setSynchronizePasswords(boolean synchronizePasswords) {
        this.synchronizePasswords = synchronizePasswords;
    }

    @ConfigurationProperty(operations={SyncOp.class})
    public String getPasswordAttributeToSynchronize() {
        return this.passwordAttributeToSynchronize;
    }

    public void setPasswordAttributeToSynchronize(String passwordAttributeToSynchronize) {
        this.passwordAttributeToSynchronize = passwordAttributeToSynchronize;
    }

    @ConfigurationProperty(operations={SyncOp.class}, confidential=true)
    public GuardedByteArray getPasswordDecryptionKey() {
        return this.passwordDecryptionKey;
    }

    public void setPasswordDecryptionKey(GuardedByteArray passwordDecryptionKey) {
        this.passwordDecryptionKey = passwordDecryptionKey != null ? passwordDecryptionKey.copy() : null;
    }

    @ConfigurationProperty(operations={SyncOp.class}, confidential=true)
    public GuardedByteArray getPasswordDecryptionInitializationVector() {
        return this.passwordDecryptionInitializationVector;
    }

    public void setPasswordDecryptionInitializationVector(GuardedByteArray passwordDecryptionInitializationVector) {
        this.passwordDecryptionInitializationVector = passwordDecryptionInitializationVector != null ? passwordDecryptionInitializationVector.copy() : null;
    }

    public List<LdapName> getBaseContextsAsLdapNames() {
        if (this.baseContextsAsLdapNames == null) {
            ArrayList<LdapName> result = new ArrayList<LdapName>(this.baseContexts.length);
            try {
                for (String baseContext : this.baseContexts) {
                    result.add(new LdapName(baseContext));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException((Throwable)e);
            }
            this.baseContextsAsLdapNames = result;
        }
        return this.baseContextsAsLdapNames;
    }

    public List<LdapName> getBaseContextsToSynchronizeAsLdapNames() {
        if (this.baseContextsToSynchronizeAsLdapNames == null) {
            String[] source = LdapUtil.nullAsEmpty(this.baseContextsToSynchronize);
            ArrayList<LdapName> result = new ArrayList<LdapName>(source.length);
            try {
                for (String each : source) {
                    result.add(new LdapName(each));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException((Throwable)e);
            }
            this.baseContextsToSynchronizeAsLdapNames = result;
        }
        return this.baseContextsToSynchronizeAsLdapNames;
    }

    public Set<LdapName> getModifiersNamesToFilterOutAsLdapNames() {
        if (this.modifiersNamesToFilterOutAsLdapNames == null) {
            String[] source = LdapUtil.nullAsEmpty(this.modifiersNamesToFilterOut);
            HashSet<LdapName> result = new HashSet<LdapName>(source.length);
            try {
                for (String each : source) {
                    result.add(new LdapName(each));
                }
            }
            catch (InvalidNameException e) {
                throw new ConfigurationException((Throwable)e);
            }
            this.modifiersNamesToFilterOutAsLdapNames = result;
        }
        return this.modifiersNamesToFilterOutAsLdapNames;
    }

    public Map<ObjectClass, ObjectClassMappingConfig> getObjectClassMappingConfigs() {
        HashMap<ObjectClass, ObjectClassMappingConfig> result = new HashMap<ObjectClass, ObjectClassMappingConfig>();
        result.put(this.accountConfig.getObjectClass(), this.accountConfig);
        result.put(this.groupConfig.getObjectClass(), this.groupConfig);
        return result;
    }

    private EqualsHashCodeBuilder createHashCodeBuilder() {
        EqualsHashCodeBuilder builder = new EqualsHashCodeBuilder();
        builder.append((Object)this.host);
        builder.append((Object)this.port);
        builder.append((Object)this.ssl);
        builder.append((Object)this.failover);
        builder.append((Object)this.principal);
        builder.append((Object)this.credentials);
        for (String baseContext : this.baseContexts) {
            builder.append((Object)baseContext);
        }
        builder.append((Object)this.passwordAttribute);
        builder.append((Object)this.accountSearchFilter);
        builder.append((Object)this.groupMemberAttribute);
        builder.append((Object)this.maintainLdapGroupMembership);
        builder.append((Object)this.maintainPosixGroupMembership);
        builder.append((Object)this.passwordHashAlgorithm);
        builder.append((Object)this.respectResourcePasswordPolicyChangeAfterReset);
        builder.append((Object)this.useBlocks);
        builder.append((Object)this.blockSize);
        builder.append((Object)this.usePagedResultControl);
        builder.append((Object)this.vlvSortAttribute);
        builder.append((Object)this.uidAttribute);
        builder.append((Object)this.readSchema);
        for (String baseContextToSynchronize : this.baseContextsToSynchronize) {
            builder.append((Object)baseContextToSynchronize);
        }
        for (String objectClassToSynchronize : this.objectClassesToSynchronize) {
            builder.append((Object)objectClassToSynchronize);
        }
        for (String attributeToSynchronize : this.attributesToSynchronize) {
            builder.append((Object)attributeToSynchronize);
        }
        for (String modifiersNameToFilterOut : this.modifiersNamesToFilterOut) {
            builder.append((Object)modifiersNameToFilterOut);
        }
        builder.append((Object)this.accountSynchronizationFilter);
        builder.append((Object)this.changeLogBlockSize);
        builder.append((Object)this.changeNumberAttribute);
        builder.append((Object)this.filterWithOrInsteadOfAnd);
        builder.append((Object)this.removeLogEntryObjectClassFromFilter);
        builder.append((Object)this.synchronizePasswords);
        builder.append((Object)this.passwordAttributeToSynchronize);
        builder.append((Object)this.passwordDecryptionKey);
        builder.append((Object)this.passwordDecryptionInitializationVector);
        builder.append((Object)this.accountConfig);
        builder.append((Object)this.groupConfig);
        return builder;
    }

    public int hashCode() {
        return this.createHashCodeBuilder().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LdapConfiguration) {
            LdapConfiguration that = (LdapConfiguration)((Object)obj);
            if (this == that) {
                return true;
            }
            return this.createHashCodeBuilder().equals((Object)that.createHashCodeBuilder());
        }
        return false;
    }
}

