/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.ldap.modify;

import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttributes;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.ldap.GroupHelper;
import org.identityconnectors.ldap.LdapConnection;
import org.identityconnectors.ldap.LdapConstants;
import org.identityconnectors.ldap.LdapModifyOperation;
import org.identityconnectors.ldap.LdapUtil;
import org.identityconnectors.ldap.schema.GuardedPasswordAttribute;

public class LdapCreate
extends LdapModifyOperation {
    private final ObjectClass oclass;
    private final Set<Attribute> attrs;

    public LdapCreate(LdapConnection conn, ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        super(conn);
        this.oclass = oclass;
        this.attrs = attrs;
    }

    public Uid execute() {
        try {
            return this.executeImpl();
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private Uid executeImpl() throws NamingException {
        final Name nameAttr = AttributeUtil.getNameFromAttributes(this.attrs);
        if (nameAttr == null) {
            throw new IllegalArgumentException("No Name attribute provided in the attributes");
        }
        List<String> ldapGroups = null;
        List<String> posixGroups = null;
        GuardedPasswordAttribute pwdAttr = null;
        final BasicAttributes ldapAttrs = new BasicAttributes(true);
        for (Attribute attr : this.attrs) {
            javax.naming.directory.Attribute ldapAttr = null;
            if (attr.is(Name.NAME)) continue;
            if (LdapConstants.isLdapGroups(attr.getName())) {
                ldapGroups = LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)attr.getValue()), String.class);
                continue;
            }
            if (LdapConstants.isPosixGroups(attr.getName())) {
                posixGroups = LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)attr.getValue()), String.class);
                continue;
            }
            if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
                pwdAttr = this.conn.getSchemaMapping().encodePassword(this.oclass, attr);
                continue;
            }
            ldapAttr = this.conn.getSchemaMapping().encodeAttribute(this.oclass, attr);
            if (ldapAttr == null || ldapAttr.size() <= 0) continue;
            ldapAttrs.put(ldapAttr);
        }
        final String[] entryDN = new String[]{null};
        if (pwdAttr != null) {
            pwdAttr.access(new GuardedPasswordAttribute.Accessor(){

                @Override
                public void access(javax.naming.directory.Attribute passwordAttr) {
                    LdapCreate.this.hashPassword(passwordAttr, null);
                    ldapAttrs.put(passwordAttr);
                    entryDN[0] = LdapCreate.this.conn.getSchemaMapping().create(LdapCreate.this.oclass, nameAttr, ldapAttrs);
                }
            });
        } else {
            entryDN[0] = this.conn.getSchemaMapping().create(this.oclass, nameAttr, ldapAttrs);
        }
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.addLdapGroupMemberships(entryDN[0], ldapGroups);
        }
        if (!CollectionUtil.isEmpty(posixGroups)) {
            Set<String> posixRefAttrs = LdapCreate.getAttributeValues(GroupHelper.getPosixRefAttribute(), null, ldapAttrs);
            String posixRefAttr = this.getFirstPosixRefAttr(entryDN[0], posixRefAttrs);
            this.groupHelper.addPosixGroupMemberships(posixRefAttr, posixGroups);
        }
        return this.conn.getSchemaMapping().createUid(this.oclass, entryDN[0]);
    }
}

