/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.ldap.commons;

import java.util.EnumSet;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;

public class LdapConstants {
    public static final String LDAP_GROUPS_NAME = "ldapGroups";
    public static final String POSIX_GROUPS_NAME = "posixGroups";
    public static final String LDAP_UID_ATTRS_NAME = "ldap_uid_attributes";
    public static final String SEARCH_FILTER_NAME = "searchFilter";
    public static final String OP_SEARCH_FILTER = "searchFilter";
    public static final AttributeInfo PASSWORD = AttributeInfoBuilder.build((String)OperationalAttributes.PASSWORD_NAME, GuardedString.class, EnumSet.of(AttributeInfo.Flags.NOT_RETURNED_BY_DEFAULT));

    public static boolean isLdapGroups(String attrName) {
        return LDAP_GROUPS_NAME.equalsIgnoreCase(attrName);
    }

    public static boolean isPosixGroups(String attrName) {
        return POSIX_GROUPS_NAME.equalsIgnoreCase(attrName);
    }

    public static String[] getLdapUidAttributes(OperationOptions options) {
        return (String[])options.getOptions().get(LDAP_UID_ATTRS_NAME);
    }

    public static String getSearchFilter(OperationOptions options) {
        return (String)options.getOptions().get("searchFilter");
    }

    private LdapConstants() {
    }
}

