/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.ldap.modify;

import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.ldap.LdapConnection;
import org.identityconnectors.ldap.commons.GroupHelper;
import org.identityconnectors.ldap.commons.LdapModifyOperation;
import org.identityconnectors.ldap.search.LdapSearches;

public class LdapDelete
extends LdapModifyOperation {
    private final ObjectClass oclass;
    private final Uid uid;

    public LdapDelete(LdapConnection conn, ObjectClass oclass, Uid uid) {
        super(conn);
        this.oclass = oclass;
        this.uid = uid;
    }

    public void execute() {
        String entryDN = LdapSearches.getEntryDN(this.conn, this.oclass, this.uid);
        if (this.conn.getConfiguration().isMaintainLdapGroupMembership()) {
            List<String> ldapGroups = this.groupHelper.getLdapGroups(entryDN);
            this.groupHelper.removeLdapGroupMemberships(entryDN, ldapGroups);
        }
        if (this.conn.getConfiguration().isMaintainPosixGroupMembership()) {
            LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(entryDN);
            Set<GroupHelper.GroupMembership> memberships = posixMember.getPosixGroupMemberships();
            this.groupHelper.removePosixGroupMemberships(memberships);
        }
        try {
            this.conn.getInitialContext().destroySubcontext(entryDN);
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }
}

