/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.ldap.modify;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.Pair;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.ldap.LdapConnection;
import org.identityconnectors.ldap.commons.GroupHelper;
import org.identityconnectors.ldap.commons.LdapConstants;
import org.identityconnectors.ldap.commons.LdapModifyOperation;
import org.identityconnectors.ldap.commons.LdapUtil;
import org.identityconnectors.ldap.commons.StatusManagement;
import org.identityconnectors.ldap.schema.GuardedPasswordAttribute;
import org.identityconnectors.ldap.search.LdapSearches;

public class LdapUpdate
extends LdapModifyOperation {
    private final ObjectClass oclass;
    private Uid uid;

    public LdapUpdate(LdapConnection conn, ObjectClass oclass, Uid uid) {
        super(conn);
        this.oclass = oclass;
        this.uid = uid;
    }

    public Uid update(Set<Attribute> attrs) {
        Set<GroupHelper.GroupMembership> members;
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(entryDN);
        Set updateAttrs = attrs;
        Name newName = (Name)AttributeUtil.find((String)Name.NAME, attrs);
        Attribute status = AttributeUtil.find((String)OperationalAttributes.ENABLE_NAME, attrs);
        String newEntryDN = null;
        if (newName != null) {
            updateAttrs = CollectionUtil.newSet(attrs);
            updateAttrs.remove(newName);
            newEntryDN = this.conn.getSchemaMapping().getEntryDN(this.oclass, newName);
        }
        List<String> ldapGroups = this.getStringListValue(updateAttrs, "ldapGroups");
        List<String> posixGroups = this.getStringListValue(updateAttrs, "posixGroups");
        Pair<Attributes, GuardedPasswordAttribute> attrToModify = this.getAttributesToModify(updateAttrs);
        Attributes ldapAttrs = (Attributes)attrToModify.first;
        Set<String> newPosixRefAttrs = LdapUpdate.getAttributeValues(GroupHelper.getPosixRefAttribute(), LdapUtil.quietCreateLdapName(newEntryDN != null ? newEntryDN : entryDN), ldapAttrs);
        if (newPosixRefAttrs != null && newPosixRefAttrs.isEmpty()) {
            this.checkRemovedPosixRefAttrs(posixMember.getPosixRefAttributes(), posixMember.getPosixGroupMemberships());
        }
        if (status != null && status.getValue() != null && !status.getValue().isEmpty()) {
            StatusManagement.getInstance(this.conn.getConfiguration().getStatusManagementClass()).setStatus((Boolean)status.getValue().get(0), ldapAttrs, posixGroups, ldapGroups);
        }
        this.modifyAttributes(entryDN, attrToModify, 2);
        String oldEntryDN = null;
        if (newName != null) {
            if (newPosixRefAttrs != null && this.conn.getConfiguration().isMaintainPosixGroupMembership() || posixGroups != null) {
                posixMember.getPosixRefAttributes();
            }
            oldEntryDN = entryDN;
            entryDN = this.conn.getSchemaMapping().rename(this.oclass, oldEntryDN, newName);
        }
        GroupHelper.Modification<GroupHelper.GroupMembership> ldapGroupMod = new GroupHelper.Modification<GroupHelper.GroupMembership>();
        if (oldEntryDN != null && this.conn.getConfiguration().isMaintainLdapGroupMembership()) {
            members = this.groupHelper.getLdapGroupMemberships(oldEntryDN);
            ldapGroupMod.removeAll(members);
            for (GroupHelper.GroupMembership member : members) {
                ldapGroupMod.add(new GroupHelper.GroupMembership(entryDN, member.getGroupDN()));
            }
        }
        if (ldapGroups != null) {
            members = this.groupHelper.getLdapGroupMemberships(entryDN);
            ldapGroupMod.removeAll(members);
            ldapGroupMod.clearAdded();
            for (String ldapGroup : ldapGroups) {
                ldapGroupMod.add(new GroupHelper.GroupMembership(entryDN, ldapGroup));
            }
        }
        this.groupHelper.modifyLdapGroupMemberships(ldapGroupMod);
        GroupHelper.Modification<GroupHelper.GroupMembership> posixGroupMod = new GroupHelper.Modification<GroupHelper.GroupMembership>();
        if (newPosixRefAttrs != null && this.conn.getConfiguration().isMaintainPosixGroupMembership()) {
            HashSet<String> removedPosixRefAttrs = new HashSet<String>(posixMember.getPosixRefAttributes());
            removedPosixRefAttrs.removeAll(newPosixRefAttrs);
            Set<GroupHelper.GroupMembership> members2 = posixMember.getPosixGroupMembershipsByAttrs(removedPosixRefAttrs);
            posixGroupMod.removeAll(members2);
            if (!members2.isEmpty()) {
                String firstPosixRefAttr = this.getFirstPosixRefAttr(entryDN, newPosixRefAttrs);
                for (GroupHelper.GroupMembership member : members2) {
                    posixGroupMod.add(new GroupHelper.GroupMembership(firstPosixRefAttr, member.getGroupDN()));
                }
            }
        }
        if (posixGroups != null) {
            Set<GroupHelper.GroupMembership> members3 = posixMember.getPosixGroupMemberships();
            posixGroupMod.removeAll(members3);
            posixGroupMod.clearAdded();
            if (!posixGroups.isEmpty()) {
                String firstPosixRefAttr = this.getFirstPosixRefAttr(entryDN, newPosixRefAttrs);
                for (String posixGroup : posixGroups) {
                    posixGroupMod.add(new GroupHelper.GroupMembership(firstPosixRefAttr, posixGroup));
                }
            }
        }
        this.groupHelper.modifyPosixGroupMemberships(posixGroupMod);
        return this.conn.getSchemaMapping().createUid(this.oclass, entryDN);
    }

    public Uid addAttributeValues(Set<Attribute> attrs) {
        List<String> posixGroups;
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(entryDN);
        Pair<Attributes, GuardedPasswordAttribute> attrsToModify = this.getAttributesToModify(attrs);
        this.modifyAttributes(entryDN, attrsToModify, 1);
        List<String> ldapGroups = this.getStringListValue(attrs, "ldapGroups");
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.addLdapGroupMemberships(entryDN, ldapGroups);
        }
        if (!CollectionUtil.isEmpty(posixGroups = this.getStringListValue(attrs, "posixGroups"))) {
            Set<String> posixRefAttrs = posixMember.getPosixRefAttributes();
            String posixRefAttr = this.getFirstPosixRefAttr(entryDN, posixRefAttrs);
            this.groupHelper.addPosixGroupMemberships(posixRefAttr, posixGroups);
        }
        return this.uid;
    }

    public Uid removeAttributeValues(Set<Attribute> attrs) {
        List<String> posixGroups;
        String entryDN = LdapSearches.findEntryDN(this.conn, this.oclass, this.uid);
        LdapModifyOperation.PosixGroupMember posixMember = new LdapModifyOperation.PosixGroupMember(entryDN);
        Pair<Attributes, GuardedPasswordAttribute> attrsToModify = this.getAttributesToModify(attrs);
        Attributes ldapAttrs = (Attributes)attrsToModify.first;
        Set<String> removedPosixRefAttrs = LdapUpdate.getAttributeValues(GroupHelper.getPosixRefAttribute(), null, ldapAttrs);
        if (!CollectionUtil.isEmpty(removedPosixRefAttrs)) {
            this.checkRemovedPosixRefAttrs(removedPosixRefAttrs, posixMember.getPosixGroupMemberships());
        }
        this.modifyAttributes(entryDN, attrsToModify, 3);
        List<String> ldapGroups = this.getStringListValue(attrs, "ldapGroups");
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.removeLdapGroupMemberships(entryDN, ldapGroups);
        }
        if (!CollectionUtil.isEmpty(posixGroups = this.getStringListValue(attrs, "posixGroups"))) {
            Set<GroupHelper.GroupMembership> members = posixMember.getPosixGroupMembershipsByGroups(posixGroups);
            this.groupHelper.removePosixGroupMemberships(members);
        }
        return this.uid;
    }

    private void checkRemovedPosixRefAttrs(Set<String> removedPosixRefAttrs, Set<GroupHelper.GroupMembership> memberships) {
        for (GroupHelper.GroupMembership membership : memberships) {
            if (!removedPosixRefAttrs.contains(membership.getMemberRef())) continue;
            throw new ConnectorException(this.conn.format("cannotRemoveBecausePosixMember", GroupHelper.getPosixRefAttribute(), new Object[0]));
        }
    }

    private Pair<Attributes, GuardedPasswordAttribute> getAttributesToModify(Set<Attribute> attrs) {
        BasicAttributes ldapAttrs = new BasicAttributes();
        GuardedPasswordAttribute pwdAttr = null;
        for (Attribute attr : attrs) {
            javax.naming.directory.Attribute ldapAttr = null;
            if (attr.is(Uid.NAME)) {
                throw new IllegalArgumentException("Unable to modify an object's uid");
            }
            if (attr.is(Name.NAME)) {
                throw new IllegalArgumentException("Unable to modify an object's name");
            }
            if (!LdapConstants.isLdapGroups(attr.getName()) && !LdapConstants.isPosixGroups(attr.getName())) {
                if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
                    pwdAttr = this.conn.getSchemaMapping().encodePassword(this.oclass, attr);
                } else {
                    ldapAttr = this.conn.getSchemaMapping().encodeAttribute(this.oclass, attr);
                }
            }
            if (ldapAttr == null) continue;
            javax.naming.directory.Attribute existingAttr = ldapAttrs.get(ldapAttr.getID());
            if (existingAttr != null) {
                try {
                    NamingEnumeration<?> all = ldapAttr.getAll();
                    while (all.hasMoreElements()) {
                        existingAttr.add(all.nextElement());
                    }
                    continue;
                }
                catch (NamingException e) {
                    throw new ConnectorException((Throwable)e);
                }
            }
            ldapAttrs.put(ldapAttr);
        }
        return new Pair((Object)ldapAttrs, pwdAttr);
    }

    private void modifyAttributes(final String entryDN, Pair<Attributes, GuardedPasswordAttribute> attrs, final int ldapModifyOp) {
        final ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>(((Attributes)attrs.first).size());
        NamingEnumeration<? extends javax.naming.directory.Attribute> attrEnum = ((Attributes)attrs.first).getAll();
        while (attrEnum.hasMoreElements()) {
            modItems.add(new ModificationItem(ldapModifyOp, (javax.naming.directory.Attribute)attrEnum.nextElement()));
        }
        if (attrs.second != null) {
            ((GuardedPasswordAttribute)attrs.second).access(new GuardedPasswordAttribute.Accessor(){

                @Override
                public void access(javax.naming.directory.Attribute passwordAttr) {
                    LdapUpdate.this.hashPassword(passwordAttr, entryDN);
                    modItems.add(new ModificationItem(ldapModifyOp, passwordAttr));
                    LdapUpdate.this.modifyAttributes(entryDN, modItems);
                }
            });
        } else {
            this.modifyAttributes(entryDN, modItems);
        }
    }

    private void modifyAttributes(String entryDN, List<ModificationItem> modItems) {
        try {
            this.conn.getInitialContext().modifyAttributes(entryDN, modItems.toArray(new ModificationItem[modItems.size()]));
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private List<String> getStringListValue(Set<Attribute> attrs, String attrName) {
        Attribute attr = AttributeUtil.find((String)attrName, attrs);
        if (attr != null) {
            return LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)attr.getValue()), String.class);
        }
        return null;
    }
}

