/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.ldap.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.QualifiedUid;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.ldap.LdapConnection;
import org.identityconnectors.ldap.commons.GroupHelper;
import org.identityconnectors.ldap.commons.LdapConstants;
import org.identityconnectors.ldap.commons.LdapEntry;
import org.identityconnectors.ldap.commons.LdapUtil;
import org.identityconnectors.ldap.commons.StatusManagement;
import org.identityconnectors.ldap.schema.LdapSchemaMapping;
import org.identityconnectors.ldap.search.DefaultSearchStrategy;
import org.identityconnectors.ldap.search.LdapFilter;
import org.identityconnectors.ldap.search.LdapInternalSearch;
import org.identityconnectors.ldap.search.LdapSearchStrategy;
import org.identityconnectors.ldap.search.LdapSearches;
import org.identityconnectors.ldap.search.SearchResultsHandler;
import org.identityconnectors.ldap.search.SimplePagedSearchStrategy;
import org.identityconnectors.ldap.search.VlvIndexSearchStrategy;

public class LdapSearch {
    private static final Log log = Log.getLog(LdapSearch.class);
    private final LdapConnection conn;
    private final ObjectClass oclass;
    private final LdapFilter filter;
    private final OperationOptions options;
    private final GroupHelper groupHelper;
    private final String[] baseDNs;

    public static Set<String> getAttributesReturnedByDefault(LdapConnection conn, ObjectClass oclass) {
        if (oclass.equals((Object)LdapSchemaMapping.ANY_OBJECT_CLASS)) {
            return CollectionUtil.newSet((Object[])new String[]{Name.NAME});
        }
        SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        ObjectClassInfo oci = conn.getSchemaMapping().schema().findObjectClassInfo(oclass.getObjectClassValue());
        if (oci != null) {
            for (AttributeInfo info : oci.getAttributeInfo()) {
                if (!info.isReturnedByDefault()) continue;
                result.add(info.getName());
            }
        }
        return result;
    }

    public LdapSearch(LdapConnection conn, ObjectClass oclass, LdapFilter filter, OperationOptions options) {
        this(conn, oclass, filter, options, conn.getConfiguration().getBaseContexts());
    }

    public LdapSearch(LdapConnection conn, ObjectClass oclass, LdapFilter filter, OperationOptions options, String ... baseDNs) {
        this.conn = conn;
        this.oclass = oclass;
        this.filter = filter;
        this.options = options;
        this.baseDNs = baseDNs;
        this.groupHelper = new GroupHelper(conn);
    }

    public final void execute(final ResultsHandler handler) {
        final String[] attrsToGetOption = this.options.getAttributesToGet();
        final Set<String> attrsToGet = this.getAttributesToGet(attrsToGetOption);
        LdapInternalSearch search = this.getInternalSearch(attrsToGet);
        search.execute(new SearchResultsHandler(){

            @Override
            public boolean handle(String baseDN, SearchResult result) throws NamingException {
                return handler.handle(LdapSearch.this.createConnectorObject(baseDN, result, attrsToGet, attrsToGetOption != null));
            }
        });
    }

    public final ConnectorObject getSingleResult() {
        final String[] attrsToGetOption = this.options.getAttributesToGet();
        final Set<String> attrsToGet = this.getAttributesToGet(attrsToGetOption);
        final ConnectorObject[] results = new ConnectorObject[]{null};
        LdapInternalSearch search = this.getInternalSearch(attrsToGet);
        search.execute(new SearchResultsHandler(){

            @Override
            public boolean handle(String baseDN, SearchResult result) throws NamingException {
                results[0] = LdapSearch.this.createConnectorObject(baseDN, result, attrsToGet, attrsToGetOption != null);
                return false;
            }
        });
        return results[0];
    }

    private LdapInternalSearch getInternalSearch(Set<String> attrsToGet) {
        int searchScope;
        List<String> dns;
        LdapSearchStrategy strategy;
        String filterEntryDN;
        String string = filterEntryDN = this.filter != null ? this.filter.getEntryDN() : null;
        if (filterEntryDN != null) {
            strategy = new DefaultSearchStrategy(true);
            dns = Collections.singletonList(filterEntryDN);
            searchScope = 0;
        } else {
            strategy = this.getSearchStrategy();
            dns = this.getBaseDNs();
            searchScope = this.getLdapSearchScope();
        }
        SearchControls controls = LdapInternalSearch.createDefaultSearchControls();
        Set<String> ldapAttrsToGet = this.getLdapAttributesToGet(attrsToGet);
        controls.setReturningAttributes(ldapAttrsToGet.toArray(new String[ldapAttrsToGet.size()]));
        controls.setSearchScope(searchScope);
        String optionsFilter = LdapConstants.getSearchFilter(this.options);
        String userFilter = null;
        if (this.oclass.equals((Object)ObjectClass.ACCOUNT)) {
            userFilter = this.conn.getConfiguration().getAccountSearchFilter();
        }
        String nativeFilter = this.filter != null ? this.filter.getNativeFilter() : null;
        return new LdapInternalSearch(this.conn, this.getSearchFilter(optionsFilter, nativeFilter, userFilter), dns, strategy, controls);
    }

    private Set<String> getLdapAttributesToGet(Set<String> attrsToGet) {
        SortedSet cleanAttrsToGet = CollectionUtil.newCaseInsensitiveSet();
        cleanAttrsToGet.addAll(attrsToGet);
        cleanAttrsToGet.remove("ldapGroups");
        boolean posixGroups = cleanAttrsToGet.remove("posixGroups");
        Set<String> result = this.conn.getSchemaMapping().getLdapAttributes(this.oclass, cleanAttrsToGet, true);
        if (posixGroups) {
            result.add(GroupHelper.getPosixRefAttribute());
        }
        result.addAll(StatusManagement.getInstance(this.conn.getConfiguration().getStatusManagementClass()).getOperationalAttributes());
        result.removeAll(LdapEntry.ENTRY_DN_ATTRS);
        return result;
    }

    private ConnectorObject createConnectorObject(String baseDN, SearchResult result, Set<String> attrsToGet, boolean emptyAttrWhenNotFound) {
        LdapEntry entry = LdapEntry.create(baseDN, result);
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(this.oclass);
        builder.setUid(this.conn.getSchemaMapping().createUid(this.oclass, entry));
        builder.setName(this.conn.getSchemaMapping().createName(this.oclass, entry));
        ArrayList<String> ldapGroups = new ArrayList<String>();
        ArrayList<String> posixGroups = new ArrayList<String>();
        for (String attrName : attrsToGet) {
            Attribute attribute = null;
            if (LdapConstants.isLdapGroups(attrName)) {
                ldapGroups.addAll(this.groupHelper.getLdapGroups(entry.getDN().toString()));
                attribute = AttributeBuilder.build((String)"ldapGroups", ldapGroups);
            } else if (LdapConstants.isPosixGroups(attrName)) {
                Set<String> posixRefAttrs = LdapUtil.getStringAttrValues(entry.getAttributes(), GroupHelper.getPosixRefAttribute());
                posixGroups.addAll(this.groupHelper.getPosixGroups(posixRefAttrs));
                attribute = AttributeBuilder.build((String)"posixGroups", posixGroups);
            } else {
                attribute = LdapConstants.PASSWORD.is(attrName) ? AttributeBuilder.build((String)attrName, (Object[])new Object[]{new GuardedString()}) : this.conn.getSchemaMapping().createAttribute(this.oclass, attrName, entry, emptyAttrWhenNotFound);
            }
            if (attribute == null) continue;
            builder.addAttribute(new Attribute[]{attribute});
        }
        Boolean status = StatusManagement.getInstance(this.conn.getConfiguration().getStatusManagementClass()).getStatus(result.getAttributes(), posixGroups, ldapGroups);
        if (status != null) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.buildEnabled((boolean)status)});
        }
        return builder.build();
    }

    private String getSearchFilter(String ... optionalFilters) {
        StringBuilder builder = new StringBuilder();
        String ocFilter = this.getObjectClassFilter();
        int nonBlank = StringUtil.isBlank((String)ocFilter) ? 0 : 1;
        for (String optionalFilter : optionalFilters) {
            nonBlank += StringUtil.isBlank((String)optionalFilter) ? 0 : 1;
        }
        if (nonBlank > 1) {
            builder.append("(&");
        }
        LdapSearch.appendFilter(ocFilter, builder);
        for (String optionalFilter : optionalFilters) {
            LdapSearch.appendFilter(optionalFilter, builder);
        }
        if (nonBlank > 1) {
            builder.append(')');
        }
        return builder.toString();
    }

    private String getObjectClassFilter() {
        boolean and;
        StringBuilder builder = new StringBuilder();
        List<String> ldapClasses = this.conn.getSchemaMapping().getLdapClasses(this.oclass);
        boolean bl = and = ldapClasses.size() > 1;
        if (and) {
            builder.append("(&");
        }
        for (String ldapClass : ldapClasses) {
            builder.append("(objectClass=");
            builder.append(ldapClass);
            builder.append(')');
        }
        if (and) {
            builder.append(')');
        }
        return builder.toString();
    }

    private static void appendFilter(String filter, StringBuilder toBuilder) {
        if (!StringUtil.isBlank((String)filter)) {
            boolean enclose;
            String trimmedUserFilter = filter.trim();
            boolean bl = enclose = filter.charAt(0) != '(';
            if (enclose) {
                toBuilder.append('(');
            }
            toBuilder.append(trimmedUserFilter);
            if (enclose) {
                toBuilder.append(')');
            }
        }
    }

    private List<String> getBaseDNs() {
        QualifiedUid container = this.options.getContainer();
        List<String> result = container != null ? Collections.singletonList(LdapSearches.findEntryDN(this.conn, container.getObjectClass(), container.getUid())) : Arrays.asList(this.baseDNs);
        assert (result != null);
        return result;
    }

    private LdapSearchStrategy getSearchStrategy() {
        LdapSearchStrategy strategy;
        if (ObjectClass.ACCOUNT.equals((Object)this.oclass)) {
            boolean useBlocks = this.conn.getConfiguration().isUseBlocks();
            boolean usePagedResultsControl = this.conn.getConfiguration().isUsePagedResultControl();
            int pageSize = this.conn.getConfiguration().getBlockSize();
            if (useBlocks && !usePagedResultsControl && this.conn.supportsControl("2.16.840.1.113730.3.4.9")) {
                String vlvSortAttr = this.conn.getConfiguration().getVlvSortAttribute();
                strategy = new VlvIndexSearchStrategy(vlvSortAttr, pageSize);
            } else {
                strategy = useBlocks && this.conn.supportsControl("1.2.840.113556.1.4.319") ? new SimplePagedSearchStrategy(pageSize) : new DefaultSearchStrategy(false);
            }
        } else {
            strategy = new DefaultSearchStrategy(false);
        }
        return strategy;
    }

    private Set<String> getAttributesToGet(String[] attributesToGet) {
        Set<Object> result;
        if (attributesToGet != null) {
            result = CollectionUtil.newCaseInsensitiveSet();
            result.addAll(Arrays.asList(attributesToGet));
            this.removeNonReadableAttributes(result);
            result.add(Name.NAME);
        } else {
            result = LdapSearch.getAttributesReturnedByDefault(this.conn, this.oclass);
        }
        result.add(Uid.NAME);
        if (result.contains(OperationalAttributes.PASSWORD_NAME)) {
            log.warn("Reading passwords not supported", new Object[0]);
        }
        return result;
    }

    private void removeNonReadableAttributes(Set<String> attributes) {
        boolean ldapGroups = attributes.remove("ldapGroups");
        boolean posixGroups = attributes.remove("posixGroups");
        this.conn.getSchemaMapping().removeNonReadableAttributes(this.oclass, attributes);
        if (ldapGroups) {
            attributes.add("ldapGroups");
        }
        if (posixGroups) {
            attributes.add("posixGroups");
        }
    }

    private int getLdapSearchScope() {
        String scope = this.options.getScope();
        if ("object".equals(scope)) {
            return 0;
        }
        if ("onelevel".equals(scope)) {
            return 1;
        }
        if ("subtree".equals(scope) || scope == null) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid search scope " + scope);
    }
}

