/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.ldap.search;

import java.io.IOException;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.ldap.LdapConnection;
import org.identityconnectors.ldap.search.LdapSearchStrategy;
import org.identityconnectors.ldap.search.SearchResultsHandler;

public class LdapInternalSearch {
    private final LdapConnection conn;
    private final String filter;
    private final List<String> baseDNs;
    private final LdapSearchStrategy strategy;
    private final SearchControls controls;

    public LdapInternalSearch(LdapConnection conn, String filter, List<String> baseDNs, LdapSearchStrategy strategy, SearchControls controls) {
        this.conn = conn;
        this.filter = filter;
        this.baseDNs = baseDNs;
        this.strategy = strategy;
        this.controls = controls;
    }

    public void execute(SearchResultsHandler handler) {
        String filter = LdapInternalSearch.blankAsAllObjects(this.filter);
        try {
            this.strategy.doSearch(this.conn.getInitialContext(), this.baseDNs, filter, this.controls, handler);
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private static String blankAsAllObjects(String query) {
        return StringUtil.isNotBlank((String)query) ? query : "(objectClass=*)";
    }

    public static SearchControls createDefaultSearchControls() {
        SearchControls result = new SearchControls();
        result.setCountLimit(0L);
        result.setDerefLinkFlag(true);
        result.setReturningObjFlag(false);
        result.setTimeLimit(0);
        return result;
    }
}

