/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.ldap.commons;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.connid.bundles.ldap.commons.StatusManagement;

public class AttributeStatusManagement
extends StatusManagement {
    protected static final String ATTR_NAME = "description";
    protected static final String ATTR_VALUE_ACTIVE = "Active";
    protected static final String ATTR_VALUE_INACTIVE = "Inactive";

    @Override
    public void setStatus(boolean status, Attributes attributes, List<String> posixGroups, List<String> ldapGroups) {
        Attribute description = attributes.get(ATTR_NAME);
        if (description == null) {
            description = new BasicAttribute(ATTR_NAME);
            attributes.put(description);
        }
        description.add(status ? ATTR_VALUE_ACTIVE : ATTR_VALUE_INACTIVE);
    }

    @Override
    public Boolean getStatus(Attributes attributes, List<String> posixGroups, List<String> ldapGroups) {
        Boolean status = null;
        Attribute description = attributes.get(ATTR_NAME);
        if (description != null) {
            try {
                Object value = description.get();
                if (value != null) {
                    status = ATTR_VALUE_ACTIVE.equals(value.toString());
                }
            }
            catch (NamingException ignore) {
                // empty catch block
            }
        }
        return status;
    }

    @Override
    public Set<String> getOperationalAttributes() {
        return Collections.singleton(ATTR_NAME);
    }
}

