/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.ldap.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.connid.bundles.ldap.LdapConnection;
import org.connid.bundles.ldap.commons.LdapEntry;
import org.connid.bundles.ldap.commons.LdapUtil;
import org.connid.bundles.ldap.search.LdapSearches;
import org.connid.bundles.ldap.search.SearchResultsHandler;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class GroupHelper {
    private static final Log log = Log.getLog(GroupHelper.class);
    private final LdapConnection conn;

    public GroupHelper(LdapConnection conn) {
        this.conn = conn;
    }

    public static String getPosixRefAttribute() {
        return "uid";
    }

    private String getLdapGroupMemberAttribute() {
        String memberAttr = this.conn.getConfiguration().getGroupMemberAttribute();
        if (memberAttr == null) {
            memberAttr = "uniqueMember";
        }
        return memberAttr;
    }

    public List<String> getLdapGroups(String entryDN) {
        log.ok("Retrieving LDAP groups for {0}", new Object[]{entryDN});
        String filter = this.createAttributeFilter(this.getLdapGroupMemberAttribute(), Collections.singletonList(entryDN));
        ToDNHandler handler = new ToDNHandler();
        LdapSearches.findEntries(handler, this.conn, filter, new String[0]);
        return handler.getResults();
    }

    public Set<GroupMembership> getLdapGroupMemberships(String entryDN) {
        log.ok("Retrieving LDAP group memberships for {0}", new Object[]{entryDN});
        String filter = this.createAttributeFilter(this.getLdapGroupMemberAttribute(), Collections.singletonList(entryDN));
        ToGroupMembershipHandler handler = new ToGroupMembershipHandler();
        handler.setMemberRef(entryDN);
        LdapSearches.findEntries(handler, this.conn, filter, new String[0]);
        return handler.getResults();
    }

    public void addLdapGroupMemberships(String entryDN, Collection<String> groupDNs) {
        log.ok("Adding {0} to LDAP groups {1}", new Object[]{entryDN, groupDNs});
        String ldapGroupMemberAttribute = this.getLdapGroupMemberAttribute();
        for (String groupDN : groupDNs) {
            this.addMemberToGroup(ldapGroupMemberAttribute, entryDN, groupDN);
        }
    }

    public void removeLdapGroupMemberships(String entryDN, Collection<String> groupDNs) {
        log.ok("Removing {0} from LDAP groups {1}", new Object[]{entryDN, groupDNs});
        String ldapGroupMemberAttribute = this.getLdapGroupMemberAttribute();
        for (String groupDN : groupDNs) {
            this.removeMemberFromGroup(ldapGroupMemberAttribute, entryDN, groupDN);
        }
    }

    public void modifyLdapGroupMemberships(Modification<GroupMembership> mod) {
        log.ok("Modifying LDAP group memberships: removing {0}, adding {1}", new Object[]{mod.getRemoved(), mod.getAdded()});
        String ldapGroupMemberAttribute = this.getLdapGroupMemberAttribute();
        for (GroupMembership membership : mod.getRemoved()) {
            this.removeMemberFromGroup(ldapGroupMemberAttribute, membership.getMemberRef(), membership.getGroupDN());
        }
        for (GroupMembership membership : mod.getAdded()) {
            this.addMemberToGroup(ldapGroupMemberAttribute, membership.getMemberRef(), membership.getGroupDN());
        }
    }

    public List<String> getPosixGroups(Collection<String> posixRefAttrs) {
        log.ok("Retrieving POSIX groups for {0}", new Object[]{posixRefAttrs});
        String filter = this.createAttributeFilter("memberUid", posixRefAttrs);
        ToDNHandler handler = new ToDNHandler();
        LdapSearches.findEntries(handler, this.conn, filter, new String[0]);
        return handler.getResults();
    }

    public Set<GroupMembership> getPosixGroupMemberships(Collection<String> posixRefAttrs) {
        log.ok("Retrieving POSIX group memberships for ", new Object[]{posixRefAttrs});
        ToGroupMembershipHandler handler = new ToGroupMembershipHandler();
        for (String posixRefAttr : posixRefAttrs) {
            String filter = this.createAttributeFilter("memberUid", Collections.singletonList(posixRefAttr));
            handler.setMemberRef(posixRefAttr);
            LdapSearches.findEntries(handler, this.conn, filter, new String[0]);
        }
        return handler.getResults();
    }

    public void addPosixGroupMemberships(String posixRefAttr, Collection<String> groupDNs) {
        log.ok("Adding {0} to POSIX groups {1}", new Object[]{posixRefAttr, groupDNs});
        for (String groupDN : groupDNs) {
            this.addMemberToGroup("memberUid", posixRefAttr, groupDN);
        }
    }

    public void removePosixGroupMemberships(Set<GroupMembership> memberships) {
        log.ok("Removing POSIX group memberships {0}", new Object[]{memberships});
        for (GroupMembership membership : memberships) {
            this.removeMemberFromGroup("memberUid", membership.getMemberRef(), membership.getGroupDN());
        }
    }

    public void modifyPosixGroupMemberships(Modification<GroupMembership> mod) {
        log.ok("Modifying POSIX group memberships: removing {0}, adding {1}", new Object[]{mod.getRemoved(), mod.getAdded()});
        for (GroupMembership membership : mod.getRemoved()) {
            this.removeMemberFromGroup("memberUid", membership.getMemberRef(), membership.getGroupDN());
        }
        for (GroupMembership membership : mod.getAdded()) {
            this.addMemberToGroup("memberUid", membership.getMemberRef(), membership.getGroupDN());
        }
    }

    private String createAttributeFilter(String memberAttr, Collection<?> memberValues) {
        boolean multi;
        StringBuilder builder = new StringBuilder();
        boolean bl = multi = memberValues.size() > 1;
        if (multi) {
            builder.append("(|");
        }
        for (Object memberValue : memberValues) {
            builder.append('(');
            builder.append(memberAttr);
            builder.append('=');
            LdapUtil.escapeAttrValue(memberValue, builder);
            builder.append(')');
        }
        if (multi) {
            builder.append(")");
        }
        return builder.toString();
    }

    private void addMemberToGroup(String memberAttr, String memberValue, String groupDN) {
        BasicAttribute attr = new BasicAttribute(memberAttr, memberValue);
        ModificationItem item = new ModificationItem(1, attr);
        try {
            this.conn.getInitialContext().modifyAttributes(groupDN, new ModificationItem[]{item});
        }
        catch (AttributeInUseException e) {
            throw new ConnectorException(this.conn.format("memberAlreadyInGroup", null, memberValue, groupDN), (Throwable)e);
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private void removeMemberFromGroup(String memberAttr, String memberValue, String groupDN) {
        BasicAttribute attr = new BasicAttribute(memberAttr, memberValue);
        ModificationItem item = new ModificationItem(3, attr);
        try {
            this.conn.getInitialContext().modifyAttributes(groupDN, new ModificationItem[]{item});
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private static final class ToGroupMembershipHandler
    implements SearchResultsHandler {
        private final Set<GroupMembership> results = new HashSet<GroupMembership>();
        private String memberRef;

        public void setMemberRef(String memberRef) {
            this.memberRef = memberRef;
        }

        @Override
        public boolean handle(String baseDN, SearchResult searchResult) throws NamingException {
            LdapName groupDN = LdapEntry.create(baseDN, searchResult).getDN();
            this.results.add(new GroupMembership(this.memberRef, groupDN.toString()));
            return true;
        }

        public Set<GroupMembership> getResults() {
            return this.results;
        }
    }

    private static final class ToDNHandler
    implements SearchResultsHandler {
        private final List<String> results = new ArrayList<String>();

        private ToDNHandler() {
        }

        @Override
        public boolean handle(String baseDN, SearchResult searchResult) throws NamingException {
            this.results.add(LdapEntry.create(baseDN, searchResult).getDN().toString());
            return true;
        }

        public List<String> getResults() {
            return this.results;
        }
    }

    public static final class Modification<T> {
        private final Set<T> removed = new LinkedHashSet<T>();
        private final Set<T> added = new LinkedHashSet<T>();
        private Set<T> effectiveAdded;
        private Set<T> effectiveRemoved;

        public void add(T item) {
            this.added.add(item);
            this.invalidate();
        }

        public void addAll(Collection<? extends T> items) {
            for (T item : items) {
                this.added.add(item);
            }
            this.invalidate();
        }

        public void clearAdded() {
            this.added.clear();
            this.invalidate();
        }

        public Set<T> getAdded() {
            if (this.effectiveAdded == null) {
                this.effectiveAdded = new LinkedHashSet<T>(this.added);
                this.effectiveAdded.removeAll(this.removed);
            }
            return this.effectiveAdded;
        }

        public void remove(T item) {
            this.removed.add(item);
            this.invalidate();
        }

        public void removeAll(Collection<? extends T> items) {
            for (T item : items) {
                this.removed.add(item);
            }
            this.invalidate();
        }

        public Set<T> getRemoved() {
            if (this.effectiveRemoved == null) {
                this.effectiveRemoved = new LinkedHashSet<T>(this.removed);
                this.effectiveRemoved.removeAll(this.added);
            }
            return this.effectiveRemoved;
        }

        private void invalidate() {
            this.effectiveAdded = null;
            this.effectiveRemoved = null;
        }
    }

    public static final class GroupMembership {
        private final String memberRef;
        private final String groupDN;

        public GroupMembership(String memberRef, String groupDn) {
            this.memberRef = memberRef;
            this.groupDN = groupDn;
        }

        public String getMemberRef() {
            return this.memberRef;
        }

        public String getGroupDN() {
            return this.groupDN;
        }

        public int hashCode() {
            return this.memberRef.hashCode() ^ this.groupDN.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof GroupMembership) {
                GroupMembership that = (GroupMembership)o;
                if (!this.memberRef.equals(that.memberRef)) {
                    return false;
                }
                return this.groupDN.equals(that.groupDN);
            }
            return false;
        }

        public String toString() {
            return "GroupMembership[memberRef: " + this.memberRef + "; groupDN: " + this.groupDN + "]";
        }
    }
}

