/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.ldap.commons;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class LdapUtil {
    private static final String LDAP_BINARY_OPTION = ";binary";

    private LdapUtil() {
    }

    public static boolean attrNameEquals(String name1, String name2) {
        if (name1 == null) {
            return name2 == null;
        }
        return name1.equalsIgnoreCase(name2);
    }

    public static boolean hasBinaryOption(String ldapAttrName) {
        return ldapAttrName.toLowerCase(Locale.US).endsWith(LDAP_BINARY_OPTION);
    }

    public static String addBinaryOption(String ldapAttrName) {
        if (!LdapUtil.hasBinaryOption(ldapAttrName)) {
            return ldapAttrName + LDAP_BINARY_OPTION;
        }
        return ldapAttrName;
    }

    public static String removeBinaryOption(String ldapAttrName) {
        if (LdapUtil.hasBinaryOption(ldapAttrName)) {
            return ldapAttrName.substring(0, ldapAttrName.length() - LDAP_BINARY_OPTION.length());
        }
        return ldapAttrName;
    }

    public static String getStringAttrValue(Attributes ldapAttrs, String ldapAttrName) {
        Attribute attr = ldapAttrs.get(ldapAttrName);
        if (attr != null) {
            try {
                return (String)attr.get();
            }
            catch (NamingException e) {
                throw new ConnectorException((Throwable)e);
            }
        }
        return null;
    }

    public static Set<String> getStringAttrValues(Attributes ldapAttrs, String ldapAttrName) {
        HashSet<String> result = new HashSet<String>();
        LdapUtil.addStringAttrValues(ldapAttrs, ldapAttrName, result);
        return result;
    }

    public static void addStringAttrValues(Attributes ldapAttrs, String ldapAttrName, Set<String> toSet) {
        Attribute attr = ldapAttrs.get(ldapAttrName);
        if (attr == null) {
            return;
        }
        try {
            NamingEnumeration<?> attrEnum = attr.getAll();
            while (attrEnum.hasMore()) {
                toSet.add((String)attrEnum.next());
            }
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public static boolean escapeAttrValue(Object value, StringBuilder toBuilder) {
        if (value == null) {
            return false;
        }
        if (value instanceof byte[]) {
            return LdapUtil.escapeByteArrayAttrValue((byte[])value, toBuilder);
        }
        return LdapUtil.escapeStringAttrValue(value.toString(), toBuilder);
    }

    private static boolean escapeByteArrayAttrValue(byte[] bytes, StringBuilder toBuilder) {
        if (bytes.length == 0) {
            return false;
        }
        for (byte b : bytes) {
            toBuilder.append('\\');
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() < 2) {
                toBuilder.append('0');
            }
            toBuilder.append(hex);
        }
        return true;
    }

    private static boolean escapeStringAttrValue(String string, StringBuilder toBuilder) {
        if (StringUtil.isEmpty((String)string)) {
            return false;
        }
        block7: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '*': {
                    toBuilder.append("\\2a");
                    continue block7;
                }
                case '(': {
                    toBuilder.append("\\28");
                    continue block7;
                }
                case ')': {
                    toBuilder.append("\\29");
                    continue block7;
                }
                case '\\': {
                    toBuilder.append("\\5c");
                    continue block7;
                }
                case '\u0000': {
                    toBuilder.append("\\00");
                    continue block7;
                }
                default: {
                    toBuilder.append(ch);
                }
            }
        }
        return true;
    }

    public static LdapName quietCreateLdapName(String ldapName) {
        try {
            return new LdapName(ldapName);
        }
        catch (InvalidNameException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public static boolean isUnderContexts(LdapName entry, List<LdapName> contexts) {
        for (LdapName context : contexts) {
            if (!entry.startsWith(context)) continue;
            return true;
        }
        return false;
    }

    public static String[] nullAsEmpty(String[] array) {
        if (array == null) {
            return new String[0];
        }
        return array;
    }

    public static <T> List<T> checkedListByFilter(List list, Class<T> clazz) {
        return new CheckedListByFilter<T>(list, clazz);
    }

    private static final class CheckedListByFilter<E>
    implements List<E> {
        private final List list;
        private final Class<E> clazz;

        public CheckedListByFilter(List list, Class<E> clazz) {
            this.clazz = clazz;
            this.list = list;
        }

        private E cast(Object o) {
            return this.clazz.cast(o);
        }

        @Override
        public boolean add(E o) {
            return this.list.add(o);
        }

        @Override
        public void add(int index, E element) {
            this.list.add(index, element);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.list.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            return this.list.addAll(index, c);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public E get(int index) {
            return this.cast(this.list.get(index));
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new Itr(this.list.iterator());
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ListItr(this.list.listIterator());
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new ListItr(this.list.listIterator(index));
        }

        @Override
        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        @Override
        public E remove(int index) {
            return this.cast(this.list.remove(index));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.list.retainAll(c);
        }

        @Override
        public E set(int index, E element) {
            return this.cast(this.list.set(index, element));
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result;
            for (T o : result = this.list.toArray(a)) {
                this.cast(o);
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return ((Object)this.list).equals(obj);
        }

        @Override
        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        public String toString() {
            return this.list.toString();
        }

        private final class ListItr
        implements ListIterator<E> {
            private final ListIterator iter;

            public ListItr(ListIterator iter) {
                this.iter = iter;
            }

            @Override
            public void add(E o) {
                this.iter.add(o);
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.iter.hasPrevious();
            }

            @Override
            public E next() {
                return CheckedListByFilter.this.cast(this.iter.next());
            }

            @Override
            public int nextIndex() {
                return this.iter.nextIndex();
            }

            @Override
            public E previous() {
                return CheckedListByFilter.this.cast(this.iter.previous());
            }

            @Override
            public int previousIndex() {
                return this.iter.previousIndex();
            }

            @Override
            public void remove() {
                this.iter.remove();
            }

            @Override
            public void set(E o) {
                this.iter.set(o);
            }

            public boolean equals(Object obj) {
                return this.iter.equals(obj);
            }

            public int hashCode() {
                return this.iter.hashCode();
            }

            public String toString() {
                return this.iter.toString();
            }
        }

        private final class Itr
        implements Iterator<E> {
            private final Iterator iter;

            public Itr(Iterator iter) {
                this.iter = iter;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public E next() {
                return CheckedListByFilter.this.cast(this.iter.next());
            }

            @Override
            public void remove() {
                this.iter.remove();
            }

            public boolean equals(Object obj) {
                return this.iter.equals(obj);
            }

            public int hashCode() {
                return this.iter.hashCode();
            }

            public String toString() {
                return this.iter.toString();
            }
        }
    }
}

