/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.ldap.search;

public final class LdapFilter {
    private final String nativeFilter;
    private final String entryDN;

    public static LdapFilter forEntryDN(String entryDN) {
        return new LdapFilter(null, entryDN);
    }

    public static LdapFilter forNativeFilter(String nativeFilter) {
        return new LdapFilter(nativeFilter, null);
    }

    private LdapFilter(String nativeFilter, String entryDN) {
        this.nativeFilter = nativeFilter;
        this.entryDN = entryDN;
    }

    public LdapFilter withNativeFilter(String nativeFilter) {
        return new LdapFilter(nativeFilter, this.entryDN);
    }

    public String getNativeFilter() {
        return this.nativeFilter;
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public LdapFilter and(LdapFilter other) {
        if (this.entryDN == null || other.entryDN == null) {
            return new LdapFilter(LdapFilter.combine(this.nativeFilter, other.nativeFilter, '&'), this.entryDN != null ? this.entryDN : other.entryDN);
        }
        return null;
    }

    public LdapFilter or(LdapFilter other) {
        if (this.entryDN == null && other.entryDN == null) {
            return new LdapFilter(LdapFilter.combine(this.nativeFilter, other.nativeFilter, '|'), null);
        }
        return null;
    }

    private static String combine(String left, String right, char op) {
        if (left != null) {
            if (right != null) {
                StringBuilder builder = new StringBuilder();
                builder.append('(');
                builder.append(op);
                builder.append(left);
                builder.append(right);
                builder.append(')');
                return builder.toString();
            }
            return left;
        }
        return right;
    }

    public boolean equals(Object o) {
        if (o instanceof LdapFilter) {
            LdapFilter that = (LdapFilter)o;
            if (this.nativeFilter == null ? that.nativeFilter != null : !this.nativeFilter.equals(that.nativeFilter)) {
                return false;
            }
            return !(this.entryDN == null ? that.entryDN != null : !this.entryDN.equals(that.entryDN));
        }
        return false;
    }

    public int hashCode() {
        return (this.nativeFilter != null ? this.nativeFilter.hashCode() : 0) ^ (this.entryDN != null ? this.entryDN.hashCode() : 0);
    }

    public String toString() {
        return "LdapFilter[nativeFilter: " + this.nativeFilter + "; entryDN: " + this.entryDN + "]";
    }
}

