/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.ldap.commons;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.connid.bundles.ldap.LdapConnection;
import org.connid.bundles.ldap.commons.LdapAttributeType;
import org.connid.bundles.ldap.commons.LdapNativeSchema;
import org.connid.bundles.ldap.commons.LdapUtil;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;

public class ServerNativeSchema
implements LdapNativeSchema {
    private static final Set<String> LDAP_DIRECTORY_ATTRS = CollectionUtil.newCaseInsensitiveSet();
    private final LdapConnection conn;
    private final DirContext schemaCtx;
    private final Set<String> structuralLdapClasses = CollectionUtil.newCaseInsensitiveSet();
    private final Map<String, Set<String>> ldapClass2MustAttrs = CollectionUtil.newCaseInsensitiveMap();
    private final Map<String, Set<String>> ldapClass2MayAttrs = CollectionUtil.newCaseInsensitiveMap();
    private final Map<String, Set<String>> ldapClass2Sup = CollectionUtil.newCaseInsensitiveMap();
    private final Map<String, LdapAttributeType> attrName2Type = CollectionUtil.newCaseInsensitiveMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerNativeSchema(LdapConnection conn) throws NamingException {
        this.conn = conn;
        this.schemaCtx = conn.getInitialContext().getSchema("");
        try {
            this.initObjectClasses();
            this.initAttributeDescriptions();
        }
        finally {
            this.schemaCtx.close();
        }
    }

    @Override
    public Set<String> getStructuralObjectClasses() {
        return Collections.unmodifiableSet(this.structuralLdapClasses);
    }

    @Override
    public Set<String> getRequiredAttributes(String ldapClass) {
        return this.getAttributes(ldapClass, true);
    }

    @Override
    public Set<String> getOptionalAttributes(String ldapClass) {
        return this.getAttributes(ldapClass, false);
    }

    private Set<String> getAttributes(String ldapClass, boolean required) {
        SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        LinkedList<String> queue = new LinkedList<String>();
        HashSet<String> visited = new HashSet<String>();
        queue.add(ldapClass);
        while (!queue.isEmpty()) {
            Set<String> supClasses;
            Set<String> attrs;
            String current = (String)queue.remove();
            if (visited.contains(current)) continue;
            visited.add(current);
            Set<String> set = attrs = required ? this.ldapClass2MustAttrs.get(current) : this.ldapClass2MayAttrs.get(current);
            if (attrs != null) {
                result.addAll(attrs);
            }
            if ((supClasses = this.ldapClass2Sup.get(current)) == null) continue;
            queue.addAll(supClasses);
        }
        return result;
    }

    @Override
    public Set<String> getEffectiveObjectClasses(String ldapClass) {
        SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        LinkedList<String> classQueue = new LinkedList<String>();
        classQueue.add(ldapClass);
        while (!classQueue.isEmpty()) {
            String classToVisit = (String)classQueue.remove();
            if (result.contains(classToVisit)) continue;
            result.add(classToVisit);
            Set<String> supClasses = this.ldapClass2Sup.get(classToVisit);
            if (supClasses == null) continue;
            classQueue.addAll(supClasses);
        }
        return result;
    }

    @Override
    public LdapAttributeType getAttributeDescription(String ldapAttrName) {
        return this.attrName2Type.get(ldapAttrName);
    }

    private void initObjectClasses() throws NamingException {
        DirContext objClassCtx = (DirContext)this.schemaCtx.lookup("ClassDefinition");
        NamingEnumeration<NameClassPair> objClassEnum = objClassCtx.list("");
        while (objClassEnum.hasMore()) {
            String objClassName = objClassEnum.next().getName();
            Attributes attrs = objClassCtx.getAttributes(objClassName);
            boolean abstractAttr = "true".equals(LdapUtil.getStringAttrValue(attrs, "ABSTRACT"));
            boolean structuralAttr = "true".equals(LdapUtil.getStringAttrValue(attrs, "STRUCTURAL"));
            boolean auxiliaryAttr = "true".equals(LdapUtil.getStringAttrValue(attrs, "AUXILIARY"));
            boolean structural = structuralAttr || !abstractAttr && !auxiliaryAttr;
            SortedSet mustAttrs = CollectionUtil.newCaseInsensitiveSet();
            LdapUtil.addStringAttrValues(attrs, "MUST", mustAttrs);
            SortedSet mayAttrs = CollectionUtil.newCaseInsensitiveSet();
            LdapUtil.addStringAttrValues(attrs, "MAY", mayAttrs);
            if (mustAttrs.remove("objectClass")) {
                mayAttrs.add("objectClass");
            }
            SortedSet supClasses = CollectionUtil.newCaseInsensitiveSet();
            LdapUtil.addStringAttrValues(attrs, "SUP", supClasses);
            if (structural && supClasses.isEmpty()) {
                supClasses.add("top");
            }
            SortedSet names = CollectionUtil.newCaseInsensitiveSet();
            LdapUtil.addStringAttrValues(attrs, "NAME", names);
            for (String name : names) {
                if (structural) {
                    this.structuralLdapClasses.addAll(names);
                }
                this.ldapClass2MustAttrs.put(name, mustAttrs);
                this.ldapClass2MayAttrs.put(name, mayAttrs);
                this.ldapClass2Sup.put(name, supClasses);
            }
        }
    }

    private void initAttributeDescriptions() throws NamingException {
        DirContext attrsCtx = (DirContext)this.schemaCtx.lookup("AttributeDefinition");
        NamingEnumeration<NameClassPair> attrsEnum = attrsCtx.list("");
        while (attrsEnum.hasMore()) {
            String attrName = attrsEnum.next().getName();
            Attributes attrs = attrsCtx.getAttributes(attrName);
            boolean singleValue = "true".equals(LdapUtil.getStringAttrValue(attrs, "SINGLE-VALUE"));
            boolean noUserModification = "true".equals(LdapUtil.getStringAttrValue(attrs, "NO-USER-MODIFICATION"));
            String usage = LdapUtil.getStringAttrValue(attrs, "USAGE");
            boolean userApplications = "userApplications".equals(usage) || usage == null;
            SortedSet names = CollectionUtil.newCaseInsensitiveSet();
            LdapUtil.addStringAttrValues(attrs, "NAME", names);
            for (String name : names) {
                boolean objectClass = LdapUtil.attrNameEquals(name, "objectClass");
                boolean binary = this.conn.isBinarySyntax(attrName);
                Class type = binary ? byte[].class : String.class;
                EnumSet<AttributeInfo.Flags> flags = EnumSet.noneOf(AttributeInfo.Flags.class);
                if (!singleValue) {
                    flags.add(AttributeInfo.Flags.MULTIVALUED);
                }
                if (noUserModification || objectClass) {
                    flags.add(AttributeInfo.Flags.NOT_CREATABLE);
                    flags.add(AttributeInfo.Flags.NOT_UPDATEABLE);
                }
                if (!userApplications) {
                    flags.add(AttributeInfo.Flags.NOT_RETURNED_BY_DEFAULT);
                }
                this.attrName2Type.put(name, new LdapAttributeType(type, flags));
            }
        }
        for (String dirAttrName : LDAP_DIRECTORY_ATTRS) {
            this.attrName2Type.put(dirAttrName, new LdapAttributeType(String.class, EnumSet.of(AttributeInfo.Flags.NOT_CREATABLE, AttributeInfo.Flags.NOT_UPDATEABLE, AttributeInfo.Flags.NOT_RETURNED_BY_DEFAULT)));
        }
    }

    static {
        LDAP_DIRECTORY_ATTRS.add("createTimestamp");
        LDAP_DIRECTORY_ATTRS.add("modifyTimestamp");
        LDAP_DIRECTORY_ATTRS.add("creatorsName");
        LDAP_DIRECTORY_ATTRS.add("modifiersName");
        LDAP_DIRECTORY_ATTRS.add("entryDN");
    }
}

