/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.ldap.schema;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import org.connid.bundles.ldap.LdapConnection;
import org.connid.bundles.ldap.commons.LdapEntry;
import org.connid.bundles.ldap.commons.LdapUtil;
import org.connid.bundles.ldap.commons.ObjectClassMappingConfig;
import org.connid.bundles.ldap.schema.GuardedPasswordAttribute;
import org.connid.bundles.ldap.schema.LdapSchemaBuilder;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.Uid;

public class LdapSchemaMapping {
    private static final Log LOG = Log.getLog(LdapSchemaMapping.class);
    public static final ObjectClass ANY_OBJECT_CLASS = new ObjectClass(ObjectClassUtil.createSpecialName((String)"ANY"));
    static final String DEFAULT_LDAP_NAME_ATTR = "entryDN";
    private final LdapConnection conn;
    private final Map<String, Set<String>> ldapClass2Effective = CollectionUtil.newCaseInsensitiveMap();
    private Schema schema;

    public LdapSchemaMapping(LdapConnection conn) {
        this.conn = conn;
    }

    public Schema schema() {
        if (this.schema == null) {
            this.schema = new LdapSchemaBuilder(this.conn).getSchema();
        }
        return this.schema;
    }

    private Set<String> getEffectiveLdapClasses(String ldapClass) {
        Set<String> result = this.ldapClass2Effective.get(ldapClass);
        if (result == null) {
            result = this.conn.createNativeSchema().getEffectiveObjectClasses(ldapClass);
            this.ldapClass2Effective.put(ldapClass, result);
        }
        return result;
    }

    public List<String> getLdapClasses(ObjectClass oclass) {
        if (oclass.equals((Object)ANY_OBJECT_CLASS)) {
            return Collections.emptyList();
        }
        ObjectClassMappingConfig oclassConfig = this.conn.getConfiguration().getObjectClassMappingConfigs().get(oclass);
        if (oclassConfig != null) {
            return oclassConfig.getLdapClasses();
        }
        if (!ObjectClassUtil.isSpecial((ObjectClass)oclass)) {
            return CollectionUtil.newReadOnlyList((Object[])new String[]{oclass.getObjectClassValue()});
        }
        throw new ConnectorException("Object class " + oclass.getObjectClassValue() + " is not mapped to an LDAP object class");
    }

    public Set<String> getEffectiveLdapClasses(ObjectClass oclass) {
        SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        for (String ldapClass : this.getLdapClasses(oclass)) {
            result.addAll(this.getEffectiveLdapClasses(ldapClass));
        }
        return Collections.unmodifiableSet(result);
    }

    public List<String> getUserNameLdapAttributes(ObjectClass oclass) {
        ObjectClassMappingConfig oclassConfig = this.conn.getConfiguration().getObjectClassMappingConfigs().get(oclass);
        return oclassConfig == null ? Collections.emptyList() : oclassConfig.getShortNameLdapAttributes();
    }

    public String getLdapAttribute(ObjectClass oclass, String attrName, boolean transfer) {
        String result = null;
        if (AttributeUtil.namesEqual((String)Uid.NAME, (String)attrName)) {
            result = this.getLdapUidAttribute(oclass);
        } else if (AttributeUtil.namesEqual((String)Name.NAME, (String)attrName)) {
            result = this.getLdapNameAttribute(oclass);
        } else if (OperationalAttributes.PASSWORD_NAME.equals(attrName)) {
            result = this.getLdapPasswordAttribute(oclass);
        }
        if (result == null && !AttributeUtil.isSpecialName((String)attrName)) {
            result = attrName;
        }
        if (result != null && transfer && this.conn.needsBinaryOption(result)) {
            result = LdapUtil.addBinaryOption(result);
        }
        if (result == null && !oclass.equals((Object)ANY_OBJECT_CLASS)) {
            LOG.warn("Attribute {0} of object class {1} is not mapped to an LDAP attribute", new Object[]{attrName, oclass.getObjectClassValue()});
        }
        return result;
    }

    public String getLdapAttribute(ObjectClass oclass, Attribute attr) {
        return this.getLdapAttribute(oclass, attr.getName(), false);
    }

    public Set<String> getLdapAttributes(ObjectClass oclass, Set<String> attrs, boolean transfer) {
        SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        for (String attr : attrs) {
            String ldapAttr = this.getLdapAttribute(oclass, attr, transfer);
            if (ldapAttr == null) continue;
            result.add(ldapAttr);
        }
        return result;
    }

    public String getLdapUidAttribute(ObjectClass oclass) {
        return StringUtil.isBlank((String)this.conn.getConfiguration().getUidAttribute()) ? this.conn.getConfiguration().getObjectClassMappingConfigs().get(oclass).getShortNameLdapAttributes().iterator().next() : this.conn.getConfiguration().getUidAttribute();
    }

    public String getLdapPasswordAttribute(ObjectClass oclass) {
        return this.conn.getConfiguration().getPasswordAttribute();
    }

    public String getLdapNameAttribute(ObjectClass oclass) {
        return DEFAULT_LDAP_NAME_ATTR;
    }

    public Uid createUid(ObjectClass oclass, LdapEntry entry) {
        return this.createUid(this.getLdapUidAttribute(oclass), entry.getAttributes());
    }

    public Uid createUid(ObjectClass oclass, String entryDN) {
        String ldapUidAttr = this.getLdapUidAttribute(oclass);
        if (LdapEntry.isDNAttribute(ldapUidAttr)) {
            return new Uid(entryDN);
        }
        try {
            Attributes attributes = this.conn.getInitialContext().getAttributes(entryDN, new String[]{ldapUidAttr});
            return this.createUid(ldapUidAttr, attributes);
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private Uid createUid(String ldapUidAttr, Attributes attributes) {
        String value = LdapUtil.getStringAttrValue(attributes, ldapUidAttr);
        if (value != null) {
            return new Uid(value);
        }
        throw new ConnectorException("No attribute named " + ldapUidAttr + " found in the search result");
    }

    public Name createName(ObjectClass oclass, LdapEntry entry) {
        String ldapNameAttr = this.getLdapNameAttribute(oclass);
        if (!LdapEntry.isDNAttribute(ldapNameAttr)) {
            throw new UnsupportedOperationException("Name can only be mapped to the entry DN");
        }
        return new Name(entry.getDN().toString());
    }

    public Attribute createAttribute(ObjectClass oclass, String attrName, LdapEntry entry, boolean emptyWhenNotFound) {
        String ldapAttrNameForTransfer = this.getLdapAttribute(oclass, attrName, true);
        javax.naming.directory.Attribute ldapAttr = null;
        if (ldapAttrNameForTransfer != null) {
            ldapAttr = entry.getAttributes().get(ldapAttrNameForTransfer);
        }
        if (ldapAttr == null) {
            return emptyWhenNotFound ? AttributeBuilder.build((String)attrName, Collections.emptyList()) : null;
        }
        AttributeBuilder builder = new AttributeBuilder();
        builder.setName(attrName);
        try {
            if (OperationalAttributes.PASSWORD_NAME.equals(attrName)) {
                String password = new String((byte[])ldapAttr.get());
                builder.addValue(new Object[]{new GuardedString(password.toCharArray())});
            } else {
                NamingEnumeration<?> valEnum = ldapAttr.getAll();
                while (valEnum.hasMore()) {
                    builder.addValue(new Object[]{valEnum.next()});
                }
            }
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
        return builder.build();
    }

    public String create(ObjectClass oclass, Name name, Attributes initialAttrs) {
        LdapName entryName = LdapUtil.quietCreateLdapName(this.getEntryDN(oclass, name));
        BasicAttributes ldapAttrs = new BasicAttributes();
        NamingEnumeration<? extends javax.naming.directory.Attribute> initialAttrEnum = initialAttrs.getAll();
        while (initialAttrEnum.hasMoreElements()) {
            ldapAttrs.put((javax.naming.directory.Attribute)initialAttrEnum.nextElement());
        }
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        for (String ldapClass : this.conn.getSchemaMapping().getEffectiveLdapClasses(oclass)) {
            objectClass.add(ldapClass);
        }
        ldapAttrs.put(objectClass);
        LOG.ok("Creating LDAP subcontext {0} with attributes {1}", new Object[]{entryName, ldapAttrs});
        try {
            this.conn.getInitialContext().createSubcontext(entryName, (Attributes)ldapAttrs).close();
            return entryName.toString();
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public javax.naming.directory.Attribute encodeAttribute(ObjectClass oclass, Attribute attr) {
        if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
            throw new IllegalArgumentException("This method should not be used for password attributes");
        }
        String ldapAttrName = this.getLdapAttribute(oclass, attr.getName(), true);
        if (ldapAttrName == null) {
            return null;
        }
        BasicAttribute ldapAttr = new BasicAttribute(ldapAttrName);
        List value = attr.getValue();
        if (value != null) {
            for (Object each : value) {
                ldapAttr.add(each);
            }
        }
        return ldapAttr;
    }

    public GuardedPasswordAttribute encodePassword(ObjectClass oclass, Attribute attr) {
        Iterator i$;
        assert (attr.is(OperationalAttributes.PASSWORD_NAME));
        String pwdAttrName = this.conn.getConfiguration().getPasswordAttribute();
        List value = attr.getValue();
        if (value != null && (i$ = value.iterator()).hasNext()) {
            Object each = i$.next();
            GuardedString password = (GuardedString)each;
            return GuardedPasswordAttribute.create(pwdAttrName, password);
        }
        return GuardedPasswordAttribute.create(pwdAttrName);
    }

    public String getEntryDN(ObjectClass oclass, Name name) {
        String ldapNameAttr = this.getLdapNameAttribute(oclass);
        if (!LdapEntry.isDNAttribute(ldapNameAttr)) {
            throw new UnsupportedOperationException("Name can only be mapped to the entry DN");
        }
        return name.getNameValue();
    }

    public String rename(ObjectClass oclass, String entryDN, Name newName) {
        String newEntryDN = this.getEntryDN(oclass, newName);
        try {
            this.conn.getInitialContext().rename(entryDN, newEntryDN);
            return newEntryDN;
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void removeNonReadableAttributes(ObjectClass oclass, Set<String> attrNames) {
        ObjectClassInfo oci = this.schema().findObjectClassInfo(oclass.getObjectClassValue());
        if (oci == null) {
            return;
        }
        SortedSet attrs = CollectionUtil.newCaseInsensitiveSet();
        SortedSet readableAttrs = CollectionUtil.newCaseInsensitiveSet();
        for (AttributeInfo info : oci.getAttributeInfo()) {
            String attrName = info.getName();
            attrs.add(attrName);
            if (!info.isReadable()) continue;
            readableAttrs.add(attrName);
        }
        Iterator<String> i = attrNames.iterator();
        while (i.hasNext()) {
            String attrName = i.next();
            if (!attrs.contains(attrName) || readableAttrs.contains(attrName)) continue;
            i.remove();
        }
    }
}

