/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.ldap.commons;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public abstract class AppendingAttributes
implements Attributes {
    private static final long serialVersionUID = 1L;
    protected final Attributes delegate;

    public AppendingAttributes(Attributes delegate) {
        this.delegate = delegate;
    }

    protected abstract Set<String> getAttributeIDsToAppend();

    protected abstract Attribute getAttributeToAppend(String var1);

    @Override
    public abstract Object clone();

    @Override
    public final Attribute get(String attrID) {
        String attrIDToAppend = this.getNormalizedAttributeIDToAppend(attrID);
        if (attrIDToAppend != null) {
            return this.getAttributeToAppend(attrIDToAppend);
        }
        return this.delegate.get(attrID);
    }

    private String getNormalizedAttributeIDToAppend(String attrID) {
        if (this.delegate.isCaseIgnored()) {
            for (String attributeIDToAppend : this.getAttributeIDsToAppend()) {
                if (!attributeIDToAppend.equalsIgnoreCase(attrID)) continue;
                return attributeIDToAppend;
            }
        } else if (this.getAttributeIDsToAppend().contains(attrID)) {
            return attrID;
        }
        return null;
    }

    @Override
    public final NamingEnumeration<? extends Attribute> getAll() {
        return new AttributeAppendingEnumeration(this.delegate.getAll());
    }

    @Override
    public final NamingEnumeration<String> getIDs() {
        return new AttributeIDAppendingEnumeration(this.delegate.getIDs());
    }

    @Override
    public final boolean isCaseIgnored() {
        return this.delegate.isCaseIgnored();
    }

    @Override
    public final Attribute put(Attribute attr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Attribute put(String attrID, Object val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Attribute remove(String attrID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        int size = this.delegate.size();
        for (String attributeIDToAppend : this.getAttributeIDsToAppend()) {
            if (this.delegate.get(attributeIDToAppend) != null) continue;
            ++size;
        }
        return size;
    }

    private final class AttributeIDAppendingEnumeration
    extends AppendingEnumeration<String> {
        private Set<String> replaced;

        public AttributeIDAppendingEnumeration(NamingEnumeration<String> delegate) {
            super(delegate);
            this.replaced = new HashSet<String>();
        }

        @Override
        protected String getReplacementValue(String value) {
            if (AppendingAttributes.this.getAttributeIDsToAppend().contains(value)) {
                this.replaced.add(value);
                return value;
            }
            return null;
        }

        @Override
        protected Enumeration<String> getRemainingValues() {
            final Set<String> remaining = AppendingAttributes.this.getAttributeIDsToAppend();
            remaining.removeAll(this.replaced);
            return new Enumeration<String>(){
                private final Iterator<String> iterator;
                {
                    this.iterator = remaining.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return this.iterator.next();
                }
            };
        }
    }

    private final class AttributeAppendingEnumeration
    extends AppendingEnumeration<Attribute> {
        private Set<String> replaced;

        public AttributeAppendingEnumeration(NamingEnumeration<? extends Attribute> delegate) {
            super(delegate);
            this.replaced = new HashSet<String>();
        }

        @Override
        protected Attribute getReplacementValue(Attribute value) {
            String attrID = value.getID();
            if (AppendingAttributes.this.getAttributeIDsToAppend().contains(attrID)) {
                this.replaced.add(attrID);
                return AppendingAttributes.this.getAttributeToAppend(attrID);
            }
            return null;
        }

        @Override
        protected Enumeration<Attribute> getRemainingValues() {
            final Set<String> remaining = AppendingAttributes.this.getAttributeIDsToAppend();
            remaining.removeAll(this.replaced);
            return new Enumeration<Attribute>(){
                private final Iterator<String> iterator;
                {
                    this.iterator = remaining.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.iterator.hasNext();
                }

                @Override
                public Attribute nextElement() {
                    return AppendingAttributes.this.getAttributeToAppend(this.iterator.next());
                }
            };
        }
    }

    private abstract class AppendingEnumeration<T>
    implements NamingEnumeration<T> {
        private final NamingEnumeration<? extends T> delegate;
        private Enumeration<T> remainingValues;

        public AppendingEnumeration(NamingEnumeration<? extends T> delegate) {
            this.delegate = delegate;
        }

        protected abstract T getReplacementValue(T var1);

        protected abstract Enumeration<T> getRemainingValues();

        @Override
        public void close() throws NamingException {
            this.delegate.close();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.delegate.hasMore() || this.hasMoreRemainingValues();
        }

        @Override
        public T next() throws NamingException {
            if (this.delegate.hasMore()) {
                T replacement;
                T next = this.delegate.next();
                if (next != null && (replacement = this.getReplacementValue(next)) != null) {
                    next = replacement;
                }
                return next;
            }
            if (this.hasMoreRemainingValues()) {
                return this.getNextRemainingValue();
            }
            return this.delegate.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.delegate.hasMoreElements() || this.hasMoreRemainingValues();
        }

        @Override
        public T nextElement() {
            if (this.delegate.hasMoreElements()) {
                Object replacement;
                Object next = this.delegate.nextElement();
                if (next != null && (replacement = this.getReplacementValue(next)) != null) {
                    next = replacement;
                }
                return (T)next;
            }
            if (this.hasMoreRemainingValues()) {
                return this.getNextRemainingValue();
            }
            return (T)this.delegate.nextElement();
        }

        private boolean hasMoreRemainingValues() {
            if (this.remainingValues == null) {
                this.remainingValues = this.getRemainingValues();
            }
            return this.remainingValues.hasMoreElements();
        }

        private T getNextRemainingValue() {
            assert (this.remainingValues != null);
            return this.remainingValues.nextElement();
        }
    }
}

