/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.ldap.commons;

import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.connid.bundles.ldap.commons.AttributeStatusManagement;
import org.identityconnectors.common.logging.Log;

public class NSStatusManagement
extends AttributeStatusManagement {
    private static final Log LOG = Log.getLog(NSStatusManagement.class);

    @Override
    protected String getStatusAttrName() {
        return "nsAccountLock";
    }

    @Override
    protected String getStatusAttrActiveValue() {
        return null;
    }

    @Override
    protected String getStatusAttrInactiveValue() {
        return "true";
    }

    @Override
    public void setStatus(boolean status, Attributes attributes, List<String> posixGroups, List<String> ldapGroups) {
        LOG.ok("Calling setStatus {0}", new Object[]{status});
        String value = status ? this.getStatusAttrActiveValue() : this.getStatusAttrInactiveValue();
        attributes.put(this.getStatusAttrName(), value);
    }

    @Override
    public Boolean getStatus(Attributes attributes, List<String> posixGroups, List<String> ldapGroups) {
        Boolean status = Boolean.TRUE;
        Attribute attr = attributes.get(this.getStatusAttrName());
        if (attr != null) {
            try {
                Object value = attr.get();
                if (value != null) {
                    status = status ^ this.getStatusAttrInactiveValue().equalsIgnoreCase(value.toString());
                }
            }
            catch (NamingException ignore) {
                status = null;
            }
        }
        LOG.ok("Returning getStatus {0}", new Object[]{status});
        return status;
    }
}

