/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.soap.utilities;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;

public enum AttributeType {
    String("java.lang.String"),
    Long("java.lang.Long"),
    Double("java.lang.Double"),
    Boolean("java.lang.Boolean"),
    Character("java.lang.Character"),
    Float("java.lang.Float"),
    Integer("java.lang.Integer"),
    URI("java.net.uri"),
    File("java.io.file"),
    Date("java.lang.String");

    private final String className;
    private Format formatter;

    private AttributeType(String className) {
        this.className = className;
        this.formatter = null;
    }

    public String getClassName() {
        return this.className;
    }

    public Format getBasicFormatter() {
        if (this.formatter == null) {
            switch (this) {
                case Date: {
                    this.formatter = new SimpleDateFormat();
                }
                case Long: 
                case Double: {
                    this.formatter = new DecimalFormat();
                }
            }
        }
        return this.formatter;
    }

    public boolean isConversionPatternNeeded() {
        return this == Date || this == Double || this == Long;
    }
}

