/*
 * Decompiled with CFR 0.152.
 */
package org.connid.bundles.soap.utilities;

import java.util.Set;
import org.connid.bundles.soap.to.WSAttribute;
import org.connid.bundles.soap.utilities.Operator;

public class Operand
extends WSAttribute {
    private Operator op;
    private String value;
    private Set<Operand> operands;
    private boolean logical;
    boolean not;

    public Operand() {
        super(null);
        this.op = Operator.EQ;
        this.value = "*";
        this.not = false;
        this.logical = false;
        this.operands = null;
    }

    public Operand(Operator op, String name, String value) {
        super(name);
        this.op = op;
        this.value = value;
        this.not = false;
        this.logical = false;
        this.operands = null;
    }

    public Operand(Operator op, Set<Operand> operands) {
        super(null);
        this.value = null;
        this.op = op;
        this.operands = operands;
        this.logical = true;
    }

    public Operand(Operator op, String name, String value, boolean not) {
        super(name);
        this.op = op;
        this.value = value;
        this.not = not;
        this.logical = false;
        this.operands = null;
    }

    public Operand(Operator op, Set<Operand> operands, boolean not) {
        super(null);
        this.value = null;
        this.op = op;
        this.operands = operands;
        this.logical = true;
        this.not = not;
    }

    public Operator getOp() {
        return this.op;
    }

    public Set<Operand> getOperands() {
        return this.operands;
    }

    public void setOperands(Set<Operand> operands) {
        if (this.logical) {
            this.operands = operands;
        }
    }

    public void setOp(Operator op) {
        this.op = op;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (!this.logical) {
            this.value = value;
        }
    }

    public boolean isLogical() {
        return this.logical;
    }

    public void setLogical(boolean logical) {
        this.logical = logical;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean not) {
        this.not = not;
    }

    @Override
    public String toString() {
        if (Operator.STARTS.equals((Object)this.op)) {
            return (this.not ? "NOT" : "") + this.getName() + " LIKE '" + this.getValue() + "%'";
        }
        if (Operator.ENDS.equals((Object)this.op)) {
            return (this.not ? "NOT" : "") + this.getName() + " LIKE '%" + this.getValue() + "'";
        }
        if (Operator.CONTAINS.equals((Object)this.op)) {
            return (this.not ? "NOT" : "") + this.getName() + " LIKE '%" + this.getValue() + "%'";
        }
        if (Operator.GT.equals((Object)this.op)) {
            return (this.not ? "NOT" : "") + this.getName() + ">'" + this.getValue() + "'";
        }
        if (Operator.LT.equals((Object)this.op)) {
            return (this.not ? "NOT" : "") + this.getName() + "<'" + this.getValue() + "'";
        }
        if (Operator.EQ.equals((Object)this.op)) {
            return (this.not ? "NOT" : "") + this.getName() + "='" + this.getValue() + "'";
        }
        if (this.operands == null) {
            return null;
        }
        StringBuilder queryBuilder = new StringBuilder();
        for (Operand operand : this.operands) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" " + this.op.toString() + " ");
            }
            queryBuilder.append(operand.toString());
        }
        if (this.not) {
            return "NOT (" + queryBuilder + ")";
        }
        if (this.operands.size() > 1) {
            return "(" + queryBuilder + ")";
        }
        return queryBuilder.toString();
    }
}

