/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;
import org.identityconnectors.framework.impl.api.local.JavaClassProperties;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.local.ObjectPool;
import org.identityconnectors.framework.impl.api.local.ObjectPoolHandler;
import org.identityconnectors.framework.impl.api.local.ThreadClassLoaderManager;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.PoolableConnector;

public class ConnectorPoolManager {
    private static final Map<ConnectorPoolKey, ObjectPool<PoolableConnector>> POOLS = new HashMap<ConnectorPoolKey, ObjectPool<PoolableConnector>>();
    private static Log LOG = Log.getLog(ConnectorPoolManager.class);

    public static ObjectPool<PoolableConnector> getPool(APIConfigurationImpl impl, LocalConnectorInfoImpl localInfo) {
        try {
            return ConnectorPoolManager.getPoolInternal(impl, localInfo);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectPool<PoolableConnector> getPoolInternal(APIConfigurationImpl impl, LocalConnectorInfoImpl localInfo) throws InstantiationException, IllegalAccessException {
        ObjectPool<PoolableConnector> pool = null;
        if (impl.isConnectorPoolingSupported()) {
            ConnectorPoolKey key = new ConnectorPoolKey(impl.getConnectorInfo().getConnectorKey(), impl.getConfigurationProperties(), impl.getConnectorPoolConfiguration());
            Map<ConnectorPoolKey, ObjectPool<PoolableConnector>> map = POOLS;
            synchronized (map) {
                pool = POOLS.get(key);
                if (pool == null) {
                    LOG.info("Creating new pool: {0}", new Object[]{impl.getConnectorInfo().getConnectorKey()});
                    pool = new ObjectPool<PoolableConnector>(new ConnectorPoolHandler(impl, localInfo), impl.getConnectorPoolConfiguration());
                    POOLS.put(key, pool);
                }
            }
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        Map<ConnectorPoolKey, ObjectPool<PoolableConnector>> map = POOLS;
        synchronized (map) {
            for (ObjectPool<PoolableConnector> pool : POOLS.values()) {
                try {
                    pool.shutdown();
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e, "Failed to close pool: {0}", new Object[]{pool});
                }
            }
            POOLS.clear();
        }
    }

    private static class ConnectorPoolHandler
    implements ObjectPoolHandler<PoolableConnector> {
        private final APIConfigurationImpl _apiConfiguration;
        private final LocalConnectorInfoImpl _localInfo;

        public ConnectorPoolHandler(APIConfigurationImpl apiConfiguration, LocalConnectorInfoImpl localInfo) {
            this._apiConfiguration = apiConfiguration;
            this._localInfo = localInfo;
        }

        @Override
        public PoolableConnector newObject() {
            ThreadClassLoaderManager.getInstance().pushClassLoader(this._localInfo.getConnectorClass().getClassLoader());
            try {
                Configuration config = JavaClassProperties.createBean(this._apiConfiguration.getConfigurationProperties(), this._localInfo.getConnectorConfigurationClass());
                PoolableConnector connector = (PoolableConnector)this._localInfo.getConnectorClass().newInstance();
                connector.init(config);
                PoolableConnector poolableConnector = connector;
                return poolableConnector;
            }
            catch (Exception e) {
                throw ConnectorException.wrap((Throwable)e);
            }
            finally {
                ThreadClassLoaderManager.getInstance().popClassLoader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void testObject(PoolableConnector object) {
            ThreadClassLoaderManager.getInstance().pushClassLoader(this._localInfo.getConnectorClass().getClassLoader());
            try {
                object.checkAlive();
            }
            finally {
                ThreadClassLoaderManager.getInstance().popClassLoader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disposeObject(PoolableConnector object) {
            ThreadClassLoaderManager.getInstance().pushClassLoader(this._localInfo.getConnectorClass().getClassLoader());
            try {
                object.dispose();
            }
            finally {
                ThreadClassLoaderManager.getInstance().popClassLoader();
            }
        }
    }

    private static class ConnectorPoolKey {
        private final ConnectorKey _connectorKey;
        private final ConfigurationPropertiesImpl _configProperties;
        private final ObjectPoolConfiguration _poolingConfig;

        public ConnectorPoolKey(ConnectorKey connectorKey, ConfigurationPropertiesImpl configProperties, ObjectPoolConfiguration poolingConfig) {
            this._connectorKey = connectorKey;
            this._configProperties = configProperties;
            this._poolingConfig = poolingConfig;
        }

        public int hashCode() {
            return this._connectorKey.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ConnectorPoolKey) {
                ConnectorPoolKey other = (ConnectorPoolKey)object;
                if (!this._connectorKey.equals((Object)other._connectorKey)) {
                    return false;
                }
                if (!this._configProperties.equals(other._configProperties)) {
                    return false;
                }
                return this._poolingConfig.equals((Object)other._poolingConfig);
            }
            return false;
        }
    }
}

