/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.impl.api.local.BundleKey;
import org.identityconnectors.framework.impl.api.local.ConnectorBundleManifest;

public class WorkingBundleInfo {
    private String _originalLocation;
    private ConnectorBundleManifest _manifest;
    private Set<String> _immediateBundleContents = new HashSet<String>();
    private List<URL> _immediateClassPath = new ArrayList<URL>();
    private Map<String, String> _immediateNativeLibraries = new HashMap<String, String>();
    private List<WorkingBundleInfo> _embeddedBundles = new ArrayList<WorkingBundleInfo>();
    private List<URL> _effectiveClassPath;
    private Map<String, String> _effectiveNativeLibraries;
    private Set<String> _effectiveContents;

    public WorkingBundleInfo(String originalLocation) {
        this._originalLocation = originalLocation;
    }

    public String getOriginalLocation() {
        return this._originalLocation;
    }

    public ConnectorBundleManifest getManifest() {
        return this._manifest;
    }

    public void setManifest(ConnectorBundleManifest manifest) {
        this._manifest = manifest;
    }

    public Set<String> getImmediateBundleContents() {
        return this._immediateBundleContents;
    }

    public List<URL> getImmediateClassPath() {
        return this._immediateClassPath;
    }

    public Map<String, String> getImmediateNativeLibraries() {
        return this._immediateNativeLibraries;
    }

    public List<WorkingBundleInfo> getEmbeddedBundles() {
        return this._embeddedBundles;
    }

    public List<URL> getEffectiveClassPath() {
        return this._effectiveClassPath;
    }

    public Map<String, String> getEffectiveNativeLibraries() {
        return this._effectiveNativeLibraries;
    }

    public Set<String> getEffectiveContents() {
        return this._effectiveContents;
    }

    public static void resolve(List<? extends WorkingBundleInfo> infos) throws ConfigurationException {
        for (WorkingBundleInfo workingBundleInfo : infos) {
            workingBundleInfo._effectiveClassPath = null;
            workingBundleInfo._effectiveContents = null;
        }
        WorkingBundleInfo.ensureBundlesAreUnique(infos);
        WorkingBundleInfo.resolveEffectiveProperties(infos);
    }

    private static void ensureBundlesAreUnique(List<? extends WorkingBundleInfo> working) throws ConfigurationException {
        HashSet<BundleKey> bundleKeys = new HashSet<BundleKey>();
        for (WorkingBundleInfo workingBundleInfo : working) {
            BundleKey key = new BundleKey(workingBundleInfo._manifest.getBundleName(), workingBundleInfo._manifest.getBundleVersion());
            if (bundleKeys.contains((Object)key)) {
                String format = "There is more than one bundle with the same name+version: %s";
                throw new ConfigurationException(String.format(format, new Object[]{key}));
            }
            bundleKeys.add(key);
        }
    }

    private static void resolveEffectiveProperties(List<? extends WorkingBundleInfo> infos) throws ConfigurationException {
        for (WorkingBundleInfo workingBundleInfo : infos) {
            ArrayList<URL> classPath = new ArrayList<URL>();
            LinkedHashMap<String, String> nativeLibraries = new LinkedHashMap<String, String>();
            HashSet<String> contents = new HashSet<String>();
            classPath.addAll(workingBundleInfo.getImmediateClassPath());
            nativeLibraries.putAll(workingBundleInfo.getImmediateNativeLibraries());
            contents.addAll(workingBundleInfo.getImmediateBundleContents());
            WorkingBundleInfo.resolveEffectiveProperties(workingBundleInfo.getEmbeddedBundles());
            for (WorkingBundleInfo embedded : workingBundleInfo.getEmbeddedBundles()) {
                classPath.addAll(embedded.getEffectiveClassPath());
                for (Map.Entry<String, String> entry : embedded.getEffectiveNativeLibraries().entrySet()) {
                    if (nativeLibraries.containsKey(entry.getKey())) continue;
                    nativeLibraries.put(entry.getKey(), entry.getValue());
                }
                contents.addAll(embedded.getEffectiveContents());
            }
            workingBundleInfo._effectiveClassPath = classPath;
            workingBundleInfo._effectiveNativeLibraries = nativeLibraries;
            workingBundleInfo._effectiveContents = contents;
        }
    }
}

