/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.test.ApiOperations;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.LogInfo;
import org.identityconnectors.contract.test.ObjectClassRunner;
import org.identityconnectors.contract.test.SyncApiOpTests;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.SchemaApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AttributeTests
extends ObjectClassRunner {
    private static final Log LOG = Log.getLog(AttributeTests.class);
    private static final String TEST_NAME = "Attribute";

    public AttributeTests(ObjectClass oclass) {
        super(oclass);
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> res = new HashSet<Class<? extends APIOperation>>();
        res.add(CreateApiOp.class);
        res.add(UpdateApiOp.class);
        res.add(GetApiOp.class);
        res.add(SchemaApiOp.class);
        return res;
    }

    @Override
    public void testRun() {
    }

    @Override
    public String getTestName() {
        return TEST_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testNonReadable() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) {
            Uid uid = null;
            try {
                ObjectClassInfo oci = this.getObjectClassInfo();
                Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(AttributeTests.getDataProvider(), oci, this.getTestName(), 0, true, false);
                uid = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
                ConnectorObject obj = this.getConnectorFacade().getObject(this.getObjectClass(), uid, null);
                Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)obj);
                for (Attribute attr : obj.getAttributes()) {
                    if (ConnectorHelper.isReadable(oci, attr)) continue;
                    String msg = String.format("Non-readable attribute should not be returned by default: %s", attr.getName());
                    Assert.assertTrue((String)msg, (!ConnectorHelper.isReturnedByDefault(oci, attr) ? 1 : 0) != 0);
                }
                if (uid == null) return;
            }
            catch (Throwable throwable) {
                if (uid == null) throw throwable;
                this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
                throw throwable;
            }
            this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
            return;
        }
        this.printSkipTestMsg("testNonReadable");
    }

    @Test
    public void testReturnedByDefault() {
        if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), CreateApiOp.class)) {
            for (ApiOperations apiop : ApiOperations.values()) {
                this.testReturnedByDefault(apiop);
            }
        } else {
            this.printSkipTestMsg("testReturnedByDefault");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonUpdateable() {
        boolean exceptionCaught = false;
        boolean isChanged = false;
        LogInfo logInfo = null;
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) {
            block11: {
                ConnectorObject obj = null;
                Uid uid = null;
                try {
                    uid = ConnectorHelper.createObject(this.getConnectorFacade(), AttributeTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 1, this.getOperationOptionsByOp(CreateApiOp.class));
                    Assert.assertNotNull((String)"Create returned null Uid.", (Object)uid);
                    obj = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
                    Assert.assertNotNull((String)"Cannot retrieve created object.", (Object)obj);
                    Schema schema = this.getConnectorFacade().schema();
                    Set<Attribute> nonUpdateableAttrs = this.getNonUpdateableAttributes(schema, this.getObjectClass());
                    boolean bl = isChanged = nonUpdateableAttrs != null;
                    if (isChanged) {
                        logInfo = new LogInfo(this.getObjectClass(), nonUpdateableAttrs);
                        Assert.assertTrue((String)"no update attributes were found", (nonUpdateableAttrs.size() > 0 ? 1 : 0) != 0);
                        Uid newUid = this.getConnectorFacade().update(this.getObjectClass(), uid, AttributeUtil.filterUid(nonUpdateableAttrs), this.getOperationOptionsByOp(UpdateApiOp.class));
                        if (!newUid.equals((Object)uid)) {
                            nonUpdateableAttrs.remove(uid);
                            nonUpdateableAttrs.add((Attribute)newUid);
                            uid = newUid;
                        }
                        obj = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
                        Assert.assertNotNull((String)"Cannot retrieve updated object.", (Object)obj);
                        ConnectorHelper.checkObject(this.getObjectClassInfo(), obj, nonUpdateableAttrs);
                        break block11;
                    }
                    this.printSkipNonUpdateableTestMsg();
                    return;
                }
                catch (RuntimeException ex) {
                    exceptionCaught = true;
                }
                finally {
                    if (uid != null) {
                        ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                    }
                }
            }
            if (!exceptionCaught) {
                Assert.fail((String)String.format("No exception thrown when update is performed on non-updateable attribute(s). (hint: throw a RuntimeException) %s", logInfo != null ? logInfo.toString() : ""));
            }
        } else {
            this.printSkipTestMsg("testNonUpdateable");
        }
    }

    private Set<Attribute> getNonUpdateableAttributes(Schema schema, ObjectClass objectClass) {
        HashSet<Attribute> result = new HashSet<Attribute>();
        ObjectClassInfoBuilder oib = new ObjectClassInfoBuilder();
        oib.setType(objectClass.getObjectClassValue());
        ObjectClassInfo ocToFind = oib.build();
        Set oci = schema.getObjectClassInfo();
        for (ObjectClassInfo objectClassInfo : oci) {
            if (!objectClassInfo.getType().equals(ocToFind.getType())) continue;
            Set attrInfo = objectClassInfo.getAttributeInfo();
            for (AttributeInfo attributeInfo : attrInfo) {
                if (attributeInfo.isUpdateable()) continue;
                Attribute attr = AttributeBuilder.build((String)attributeInfo.getName());
                result.add(attr);
            }
        }
        return result.size() == 0 ? null : result;
    }

    private void printSkipNonUpdateableTestMsg() {
        this.printSkipTestMsg("testNonUpdateable");
    }

    private void printSkipTestMsg(String testName) {
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        LOG.info("Skipping test ''{0}'' for object class ''{1}''. (Reason: non-updateable attrs. are missing)", new Object[]{testName, this.getObjectClass()});
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testRequirableIsCreatable() {
        if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), CreateApiOp.class) && ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), GetApiOp.class)) {
            Uid uid = null;
            try {
                ObjectClassInfo oci = this.getObjectClassInfo();
                Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(AttributeTests.getDataProvider(), oci, this.getTestName(), 2, true, false);
                uid = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
                ConnectorObject obj = this.getConnectorFacade().getObject(this.getObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
                Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)obj);
                for (Attribute attr : obj.getAttributes()) {
                    if (!ConnectorHelper.isRequired(oci, attr) || ConnectorHelper.isCreateable(oci, attr)) continue;
                    String msg = String.format("Required attribute is not createable. Attribute name: %s", attr.getName());
                    Assert.fail((String)msg);
                }
                if (uid == null) return;
            }
            catch (Throwable throwable) {
                if (uid == null) throw throwable;
                this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
                throw throwable;
            }
            this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
            return;
        }
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        LOG.info("Skipping test ''testNonReadable'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testReturnedByDefault(ApiOperations apiOp) {
        String testMarkMsg = String.format("[testReturnedByDefault/%s]", new Object[]{apiOp});
        if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), apiOp.getClazz())) {
            SyncToken token = null;
            if (apiOp.equals((Object)ApiOperations.SYNC)) {
                token = this.getConnectorFacade().getLatestSyncToken(this.getObjectClass());
            }
            Uid uid = null;
            try {
                ObjectClassInfo oci = this.getObjectClassInfo();
                Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(AttributeTests.getDataProvider(), oci, this.getTestName(), 3, true, false);
                uid = this.getConnectorFacade().create(this.getObjectClass(), attrs, null);
                Assert.assertNotNull((String)(testMarkMsg + " Create returned null uid."), (Object)uid);
                ConnectorObject obj = null;
                switch (apiOp) {
                    case GET: {
                        obj = this.getConnectorFacade().getObject(this.getObjectClass(), uid, null);
                        break;
                    }
                    case SEARCH: {
                        Filter fltUid = FilterBuilder.equalTo((Attribute)AttributeBuilder.build((String)Uid.NAME, (Object[])new Object[]{uid.getUidValue()}));
                        Assert.assertTrue((String)(testMarkMsg + " filterUid is null"), (fltUid != null ? 1 : 0) != 0);
                        List<ConnectorObject> coObjects = ConnectorHelper.search(this.getConnectorFacade(), this.getSupportedObjectClass(), fltUid, null);
                        Assert.assertTrue((String)(testMarkMsg + " Search filter by uid with no OperationOptions failed, expected to return one object, but returned " + coObjects.size()), (coObjects.size() == 1 ? 1 : 0) != 0);
                        Assert.assertNotNull((String)(testMarkMsg + " Unable to retrieve newly created object"), (Object)coObjects.get(0));
                        obj = coObjects.get(0);
                        break;
                    }
                    case SYNC: {
                        uid = this.testSync(uid, token, attrs, oci, testMarkMsg);
                    }
                }
                if (!apiOp.equals((Object)ApiOperations.SYNC)) {
                    Assert.assertNotNull((String)"Unable to retrieve newly created object", obj);
                    this.checkAttributes(obj, oci, apiOp);
                }
                if (uid == null) return;
            }
            catch (Throwable throwable) {
                if (uid == null) throw throwable;
                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                throw throwable;
            }
            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
            return;
        }
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        LOG.info("Skipping test ''testReturnedByDefault'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
    }

    private void checkAttributes(ConnectorObject obj, ObjectClassInfo oci, ApiOperations apiOp) {
        for (Attribute attr : obj.getAttributes()) {
            String msg = String.format("[testReturnedByDefault / %s]Attribute %s returned. However it is _not_ returned by default.", new Object[]{apiOp, attr.getName()});
            if (attr.getName().equals(Uid.NAME)) continue;
            Assert.assertTrue((String)msg, (boolean)ConnectorHelper.isReturnedByDefault(oci, attr));
        }
    }

    private Uid testSync(Uid uid, SyncToken token, Set<Attribute> attrs, ObjectClassInfo oci, String testMarkMsg) {
        Set<Attribute> replaceAttributes;
        ConnectorObject obj;
        List<SyncDelta> deltas = null;
        String msg = null;
        if (SyncApiOpTests.canSyncAfterOp(CreateApiOp.class)) {
            deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getObjectClass(), token, null);
            msg = "%s Sync should have returned one sync delta after creation of one object, but returned: %d";
            Assert.assertTrue((String)String.format(msg, testMarkMsg, deltas.size()), (deltas.size() == 1 ? 1 : 0) != 0);
            ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), deltas.get(0), uid, attrs, SyncDeltaType.CREATE_OR_UPDATE, false);
            obj = deltas.get(0).getObject();
            this.checkAttributes(obj, oci, ApiOperations.SYNC);
            token = deltas.get(0).getToken();
        }
        if (ConnectorHelper.operationSupported(this.getConnectorFacade(), UpdateApiOp.class) && SyncApiOpTests.canSyncAfterOp(UpdateApiOp.class) && (replaceAttributes = ConnectorHelper.getUpdateableAttributes(AttributeTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), "modified", 0, false, false)).size() > 0) {
            replaceAttributes.add((Attribute)uid);
            Assert.assertTrue((String)(testMarkMsg + " no update attributes were found"), (replaceAttributes.size() > 0 ? 1 : 0) != 0);
            Uid newUid = this.getConnectorFacade().update(this.getSupportedObjectClass(), uid, AttributeUtil.filterUid(replaceAttributes), null);
            if (!newUid.equals((Object)uid)) {
                replaceAttributes.remove(uid);
                replaceAttributes.add((Attribute)newUid);
                uid = newUid;
            }
            deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getObjectClass(), token, null);
            msg = "%s Sync should have returned one sync delta after update of one object, but returned: %d";
            Assert.assertTrue((String)String.format(msg, testMarkMsg, deltas.size()), (deltas.size() == 1 ? 1 : 0) != 0);
            ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), deltas.get(0), uid, replaceAttributes, SyncDeltaType.CREATE_OR_UPDATE, false);
            ConnectorObject obj2 = deltas.get(0).getObject();
            this.checkAttributes(obj2, oci, ApiOperations.SYNC);
            token = deltas.get(0).getToken();
        }
        if (SyncApiOpTests.canSyncAfterOp(DeleteApiOp.class)) {
            this.getConnectorFacade().delete(this.getObjectClass(), uid, null);
            deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getObjectClass(), token, null);
            msg = "%s Sync should have returned one sync delta after delete of one object, but returned: %d";
            Assert.assertTrue((String)String.format(msg, testMarkMsg, deltas.size()), (deltas.size() == 1 ? 1 : 0) != 0);
            ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), deltas.get(0), uid, null, SyncDeltaType.DELETE, false);
            obj = deltas.get(0).getObject();
            this.checkAttributes(obj, oci, ApiOperations.SYNC);
        }
        return uid;
    }
}

