/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.List;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.data.DataProvider;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ConfigurationTests {
    private static final Log LOG = Log.getLog(ConfigurationTests.class);
    private ConfigurationProperties _configProperties = null;

    @Before
    public void init() {
        DataProvider dataProvider = ConnectorHelper.createDataProvider();
        this._configProperties = ConnectorHelper.getConfigurationProperties(dataProvider);
    }

    @After
    public void dispose() {
        this._configProperties = null;
    }

    @Test
    public void testPropertiesType() {
        Assert.assertNotNull((Object)this._configProperties);
        List propertyNames = this._configProperties.getPropertyNames();
        Assert.assertNotNull((Object)propertyNames);
        for (String propertyName : propertyNames) {
            ConfigurationProperty property = this._configProperties.getProperty(propertyName);
            Assert.assertNotNull((Object)property);
            String typeName = property.getType().getName();
            LOG.ok("Property: ''{0}'' type ''{1}''", new Object[]{property.getName(), typeName});
            Assert.assertTrue((String)("Type " + typeName + " not allowed in configuration!"), (boolean)FrameworkUtil.isSupportedConfigurationType((Class)property.getType()));
        }
    }
}

