/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.Set;
import org.identityconnectors.contract.data.DataProvider;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.junit.After;
import org.junit.Before;

public abstract class ContractTestBase {
    private static DataProvider _dataProvider;
    protected ConnectorFacade _connFacade;

    private static void disposeDataProvider() {
        if (_dataProvider != null) {
            _dataProvider.dispose();
        }
    }

    @Before
    public void init() {
        this._connFacade = ConnectorHelper.createConnectorFacade(ContractTestBase.getDataProvider());
    }

    @After
    public void dispose() {
        this._connFacade = null;
        ContractTestBase.disposeDataProvider();
    }

    public abstract Set<Class<? extends APIOperation>> getAPIOperations();

    public static synchronized DataProvider getDataProvider() {
        if (_dataProvider == null) {
            _dataProvider = ConnectorHelper.createDataProvider();
        }
        return _dataProvider;
    }

    public ConnectorFacade getConnectorFacade() {
        return this._connFacade;
    }

    public OperationOptions getOperationOptionsByOp(Class<? extends APIOperation> clazz) {
        return null;
    }
}

