/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.HashSet;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ObjectClassRunner;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeleteApiOpTests
extends ObjectClassRunner {
    private static final Log LOG = Log.getLog(DeleteApiOpTests.class);
    private static final String TEST_NAME = "Delete";

    public DeleteApiOpTests(ObjectClass oclass) {
        super(oclass);
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> requiredOps = new HashSet<Class<? extends APIOperation>>();
        requiredOps.add(DeleteApiOp.class);
        requiredOps.add(CreateApiOp.class);
        requiredOps.add(GetApiOp.class);
        return requiredOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRun() {
        ConnectorObject obj = null;
        Uid uid = null;
        try {
            uid = ConnectorHelper.createObject(this.getConnectorFacade(), DeleteApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, this.getOperationOptionsByOp(DeleteApiOp.class));
            obj = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
            Assert.assertNotNull((String)"Unable to perform delete test because object to be deleted cannot be created", (Object)obj);
            this.getConnectorFacade().delete(this.getObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
            obj = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
            Assert.assertNull((String)"Object wasn't deleted by delete.", (Object)obj);
        }
        catch (Throwable throwable) {
            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
            throw throwable;
        }
        ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteThrowUnknownUid() {
        block5: {
            block4: {
                if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) break block4;
                Uid uid = null;
                try {
                    uid = ConnectorHelper.createObject(this.getConnectorFacade(), DeleteApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 1, this.getOperationOptionsByOp(DeleteApiOp.class));
                    this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
                    try {
                        this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
                        Assert.fail((String)"Delete of previously deleted object should throw UnknownUidException.");
                    }
                    catch (UnknownUidException unknownUidException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                    throw throwable;
                }
                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                break block5;
            }
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testDeleteThrowUnknownUid'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    @Override
    public String getTestName() {
        return TEST_NAME;
    }
}

