/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ObjectClassRunner;
import org.identityconnectors.contract.test.SearchApiOpTests;
import org.identityconnectors.contract.test.SyncApiOpTests;
import org.identityconnectors.contract.test.UpdateApiOpTests;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.api.operations.TestApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.api.operations.ValidateApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiOpTests
extends ObjectClassRunner {
    private static final Log LOG = Log.getLog(MultiOpTests.class);
    private static final String TEST_NAME = "Multi";
    private static final String MODIFIED = "modified";
    private static final String LOCKOUT_PREFIX = "lockout";
    private static final String SKIP = "skip";

    public MultiOpTests(ObjectClass oclass) {
        super(oclass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRun() {
        int recordCount = 10;
        ArrayList<Uid> uids = new ArrayList<Uid>();
        ArrayList<Set<Attribute>> attrs = new ArrayList<Set<Attribute>>();
        Map<Uid, ConnectorObject> coBeforeTest = null;
        SyncToken token = null;
        List<SyncDelta> deltas = null;
        String msg = null;
        try {
            int i;
            int i2;
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), SearchApiOp.class)) {
                coBeforeTest = ConnectorHelper.search2Map(this.getConnectorFacade(), this.getObjectClass(), null, this.getOperationOptionsByOp(SearchApiOp.class));
            }
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), SyncApiOp.class)) {
                token = this.getConnectorFacade().getLatestSyncToken(this.getObjectClass());
            }
            for (i2 = 0; i2 < 10; ++i2) {
                Set<Attribute> attr = ConnectorHelper.getCreateableAttributes(MultiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), i2, true, false);
                Uid luid = this.getConnectorFacade().create(this.getObjectClass(), attr, this.getOperationOptionsByOp(CreateApiOp.class));
                Assert.assertNotNull((String)"Create returned null uid.", (Object)luid);
                attrs.add(attr);
                uids.add(luid);
            }
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), GetApiOp.class)) {
                for (i2 = 0; i2 < 10; ++i2) {
                    ConnectorObject obj = this.getConnectorFacade().getObject(this.getObjectClass(), (Uid)uids.get(i2), this.getOperationOptionsByOp(GetApiOp.class));
                    Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)obj);
                    ConnectorHelper.checkObject(this.getObjectClassInfo(), obj, (Set)attrs.get(i2));
                }
            }
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), TestApiOp.class)) {
                this.getConnectorFacade().test();
            }
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), SyncApiOp.class) && SyncApiOpTests.canSyncAfterOp(CreateApiOp.class)) {
                deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getObjectClass(), token, this.getOperationOptionsByOp(SyncApiOp.class));
                msg = "Sync after %d creates returned %d deltas.";
                Assert.assertTrue((String)String.format(msg, 10, deltas.size()), (deltas.size() == 10 ? 1 : 0) != 0);
                for (i2 = 0; i2 < 10; ++i2) {
                    ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), deltas.get(i2), (Uid)uids.get(i2), (Set)attrs.get(i2), SyncDeltaType.CREATE_OR_UPDATE, true);
                }
                token = deltas.get(9).getToken();
            }
            Uid deleteUid = (Uid)uids.remove(0);
            attrs.remove(0);
            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getObjectClass(), deleteUid, true, this.getOperationOptionsByOp(DeleteApiOp.class));
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), SearchApiOp.class)) {
                List<ConnectorObject> coFound = ConnectorHelper.search(this.getConnectorFacade(), this.getObjectClass(), null, this.getOperationOptionsByOp(SearchApiOp.class));
                Assert.assertTrue((String)("Search with null filter returned different count of results. Expected: " + uids.size() + coBeforeTest.size() + ", but returned: " + coFound.size()), (coFound.size() == uids.size() + coBeforeTest.size() ? 1 : 0) != 0);
                for (ConnectorObject obj : coFound) {
                    if (uids.contains(obj.getUid())) {
                        int index = uids.indexOf(obj.getUid());
                        ConnectorHelper.checkObject(this.getObjectClassInfo(), obj, (Set)attrs.get(index));
                        continue;
                    }
                    if (SearchApiOpTests.compareExistingObjectsByUidOnly()) {
                        Assert.assertTrue((String)("Search with null filter returned unexpected object " + obj + ", objects were compared by Uid."), (boolean)coBeforeTest.containsKey(obj.getUid()));
                        continue;
                    }
                    Assert.assertTrue((String)("Search with null filter returned unexpected object " + obj + ", objects were compared by Uid."), (boolean)coBeforeTest.containsValue(obj));
                }
            }
            Uid updateUid = null;
            Set<Attribute> replaceAttributes = null;
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), UpdateApiOp.class)) {
                updateUid = (Uid)uids.remove(0);
                attrs.remove(0);
                replaceAttributes = ConnectorHelper.getUpdateableAttributes(MultiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), MODIFIED, 0, false, false);
                if (replaceAttributes.size() > 0) {
                    replaceAttributes.add((Attribute)updateUid);
                    Uid newUid = this.getConnectorFacade().update(this.getObjectClass(), updateUid, AttributeUtil.filterUid(replaceAttributes), this.getOperationOptionsByOp(UpdateApiOp.class));
                    replaceAttributes.remove(updateUid);
                    if (!updateUid.equals((Object)newUid)) {
                        updateUid = newUid;
                    }
                    attrs.add(replaceAttributes);
                    uids.add(updateUid);
                }
                if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), SearchApiOp.class)) {
                    Filter fltUid = FilterBuilder.equalTo((Attribute)updateUid);
                    List<ConnectorObject> coFound = ConnectorHelper.search(this.getConnectorFacade(), this.getObjectClass(), fltUid, this.getOperationOptionsByOp(SearchApiOp.class));
                    Assert.assertTrue((String)("Search with Uid filter returned unexpected number of objects. Expected: 1, but returned: " + coFound.size()), (coFound.size() == 1 ? 1 : 0) != 0);
                    ConnectorHelper.checkObject(this.getObjectClassInfo(), coFound.get(0), replaceAttributes);
                }
            }
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), SyncApiOp.class) && (SyncApiOpTests.canSyncAfterOp(DeleteApiOp.class) || SyncApiOpTests.canSyncAfterOp(UpdateApiOp.class))) {
                deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getObjectClass(), token, this.getOperationOptionsByOp(SyncApiOp.class));
                Assert.assertTrue((String)("Sync returned unexpected number of deltas. Exptected: max 2, but returned: " + deltas.size()), (deltas.size() <= 2 && deltas.size() > 0 ? 1 : 0) != 0);
                for (int i3 = 0; i3 < deltas.size(); ++i3) {
                    SyncDelta delta = deltas.get(i3);
                    if (SyncDeltaType.CREATE_OR_UPDATE.equals((Object)delta.getDeltaType())) {
                        ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), delta, updateUid, replaceAttributes, SyncDeltaType.CREATE_OR_UPDATE, true);
                    } else {
                        ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), delta, deleteUid, null, SyncDeltaType.DELETE, true);
                    }
                    token = delta.getToken();
                }
            }
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), ValidateApiOp.class)) {
                this.getConnectorFacade().validate();
            }
            Set<Attribute> attrs11 = ConnectorHelper.getCreateableAttributes(MultiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 11, true, false);
            Uid createUid = this.getConnectorFacade().create(this.getObjectClass(), attrs11, this.getOperationOptionsByOp(CreateApiOp.class));
            uids.add(createUid);
            attrs.add(attrs11);
            Assert.assertNotNull((String)"Create returned null Uid.", (Object)createUid);
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), GetApiOp.class)) {
                ConnectorObject obj = this.getConnectorFacade().getObject(this.getObjectClass(), createUid, this.getOperationOptionsByOp(GetApiOp.class));
                Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)obj);
                ConnectorHelper.checkObject(this.getObjectClassInfo(), obj, attrs11);
            }
            deleteUid = (Uid)uids.remove(0);
            attrs.remove(0);
            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getObjectClass(), deleteUid, true, this.getOperationOptionsByOp(DeleteApiOp.class));
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), SyncApiOp.class) && (SyncApiOpTests.canSyncAfterOp(DeleteApiOp.class) || SyncApiOpTests.canSyncAfterOp(CreateApiOp.class))) {
                deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getObjectClass(), token, this.getOperationOptionsByOp(SyncApiOp.class));
                Assert.assertTrue((String)("Sync returned unexpected number of deltas. Exptected: max 2, but returned: " + deltas.size()), (deltas.size() <= 2 ? 1 : 0) != 0);
                for (int i4 = 0; i4 < deltas.size(); ++i4) {
                    SyncDelta delta = deltas.get(i4);
                    if (SyncDeltaType.CREATE_OR_UPDATE.equals((Object)delta.getDeltaType())) {
                        ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), delta, createUid, attrs11, SyncDeltaType.CREATE_OR_UPDATE, true);
                    } else {
                        ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), delta, deleteUid, null, SyncDeltaType.DELETE, true);
                    }
                    token = delta.getToken();
                }
            }
            for (i = 0; i < uids.size(); ++i) {
                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getObjectClass(), (Uid)uids.get(i), true, this.getOperationOptionsByOp(DeleteApiOp.class));
            }
            if (ConnectorHelper.operationSupported(this.getConnectorFacade(), this.getObjectClass(), SyncApiOp.class) && SyncApiOpTests.canSyncAfterOp(DeleteApiOp.class)) {
                deltas = ConnectorHelper.sync(this.getConnectorFacade(), this.getObjectClass(), token, this.getOperationOptionsByOp(SyncApiOp.class));
                msg = "Sync returned unexpected number of deltas. Exptected: %d, but returned: %d";
                Assert.assertTrue((String)String.format(msg, uids.size(), deltas.size()), (deltas.size() == uids.size() ? 1 : 0) != 0);
                for (i = 0; i < uids.size(); ++i) {
                    ConnectorHelper.checkSyncDelta(this.getObjectClassInfo(), deltas.get(i), (Uid)uids.get(i), null, SyncDeltaType.DELETE, true);
                }
            }
        }
        finally {
            for (Uid deluid : uids) {
                try {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), deluid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(CreateApiOp.class);
        s.add(DeleteApiOp.class);
        return s;
    }

    @Override
    public String getTestName() {
        return TEST_NAME;
    }

    @Test
    public void testEnableOpAttribute() {
        if (this.isObjectClassSupported() && ConnectorHelper.isCRU(this.getObjectClassInfo(), OperationalAttributes.ENABLE_NAME)) {
            this.checkOpAttribute(OperationalAttributes.ENABLE_NAME, true, false, Boolean.class);
            this.checkOpAttribute(OperationalAttributes.ENABLE_NAME, false, true, Boolean.class);
        } else {
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testEnableOpAttribute'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    @Test
    public void testEnableDateOpAttribute() {
        if (this.isObjectClassSupported() && ConnectorHelper.isCRU(this.getObjectClassInfo(), OperationalAttributes.ENABLE_DATE_NAME)) {
            long createValue = this.getDateProperty(OperationalAttributes.ENABLE_DATE_NAME, new Date().getTime(), false);
            long updateValue = this.getDateProperty(OperationalAttributes.ENABLE_DATE_NAME, new Date(0L).getTime(), true);
            this.checkOpAttribute(OperationalAttributes.ENABLE_DATE_NAME, createValue, updateValue, Long.class);
        } else {
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testEnableDateOpAttribute'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    @Test
    public void testDisableDateOpAttribute() {
        if (this.isObjectClassSupported() && ConnectorHelper.isCRU(this.getObjectClassInfo(), OperationalAttributes.DISABLE_DATE_NAME)) {
            long createValue = this.getDateProperty(OperationalAttributes.DISABLE_DATE_NAME, new Date().getTime(), false);
            long updateValue = this.getDateProperty(OperationalAttributes.DISABLE_DATE_NAME, new Date(0L).getTime(), true);
            this.checkOpAttribute(OperationalAttributes.DISABLE_DATE_NAME, createValue, updateValue, Long.class);
        } else {
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testDisableDateOpAttribute'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    private long getDateProperty(String propName, long defaultValue, boolean isModified) {
        try {
            Object obj;
            if (isModified) {
                propName = String.format("%s.%s", MODIFIED, propName);
            }
            if ((obj = MultiOpTests.getDataProvider().getTestSuiteAttribute(propName, this.getTestName())) instanceof Long) {
                return (Long)obj;
            }
            Assert.fail((String)String.format("Property 'testsuite.%s.%s' should be of type *long*", this.getTestName(), propName));
        }
        catch (ObjectNotFoundException onfe) {
            // empty catch block
        }
        return defaultValue;
    }

    @Test
    public void testLockOutOpAttribute() {
        if (this.isObjectClassSupported() && ConnectorHelper.isCRU(this.getObjectClassInfo(), OperationalAttributes.LOCK_OUT_NAME) && MultiOpTests.canLockOut()) {
            this.checkOpAttribute(OperationalAttributes.LOCK_OUT_NAME, true, false, Boolean.class);
            this.checkOpAttribute(OperationalAttributes.LOCK_OUT_NAME, false, true, Boolean.class);
        } else {
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testLockOutOpAttribute'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    @Test
    public void testPasswordExpirationDateOpAttribute() {
        if (this.isObjectClassSupported() && ConnectorHelper.isCRU(this.getObjectClassInfo(), OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME)) {
            this.checkOpAttribute(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME, new Date().getTime(), new Date(0L).getTime(), Long.class);
        } else {
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testPasswordExpirationDateOpAttribute'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    @Test
    public void testPasswordExpiredOpAttribute() {
        if (this.isObjectClassSupported() && ConnectorHelper.isCRU(this.getObjectClassInfo(), OperationalAttributes.PASSWORD_EXPIRED_NAME)) {
            this.checkOpAttribute(OperationalAttributes.PASSWORD_EXPIRED_NAME, false, true, Boolean.class, true);
        } else {
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testPasswordExpiredOpAttribute'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    @Test
    public void testPasswordChangeIntervalPredAttribute() {
        if (this.isObjectClassSupported() && ConnectorHelper.isCRU(this.getObjectClassInfo(), PredefinedAttributes.PASSWORD_CHANGE_INTERVAL_NAME)) {
            this.checkOpAttribute(PredefinedAttributes.PASSWORD_CHANGE_INTERVAL_NAME, 10368000000L, 2592000000L, Long.class);
        } else {
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testPasswordChangeIntervalPredAttribute'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpAttribute(String attrName, Object createValue, Object updateValue, Class<?> type, boolean addPassword) {
        boolean iteration = false;
        Set<Attribute> attrs = null;
        attrs = ConnectorHelper.getCreateableAttributes(MultiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, true, false);
        for (Attribute attribute : attrs) {
            if (!attribute.is(attrName)) continue;
            attrs.remove(attribute);
            break;
        }
        attrs.add(AttributeBuilder.build((String)attrName, (Object[])new Object[]{createValue}));
        Uid uid = null;
        try {
            uid = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs, null);
            this.checkAttribute(attrName, uid, createValue, type);
            attrs.clear();
            attrs.add(AttributeBuilder.build((String)attrName, (Object[])new Object[]{updateValue}));
            if (addPassword) {
                GuardedString password = (GuardedString)ConnectorHelper.get(MultiOpTests.getDataProvider(), this.getTestName(), GuardedString.class, OperationalAttributes.PASSWORD_NAME, this.getObjectClassInfo().getType(), 0, false);
                Attribute attrPasswd = AttributeBuilder.build((String)OperationalAttributes.PASSWORD_NAME, (Object[])new Object[]{password});
                attrs.add(attrPasswd);
            }
            attrs.add((Attribute)uid);
            uid = this.getConnectorFacade().update(this.getSupportedObjectClass(), uid, AttributeUtil.filterUid(attrs), null);
            this.checkAttribute(attrName, uid, updateValue, type);
        }
        finally {
            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, null);
        }
    }

    private void checkOpAttribute(String attrName, Object createValue, Object updateValue, Class<?> type) {
        this.checkOpAttribute(attrName, createValue, updateValue, type, false);
    }

    private void checkAttribute(String attrName, Uid uid, Object expValue, Class<?> type) {
        ConnectorObject obj = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid, null);
        for (Attribute attribute : obj.getAttributes()) {
            if (!attribute.is(attrName)) continue;
            List vals = attribute.getValue();
            Assert.assertTrue((String)String.format("Operational attribute %s must contain exactly one value.", attrName), (vals.size() == 1 ? 1 : 0) != 0);
            Object val = vals.get(0);
            Assert.assertEquals((String)String.format("Operational attribute %s value type must be %s, but is %s.", attrName, type.getSimpleName(), val.getClass().getSimpleName()), type, val.getClass());
            Assert.assertEquals((String)String.format("Operational attribute %s value is different, expected: %s, returned: %s", attrName, expValue, val), (Object)expValue, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupsPredAttribute() {
        block5: {
            block4: {
                Uid accountUid1;
                Uid groupUid2;
                Uid groupUid1;
                block3: {
                    ObjectClassInfo accountInfo = this.findOInfo(ObjectClass.ACCOUNT);
                    ObjectClassInfo groupInfo = this.findOInfo(ObjectClass.GROUP);
                    if (accountInfo == null || groupInfo == null || !ConnectorHelper.isCRU(accountInfo, PredefinedAttributes.GROUPS_NAME)) break block4;
                    groupUid1 = null;
                    groupUid2 = null;
                    accountUid1 = null;
                    try {
                        Set<Attribute> groupAttrs1 = ConnectorHelper.getCreateableAttributes(MultiOpTests.getDataProvider(), groupInfo, this.getTestName(), 0, true, false);
                        groupUid1 = this.getConnectorFacade().create(ObjectClass.GROUP, groupAttrs1, null);
                        Set<Attribute> accountAttrs1 = ConnectorHelper.getCreateableAttributes(MultiOpTests.getDataProvider(), accountInfo, this.getTestName(), 0, true, false);
                        for (Attribute attr : accountAttrs1) {
                            if (!attr.is(PredefinedAttributes.GROUPS_NAME)) continue;
                            accountAttrs1.remove(attr);
                            break;
                        }
                        accountAttrs1.add(AttributeBuilder.build((String)PredefinedAttributes.GROUPS_NAME, (Object[])new Object[]{AttributeUtil.getStringValue((Attribute)groupUid1)}));
                        accountUid1 = this.getConnectorFacade().create(ObjectClass.ACCOUNT, accountAttrs1, null);
                        OperationOptionsBuilder oob = new OperationOptionsBuilder();
                        oob.setAttributesToGet(ConnectorHelper.getReadableAttributesNames(accountInfo));
                        OperationOptions attrsToGet = oob.build();
                        ConnectorObject obj = this.getConnectorFacade().getObject(ObjectClass.ACCOUNT, accountUid1, attrsToGet);
                        ConnectorHelper.checkObject(accountInfo, obj, accountAttrs1);
                        if (!ConnectorHelper.operationSupported(this.getConnectorFacade(), ObjectClass.ACCOUNT, UpdateApiOp.class) || !ConnectorHelper.isMultiValue(accountInfo, PredefinedAttributes.GROUPS_NAME)) break block3;
                        Set<Attribute> groupAttrs2 = ConnectorHelper.getCreateableAttributes(MultiOpTests.getDataProvider(), groupInfo, this.getTestName(), 1, true, false);
                        groupUid2 = this.getConnectorFacade().create(ObjectClass.GROUP, groupAttrs2, null);
                        HashSet<Attribute> accountAttrs2 = new HashSet<Attribute>();
                        accountAttrs2.add(AttributeBuilder.build((String)PredefinedAttributes.GROUPS_NAME, (Object[])new Object[]{AttributeUtil.getStringValue((Attribute)groupUid2)}));
                        accountAttrs2.add((Attribute)accountUid1);
                        accountUid1 = this.getConnectorFacade().addAttributeValues(ObjectClass.ACCOUNT, accountUid1, AttributeUtil.filterUid(accountAttrs2), null);
                        obj = this.getConnectorFacade().getObject(ObjectClass.ACCOUNT, accountUid1, attrsToGet);
                        ConnectorHelper.checkObject(accountInfo, obj, UpdateApiOpTests.mergeAttributeSets(accountAttrs1, accountAttrs2));
                    }
                    catch (Throwable throwable) {
                        ConnectorHelper.deleteObject(this.getConnectorFacade(), ObjectClass.GROUP, groupUid1, false, null);
                        ConnectorHelper.deleteObject(this.getConnectorFacade(), ObjectClass.GROUP, groupUid2, false, null);
                        ConnectorHelper.deleteObject(this.getConnectorFacade(), ObjectClass.ACCOUNT, accountUid1, false, null);
                        throw throwable;
                    }
                }
                ConnectorHelper.deleteObject(this.getConnectorFacade(), ObjectClass.GROUP, groupUid1, false, null);
                ConnectorHelper.deleteObject(this.getConnectorFacade(), ObjectClass.GROUP, groupUid2, false, null);
                ConnectorHelper.deleteObject(this.getConnectorFacade(), ObjectClass.ACCOUNT, accountUid1, false, null);
                break block5;
            }
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testGroupsPredAttribute''.", new Object[0]);
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    private ObjectClassInfo findOInfo(ObjectClass oclass) {
        Schema schema = this.getConnectorFacade().schema();
        for (ObjectClassInfo oinfo : schema.getObjectClassInfo()) {
            if (!oinfo.is(oclass.getObjectClassValue())) continue;
            return oinfo;
        }
        return null;
    }

    private static boolean canLockOut() {
        Boolean canLockout = true;
        try {
            canLockout = (Boolean)MultiOpTests.getDataProvider().getTestSuiteAttribute("skip.lockout", TEST_NAME) == false;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return canLockout;
    }
}

