/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ContractTestBase;
import org.identityconnectors.contract.test.TestApiOpTests;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.ValidateApiOp;
import org.junit.Assert;
import org.junit.Test;

public class ValidateApiOpTests
extends ContractTestBase {
    private static final String PROPERTY_NAME_INVALID_CONFIG = "invalidConfig";
    private static final Log LOG = Log.getLog(TestApiOpTests.class);
    private static final String TEST_NAME = "Validate";

    @Test
    public void testValidateFail() {
        String testPropertyName = "testsuite.Validate.invalidConfig";
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getAPIOperations())) {
            Object o = null;
            try {
                o = ValidateApiOpTests.getDataProvider().getTestSuiteAttribute(PROPERTY_NAME_INVALID_CONFIG, TEST_NAME);
            }
            catch (ObjectNotFoundException ex) {
                Assert.fail((String)String.format("Missing test property: '%s'", "testsuite.Validate.invalidConfig"));
            }
            if (!(o instanceof List)) {
                Assert.fail((String)String.format("Test property '%s' should be of type List", "testsuite.Validate.invalidConfig"));
            }
            List wrongConfigList = (List)o;
            for (Object currentWrongConfigMap : wrongConfigList) {
                if (!(currentWrongConfigMap instanceof Map)) {
                    Assert.fail((String)String.format("Test property '%s' contains other than Map properties.", "testsuite.Validate.invalidConfig"));
                }
                Map currentWrongMapConfig = (Map)currentWrongConfigMap;
                this._connFacade = ConnectorHelper.createConnectorFacadeWithWrongConfiguration(ValidateApiOpTests.getDataProvider(), currentWrongMapConfig);
                try {
                    this.getConnectorFacade().validate();
                    String msg = String.format("Validate should throw RuntimeException because configuration should be invalid. Wrong properties used: \n%s", currentWrongMapConfig.toString());
                    Assert.fail((String)msg);
                }
                catch (RuntimeException ex) {}
            }
        } else {
            LOG.info("--------------------------------", new Object[0]);
            LOG.info("Skipping test ''testValidateFail''.", new Object[0]);
            LOG.info("--------------------------------", new Object[0]);
        }
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(ValidateApiOp.class);
        return s;
    }
}

