/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ObjectClassRunner;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.AuthenticationApiOp;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.PasswordExpiredException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AuthenticationApiOpTests
extends ObjectClassRunner {
    private static final Log LOG = Log.getLog(AuthenticationApiOpTests.class);
    static final String TEST_NAME = "Authentication";
    static final String USERNAME_PROP = "username";
    private static final String WRONG_PASSWORD_PROP = "wrong.password";
    private static final String MAX_ITERATIONS = "maxIterations";
    private static final String SLEEP_MILLISECONDS = "sleepMilliseconds";

    public AuthenticationApiOpTests(ObjectClass oclass) {
        super(oclass);
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> requiredOps = new HashSet<Class<? extends APIOperation>>();
        requiredOps.add(CreateApiOp.class);
        requiredOps.add(AuthenticationApiOp.class);
        requiredOps.add(GetApiOp.class);
        return requiredOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void testRun() {
        Uid uid = null;
        try {
            Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(AuthenticationApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, true, false);
            Iterator<Attribute> i = attrs.iterator();
            while (i.hasNext()) {
                Attribute attr = i.next();
                if (!attr.is(OperationalAttributes.PASSWORD_EXPIRED_NAME) && !attr.is(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME) && !attr.is(OperationalAttributes.ENABLE_DATE_NAME) && !attr.is(OperationalAttributes.ENABLE_NAME) || ConnectorHelper.isRequired(this.getObjectClassInfo(), attr)) continue;
                i.remove();
            }
            uid = this.getConnectorFacade().create(this.getObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
            ConnectorObject obj = this.getConnectorFacade().getObject(this.getObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
            Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)obj);
            String name = (String)AuthenticationApiOpTests.getDataProvider().getTestSuiteAttribute(this.getObjectClass().getObjectClassValue() + "." + USERNAME_PROP, TEST_NAME);
            boolean authenticateFailed = false;
            GuardedString wrongPassword = (GuardedString)AuthenticationApiOpTests.getDataProvider().getTestSuiteAttribute(this.getObjectClass().getObjectClassValue() + "." + WRONG_PASSWORD_PROP, TEST_NAME);
            authenticateFailed = this.authenticateExpectingInvalidCredentials(name, wrongPassword);
            Assert.assertTrue((String)"Negative test case for Authentication failed, should throw InvalidCredentialException", (boolean)authenticateFailed);
            GuardedString password = (GuardedString)ConnectorHelper.get(AuthenticationApiOpTests.getDataProvider(), this.getTestName(), GuardedString.class, OperationalAttributes.PASSWORD_NAME, this.getObjectClass().getObjectClassValue(), 0, false);
            Uid authenticatedUid = this.authenticateExpectingSuccess(name, password);
            String MSG = "Authenticate returned wrong Uid, expected: %s, returned: %s.";
            Assert.assertEquals((String)String.format(MSG, uid, authenticatedUid), (Object)uid, (Object)authenticatedUid);
            if (this.isOperationalAttributeUpdateable(OperationalAttributes.PASSWORD_NAME)) {
                GuardedString newpassword = (GuardedString)ConnectorHelper.get(AuthenticationApiOpTests.getDataProvider(), this.getTestName(), GuardedString.class, OperationalAttributes.PASSWORD_NAME, "modified", this.getObjectClass().getObjectClassValue(), 0, false);
                HashSet<Attribute> replaceAttrs = new HashSet<Attribute>();
                replaceAttrs.add(AttributeBuilder.buildPassword((GuardedString)newpassword));
                if (ConnectorHelper.isAttrSupported(this.getObjectClassInfo(), OperationalAttributes.CURRENT_PASSWORD_NAME)) {
                    replaceAttrs.add(AttributeBuilder.buildCurrentPassword((GuardedString)password));
                }
                uid = this.getConnectorFacade().update(this.getObjectClass(), uid, replaceAttrs, this.getOperationOptionsByOp(UpdateApiOp.class));
                authenticatedUid = this.authenticateExpectingSuccess(name, newpassword);
                Assert.assertEquals((String)String.format(MSG, uid, authenticatedUid), (Object)uid, (Object)authenticatedUid);
                if (ConnectorHelper.isAttrSupported(this.getObjectClassInfo(), PredefinedAttributes.LAST_PASSWORD_CHANGE_DATE_NAME)) {
                    LOG.info("LAST_PASSWORD_CHANGE_DATE test.", new Object[0]);
                    OperationOptionsBuilder builder = new OperationOptionsBuilder();
                    builder.setAttributesToGet(new String[]{PredefinedAttributes.LAST_PASSWORD_CHANGE_DATE_NAME});
                    ConnectorObject lastPasswordChange = this.getConnectorFacade().getObject(this.getObjectClass(), uid, builder.build());
                    Assert.assertNotNull((String)"LAST_PASSWORD_CHANGE_DATE attribute is null.", (Object)lastPasswordChange.getAttributeByName(PredefinedAttributes.LAST_PASSWORD_CHANGE_DATE_NAME));
                } else {
                    LOG.info("Skipping LAST_PASSWORD_CHANGE_DATE test.", new Object[0]);
                }
            }
            if (ConnectorHelper.isAttrSupported(this.getObjectClassInfo(), PredefinedAttributes.LAST_LOGIN_DATE_NAME)) {
                LOG.info("LAST_LOGIN_DATE test.", new Object[0]);
                OperationOptionsBuilder builder = new OperationOptionsBuilder();
                builder.setAttributesToGet(new String[]{PredefinedAttributes.LAST_LOGIN_DATE_NAME});
                ConnectorObject lastLogin = this.getConnectorFacade().getObject(this.getObjectClass(), uid, builder.build());
                Assert.assertNotNull((String)"LAST_LOGIN_DATE attribute is null.", (Object)lastLogin.getAttributeByName(PredefinedAttributes.LAST_LOGIN_DATE_NAME));
            } else {
                LOG.info("Skipping LAST_LOGIN_DATE test.", new Object[0]);
            }
            if (uid == null) return;
        }
        catch (Throwable throwable) {
            if (uid == null) throw throwable;
            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
            throw throwable;
        }
        ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpEnable() {
        block5: {
            block4: {
                if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations()) || !this.isOperationalAttributeUpdateable(OperationalAttributes.ENABLE_NAME)) break block4;
                Uid uid = null;
                try {
                    Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(AuthenticationApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, true, false);
                    Iterator<Attribute> i = attrs.iterator();
                    while (i.hasNext()) {
                        Attribute attr = i.next();
                        if (!attr.is(OperationalAttributes.PASSWORD_EXPIRED_NAME) && !attr.is(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME) && !attr.is(OperationalAttributes.ENABLE_DATE_NAME) || ConnectorHelper.isRequired(this.getObjectClassInfo(), attr)) continue;
                        i.remove();
                    }
                    uid = this.getConnectorFacade().create(this.getObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
                    String name = (String)AuthenticationApiOpTests.getDataProvider().getTestSuiteAttribute(this.getObjectClass().getObjectClassValue() + "." + USERNAME_PROP, TEST_NAME);
                    HashSet<Attribute> updateAttrs = new HashSet<Attribute>();
                    updateAttrs.add(AttributeBuilder.buildEnabled((boolean)false));
                    Uid newUid = this.getConnectorFacade().update(this.getObjectClass(), uid, updateAttrs, null);
                    if (!uid.equals((Object)newUid) && newUid != null) {
                        uid = newUid;
                    }
                    GuardedString password = (GuardedString)ConnectorHelper.get(AuthenticationApiOpTests.getDataProvider(), this.getTestName(), GuardedString.class, OperationalAttributes.PASSWORD_NAME, this.getObjectClassInfo().getType(), 0, false);
                    Assert.assertTrue((String)"Authenticate must throw for disabled account", (boolean)this.authenticateExpectingRuntimeException(name, password));
                }
                catch (Throwable throwable) {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                    throw throwable;
                }
                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                break block5;
            }
            LOG.info("Skipping testOpEnable test.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpPasswordExpirationDate() {
        block5: {
            block4: {
                if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations()) || !this.isOperationalAttributeUpdateable(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME)) break block4;
                Uid uid = null;
                try {
                    Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(AuthenticationApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, true, false);
                    Iterator<Attribute> i = attrs.iterator();
                    while (i.hasNext()) {
                        Attribute attr = i.next();
                        if (!attr.is(OperationalAttributes.ENABLE_NAME) && !attr.is(OperationalAttributes.ENABLE_DATE_NAME) && !attr.is(OperationalAttributes.PASSWORD_EXPIRED_NAME) || ConnectorHelper.isRequired(this.getObjectClassInfo(), attr)) continue;
                        i.remove();
                    }
                    uid = this.getConnectorFacade().create(this.getObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
                    String name = (String)AuthenticationApiOpTests.getDataProvider().getTestSuiteAttribute(this.getObjectClass().getObjectClassValue() + "." + USERNAME_PROP, TEST_NAME);
                    HashSet<Attribute> updateAttrs = new HashSet<Attribute>();
                    updateAttrs.add(AttributeBuilder.buildPasswordExpirationDate((Date)new Date()));
                    Uid newUid = this.getConnectorFacade().update(this.getObjectClass(), uid, updateAttrs, null);
                    if (!uid.equals((Object)newUid) && newUid != null) {
                        uid = newUid;
                    }
                    GuardedString password = (GuardedString)ConnectorHelper.get(AuthenticationApiOpTests.getDataProvider(), this.getTestName(), GuardedString.class, OperationalAttributes.PASSWORD_NAME, this.getObjectClassInfo().getType(), 0, false);
                    PasswordExpiredException pwe = this.authenticateExpectingPasswordExpired(name, password);
                    Assert.assertNotNull((String)"Authenticate should throw PasswordExpiredException.", (Object)pwe);
                    String MSG = "PasswordExpiredException contains wrong Uid, expected: %s, returned: %s";
                    Assert.assertEquals((String)String.format("PasswordExpiredException contains wrong Uid, expected: %s, returned: %s", uid, pwe.getUid()), (Object)uid, (Object)pwe.getUid());
                }
                catch (Throwable throwable) {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                    throw throwable;
                }
                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                break block5;
            }
            LOG.info("Skipping testOpPasswordExpirationDate test.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpPasswordExpired() {
        block5: {
            block4: {
                if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations()) || !this.isOperationalAttributeUpdateable(OperationalAttributes.PASSWORD_EXPIRED_NAME)) break block4;
                Uid uid = null;
                try {
                    Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(AuthenticationApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, true, false);
                    Iterator<Attribute> i = attrs.iterator();
                    while (i.hasNext()) {
                        Attribute attr = i.next();
                        if (!attr.is(OperationalAttributes.ENABLE_NAME) && !attr.is(OperationalAttributes.ENABLE_DATE_NAME) && !attr.is(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME) || ConnectorHelper.isRequired(this.getObjectClassInfo(), attr)) continue;
                        i.remove();
                    }
                    uid = this.getConnectorFacade().create(this.getObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
                    String name = (String)AuthenticationApiOpTests.getDataProvider().getTestSuiteAttribute(this.getObjectClass().getObjectClassValue() + "." + USERNAME_PROP, TEST_NAME);
                    HashSet<Attribute> updateAttrs = new HashSet<Attribute>();
                    updateAttrs.add(AttributeBuilder.buildPasswordExpired((boolean)true));
                    Uid newUid = this.getConnectorFacade().update(this.getObjectClass(), uid, updateAttrs, null);
                    if (!uid.equals((Object)newUid) && newUid != null) {
                        uid = newUid;
                    }
                    GuardedString password = (GuardedString)ConnectorHelper.get(AuthenticationApiOpTests.getDataProvider(), this.getTestName(), GuardedString.class, OperationalAttributes.PASSWORD_NAME, this.getObjectClassInfo().getType(), 0, false);
                    PasswordExpiredException pwe = this.authenticateExpectingPasswordExpired(name, password);
                    Assert.assertNotNull((String)"Authenticate should throw PasswordExpiredException.", (Object)pwe);
                    String MSG = "PasswordExpiredException contains wrong Uid, expected: %s, returned: %s";
                    Assert.assertEquals((String)String.format("PasswordExpiredException contains wrong Uid, expected: %s, returned: %s", uid, pwe.getUid()), (Object)uid, (Object)pwe.getUid());
                }
                catch (Throwable throwable) {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                    throw throwable;
                }
                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                break block5;
            }
            LOG.info("Skipping testOpPasswordExpired test.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPasswordBeforePasswordExpired() {
        block5: {
            block4: {
                if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations()) || !this.isOperationalAttributeUpdateable(OperationalAttributes.PASSWORD_NAME) || !this.isOperationalAttributeUpdateable(OperationalAttributes.PASSWORD_EXPIRED_NAME)) break block4;
                Uid uid = null;
                try {
                    Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(AuthenticationApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, true, false);
                    Iterator<Attribute> i = attrs.iterator();
                    while (i.hasNext()) {
                        Attribute attr = i.next();
                        if (!attr.is(OperationalAttributes.ENABLE_NAME) && !attr.is(OperationalAttributes.ENABLE_DATE_NAME) && !attr.is(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME) || ConnectorHelper.isRequired(this.getObjectClassInfo(), attr)) continue;
                        i.remove();
                    }
                    uid = this.getConnectorFacade().create(this.getObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
                    String name = (String)AuthenticationApiOpTests.getDataProvider().getTestSuiteAttribute(this.getObjectClass().getObjectClassValue() + "." + USERNAME_PROP, TEST_NAME);
                    GuardedString newpassword = (GuardedString)ConnectorHelper.get(AuthenticationApiOpTests.getDataProvider(), this.getTestName(), GuardedString.class, OperationalAttributes.PASSWORD_NAME, "modified", this.getObjectClassInfo().getType(), 0, false);
                    HashSet<Attribute> replaceAttrs = new HashSet<Attribute>();
                    replaceAttrs.add(AttributeBuilder.buildPassword((GuardedString)newpassword));
                    replaceAttrs.add(AttributeBuilder.buildPasswordExpired((boolean)true));
                    if (ConnectorHelper.isAttrSupported(this.getObjectClassInfo(), OperationalAttributes.CURRENT_PASSWORD_NAME)) {
                        GuardedString password = (GuardedString)ConnectorHelper.get(AuthenticationApiOpTests.getDataProvider(), this.getTestName(), GuardedString.class, OperationalAttributes.PASSWORD_NAME, this.getObjectClassInfo().getType(), 0, false);
                        replaceAttrs.add(AttributeBuilder.buildCurrentPassword((GuardedString)password));
                    }
                    uid = this.getConnectorFacade().update(this.getObjectClass(), uid, replaceAttrs, this.getOperationOptionsByOp(UpdateApiOp.class));
                    PasswordExpiredException pwe = this.authenticateExpectingPasswordExpired(name, newpassword);
                    Assert.assertNotNull((String)"Authenticate should throw PasswordExpiredException.", (Object)pwe);
                }
                catch (Throwable throwable) {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                    throw throwable;
                }
                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                break block5;
            }
            LOG.info("Skipping test ''testPasswordBeforePasswordExpired'' for object class {0}", new Object[]{this.getObjectClass()});
        }
    }

    private boolean isOperationalAttributeUpdateable(String name) {
        ObjectClassInfo oinfo = this.getObjectClassInfo();
        for (AttributeInfo ainfo : oinfo.getAttributeInfo()) {
            if (!ainfo.is(name)) continue;
            return ainfo.isUpdateable();
        }
        return false;
    }

    @Override
    public String getTestName() {
        return TEST_NAME;
    }

    private long getLongTestParam(String name, long defaultValue) {
        long longValue = defaultValue;
        try {
            Object valueObject = AuthenticationApiOpTests.getDataProvider().getTestSuiteAttribute(name, TEST_NAME);
            if (valueObject != null) {
                longValue = Long.parseLong(valueObject.toString());
            }
        }
        catch (ObjectNotFoundException ex) {
            // empty catch block
        }
        return longValue;
    }

    private void sleepIngoringInterruption(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean authenticateExpectingRuntimeException(String name, GuardedString password) {
        boolean authenticateFailed = false;
        int i = 0;
        while ((long)i < this.getLongTestParam(MAX_ITERATIONS, 1L)) {
            try {
                this.getConnectorFacade().authenticate(ObjectClass.ACCOUNT, name, password, this.getOperationOptionsByOp(AuthenticationApiOp.class));
            }
            catch (RuntimeException e) {
                authenticateFailed = true;
                break;
            }
            LOG.info(String.format("Retrying authentication - iteration %d", i), new Object[0]);
            this.sleepIngoringInterruption(this.getLongTestParam(SLEEP_MILLISECONDS, 0L));
            ++i;
        }
        return authenticateFailed;
    }

    private boolean authenticateExpectingInvalidCredentials(String name, GuardedString password) {
        boolean authenticateFailed = false;
        int i = 0;
        while ((long)i < this.getLongTestParam(MAX_ITERATIONS, 1L)) {
            try {
                this.getConnectorFacade().authenticate(ObjectClass.ACCOUNT, name, password, this.getOperationOptionsByOp(AuthenticationApiOp.class));
            }
            catch (InvalidCredentialException e) {
                authenticateFailed = true;
                break;
            }
            LOG.info(String.format("Retrying authentication - iteration %d", i), new Object[0]);
            this.sleepIngoringInterruption(this.getLongTestParam(SLEEP_MILLISECONDS, 0L));
            ++i;
        }
        return authenticateFailed;
    }

    private Uid authenticateExpectingSuccess(String name, GuardedString password) {
        Uid authenticatedUid = null;
        RuntimeException lastException = null;
        int i = 0;
        while ((long)i < this.getLongTestParam(MAX_ITERATIONS, 1L)) {
            try {
                authenticatedUid = this.getConnectorFacade().authenticate(ObjectClass.ACCOUNT, name, password, this.getOperationOptionsByOp(AuthenticationApiOp.class));
                lastException = null;
                break;
            }
            catch (RuntimeException e) {
                lastException = e;
                LOG.info(String.format("Retrying authentication - iteration %d", i), new Object[0]);
                this.sleepIngoringInterruption(this.getLongTestParam(SLEEP_MILLISECONDS, 0L));
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return authenticatedUid;
    }

    private PasswordExpiredException authenticateExpectingPasswordExpired(String name, GuardedString password) {
        PasswordExpiredException passwordExpiredException = null;
        RuntimeException lastException = null;
        int i = 0;
        while ((long)i < this.getLongTestParam(MAX_ITERATIONS, 1L)) {
            try {
                this.getConnectorFacade().authenticate(ObjectClass.ACCOUNT, name, password, this.getOperationOptionsByOp(AuthenticationApiOp.class));
            }
            catch (PasswordExpiredException e) {
                passwordExpiredException = e;
                lastException = null;
                break;
            }
            catch (RuntimeException e) {
                lastException = e;
            }
            LOG.info(String.format("Retrying authentication - iteration %d", i), new Object[0]);
            this.sleepIngoringInterruption(this.getLongTestParam(SLEEP_MILLISECONDS, 0L));
            ++i;
        }
        if (lastException != null) {
            throw lastException;
        }
        return passwordExpiredException;
    }
}

