/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ContractTestBase;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.TestApiOp;
import org.junit.Assert;
import org.junit.Test;

public class TestApiOpTests
extends ContractTestBase {
    private static final Log LOG = Log.getLog(TestApiOpTests.class);
    private static final String TEST_NAME = "Test";
    private static final String PROPERTY_NAME_INVALID_CONFIG = "invalidConfig";

    @Test
    public void testTestFail() {
        String testPropertyName = "testsuite.Test.invalidConfig";
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getAPIOperations())) {
            Object o = null;
            try {
                o = TestApiOpTests.getDataProvider().getTestSuiteAttribute(PROPERTY_NAME_INVALID_CONFIG, TEST_NAME);
            }
            catch (ObjectNotFoundException ex) {
                Assert.fail((String)String.format("Missing test property: '%s'", "testsuite.Test.invalidConfig"));
            }
            if (!(o instanceof List)) {
                Assert.fail((String)String.format("Test property '%s' should be of type List", "testsuite.Test.invalidConfig"));
            }
            List wrongConfigList = (List)o;
            for (Object currentWrongConfigMap : wrongConfigList) {
                if (!(currentWrongConfigMap instanceof Map)) {
                    Assert.fail((String)String.format("Test property '%s' contains other than Map properties.", "testsuite.Test.invalidConfig"));
                }
                Map currentWrongMapConfig = (Map)currentWrongConfigMap;
                this._connFacade = ConnectorHelper.createConnectorFacadeWithWrongConfiguration(TestApiOpTests.getDataProvider(), currentWrongMapConfig);
                try {
                    this.getConnectorFacade().test();
                    String msg = String.format("test() should throw RuntimeException because configuration should be invalid. Wrong properties used: \n%s", currentWrongMapConfig.toString());
                    Assert.fail((String)msg);
                }
                catch (RuntimeException ex) {}
            }
        } else {
            LOG.info("--------------------------------", new Object[0]);
            LOG.info("Skipping test ''testTestFail''.", new Object[0]);
            LOG.info("--------------------------------", new Object[0]);
        }
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(TestApiOp.class);
        return s;
    }
}

