/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.data;

import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.data.Chooser;
import org.identityconnectors.contract.data.DataProvider;
import org.identityconnectors.contract.data.GroovyConfigReader;
import org.identityconnectors.contract.data.RandomGenerator;
import org.identityconnectors.contract.data.groovy.Get;
import org.identityconnectors.contract.data.groovy.Lazy;
import org.identityconnectors.contract.data.groovy.Random;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.test.common.TestHelpers;
import org.junit.Assert;

public class GroovyDataProvider
implements DataProvider {
    private static final int SINGLE_VALUE_MARKER = -1;
    private static final String ARRAY_MARKER = "array";
    static final String PROPERTY_SEPARATOR = ".";
    private static final String BOOTSTRAP_FILE_NAME = "bootstrap.groovy";
    public static final String MULTI_VALUE_TYPE_PREFIX = "multi";
    private ConfigObject configObject;
    private Map<String, Object> cache = new HashMap<String, Object>();
    private final ConfigSlurper cs = new ConfigSlurper();
    private static final Log LOG = Log.getLog(GroovyDataProvider.class);
    private final String PARAM_PROPERTY_OUT_FILE = "test.parameters.outFile";
    private final String PARAM_QUERIED_PROPERTY_OUT_FILE = "test.parameters.outQueriedFile";
    private StringBuffer dumpBuffer = null;
    private StringBuffer dumpBufferNotFound = null;
    private StringBuffer dumpBufferDefaultVal = null;
    private File _propertyOutFile = null;
    private File _queriedPropsOutFile = null;
    static final String ASSIGNMENT_MARK = "=";
    private final String FOUND_MSG = "found";
    private final boolean DEBUG_ON = false;
    private final String EMPTY_PREFIX = "";

    public GroovyDataProvider() {
        this(System.getProperty("connectorName"));
    }

    public GroovyDataProvider(String connectorName) {
        if (StringUtil.isBlank((String)connectorName)) {
            throw new IllegalArgumentException("To run contract tests, you must specify valid [connectorName] system property with the value equal to FQN of your connector class, or use GroovyDataProvider(String connectorName) constructor");
        }
        this.initSnapshot();
        this.initQueriedPropsDump();
        this.configObject = this.doBootstrap();
        ConfigObject projectConfig = GroovyConfigReader.loadResourceConfiguration(connectorName, this.getClass().getClassLoader());
        this.configObject = GroovyDataProvider.mergeConfigObjects(this.configObject, projectConfig);
        GroovyDataProvider.checkJarDependencies(this, this.getClass().getClassLoader());
    }

    private static void checkJarDependencies(DataProvider dp, ClassLoader classLoader) {
        String PROP_REQUIRED_CLASSES = "requiredClasses";
        Object o = null;
        try {
            o = dp.getTestSuiteAttribute("requiredClasses");
        }
        catch (ObjectNotFoundException ex) {
            return;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                try {
                    Class.forName((String)entry.getKey(), false, classLoader);
                }
                catch (ClassNotFoundException e) {
                    Assert.fail((String)String.format("Missing library from classpath: '%s'", entry.getValue()));
                }
            }
        }
    }

    private void initQueriedPropsDump() {
        String pOut = System.getProperty("test.parameters.outQueriedFile");
        if (StringUtil.isNotBlank((String)pOut)) {
            try {
                this._queriedPropsOutFile = new File(pOut);
                if (!this._queriedPropsOutFile.exists()) {
                    this._queriedPropsOutFile.createNewFile();
                }
                if (!this._queriedPropsOutFile.canWrite()) {
                    this._queriedPropsOutFile = null;
                    LOG.warn("Unable to write to ''{0}'' file, the test parameters will not be stored", new Object[]{pOut});
                } else {
                    LOG.info("Storing parameter values to ''{0}'', you can rerun the test with the same parameters later", new Object[]{pOut});
                }
            }
            catch (IOException iOException) {
                LOG.warn("Unable to create ''{0}'' file, the test parameters will not be stored", new Object[]{pOut});
            }
        }
        this.dumpBuffer = new StringBuffer();
        this.dumpBufferNotFound = new StringBuffer();
        this.dumpBufferDefaultVal = new StringBuffer();
    }

    private void initSnapshot() {
        String pOut = System.getProperty("test.parameters.outFile");
        if (StringUtil.isNotBlank((String)pOut)) {
            try {
                this._propertyOutFile = new File(pOut);
                if (!this._propertyOutFile.exists()) {
                    this._propertyOutFile.createNewFile();
                }
                if (!this._propertyOutFile.canWrite()) {
                    this._propertyOutFile = null;
                    LOG.warn("Unable to write to ''{0}'' file, the test parameters will not be stored", new Object[]{pOut});
                } else {
                    LOG.info("Storing parameter values to ''{0}'', you can rerun the test with the same parameters later", new Object[]{pOut});
                }
            }
            catch (IOException iOException) {
                LOG.warn("Unable to create ''{0}'' file, the test parameters will not be stored", new Object[]{pOut});
            }
        }
    }

    GroovyDataProvider(URL configURL) {
        this.configObject = this.doBootstrap();
        ConfigObject highPriorityCO = this.cs.parse(configURL);
        this.configObject = GroovyDataProvider.mergeConfigObjects(this.configObject, highPriorityCO);
    }

    private ConfigObject doBootstrap() {
        URL url = this.getClass().getClassLoader().getResource(BOOTSTRAP_FILE_NAME);
        String msg = String.format("Missing bootstrap file: %s. (Hint: copy framework/test-contract/src/bootstrap.groovy to folder framework/test-contract/build)", BOOTSTRAP_FILE_NAME);
        Assert.assertNotNull((String)msg, (Object)url);
        return this.cs.parse(url);
    }

    static ConfigObject mergeConfigObjects(ConfigObject lowPriorityCO, ConfigObject highPriorityCO) {
        return (ConfigObject)lowPriorityCO.merge(highPriorityCO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, String type, boolean useDefault) {
        Object o;
        block9: {
            o = null;
            boolean isDefaultValue = false;
            boolean isFound = true;
            try {
                o = this.propertyRecursiveGet(name);
            }
            catch (ObjectNotFoundException onfe) {
                if (useDefault) {
                    isDefaultValue = true;
                    o = this.propertyRecursiveGet(type);
                    break block9;
                }
                isFound = false;
                if (useDefault) {
                    throw new ObjectNotFoundException("Missing property definition: " + name + ", data type: " + type);
                }
                throw new ObjectNotFoundException("Missing property definition: " + name);
            }
            finally {
                if (this._queriedPropsOutFile != null) {
                    this.logQueriedProperties(o, name, type, isDefaultValue, isFound);
                }
            }
        }
        if (o instanceof ObjectNotFoundException) {
            throw (ObjectNotFoundException)o;
        }
        this.cache.put(name, o);
        return o;
    }

    private void logQueriedProperties(Object queriedObject, String name, String type, boolean isDefaultValue, boolean isFound) {
        String msg = "name: '%s' type: '%s' defaultReturned: '%s' %s: '%s'";
        String appendInfo = String.format(msg, name, type, Boolean.toString(isDefaultValue), "found", Boolean.toString(isFound)) + (queriedObject != null ? " value: " + this.flatten(queriedObject) : "") + "\n";
        this.dumpBuffer.append(appendInfo);
        if (!isFound) {
            this.dumpBufferNotFound.append(appendInfo);
        }
        if (isDefaultValue) {
            this.dumpBufferDefaultVal.append(appendInfo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object propertyRecursiveGet(String name) {
        Object response = null;
        if (this.cache.containsKey(name)) return this.cache.get(name);
        try {
            return this.configObjectRecursiveGet(name, this.configObject);
        }
        catch (ObjectNotFoundException onfe) {
            int separatorIndex = name.indexOf(PROPERTY_SEPARATOR, 0);
            if (separatorIndex == -1) throw new ObjectNotFoundException("Can't find object for key:  " + name);
            if (++separatorIndex >= name.length()) return response;
            return this.propertyRecursiveGet(name.substring(separatorIndex));
        }
    }

    private Object configObjectRecursiveGet(String name, ConfigObject co) {
        int dotIndex = name.indexOf(PROPERTY_SEPARATOR);
        if (dotIndex >= 0) {
            String currentNamePart = name.substring(0, dotIndex);
            Object o = this.configObjectGet(co, currentNamePart);
            if (o instanceof ConfigObject) {
                return this.configObjectRecursiveGet(name.substring(dotIndex + 1), (ConfigObject)o);
            }
            String MSG = "Unexpected object instance. Searching property: '%s', found value: '%s', expected value is ConfigObject. Please check that property '%s' is defined - it can collide with attribute value definition.";
            Assert.fail((String)String.format("Unexpected object instance. Searching property: '%s', found value: '%s', expected value is ConfigObject. Please check that property '%s' is defined - it can collide with attribute value definition.", name, o.toString(), name));
            return null;
        }
        return this.configObjectGet(co, name);
    }

    private Object configObjectGet(ConfigObject co, String currentNamePart) {
        Object result = co.getProperty(currentNamePart);
        if (result instanceof ConfigObject) {
            ConfigObject coResult = (ConfigObject)result;
            if (coResult.size() == 0) {
                throw new ObjectNotFoundException();
            }
        } else {
            result = this.resolvePropObject(result);
        }
        return result;
    }

    private Object resolvePropObject(Object o) {
        Object resolved = o;
        if (o instanceof Lazy) {
            Lazy lazy = (Lazy)((Object)o);
            resolved = this.resolveLazy(lazy);
        } else if (o instanceof List) {
            List list = o;
            resolved = this.resolveList(list);
        } else if (o instanceof Map) {
            Map map = (Map)((Object)o);
            resolved = this.resolveMap(map);
        }
        return resolved;
    }

    private Map<?, Object> resolveMap(Map<?, Object> map) {
        Map<?, Object> localMap = map;
        for (Map.Entry<?, Object> pairKV : localMap.entrySet()) {
            Object object = pairKV.getValue();
            if (object instanceof Lazy) {
                Lazy lazyO = (Lazy)object;
                Object resolvedObj = this.resolveLazy(lazyO);
                pairKV.setValue(resolvedObj);
                continue;
            }
            if (!(object instanceof Map)) continue;
            Map arg = (Map)object;
            Map<?, Object> resolvedMap = this.resolveMap(arg);
            pairKV.setValue(resolvedMap);
        }
        return localMap;
    }

    private List<Object> resolveList(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : list) {
            if (object instanceof Lazy) {
                Lazy lazyO = (Lazy)object;
                Object resolvedObj = this.resolveLazy(lazyO);
                result.add(resolvedObj);
                continue;
            }
            if (object instanceof List) {
                List arg = (List)object;
                List<Object> resolvedList = this.resolveList(arg);
                result.add(resolvedList);
                continue;
            }
            result.add(object);
        }
        return result;
    }

    private Object resolveLazy(Lazy lazy) {
        Object value = lazy.getValue();
        Object resolvedValue = null;
        if (value != null) {
            if (value instanceof Lazy) {
                value = this.resolveLazy((Lazy)value);
            }
            if (lazy instanceof Get) {
                Assert.assertTrue((boolean)(value instanceof String));
                resolvedValue = this.get((String)value, null, false);
            } else if (lazy instanceof Random) {
                Assert.assertTrue((boolean)(value instanceof String));
                Random rnd = (Random)lazy;
                resolvedValue = rnd.generate();
            }
        }
        if (!lazy.getSuccessors().isEmpty()) {
            return this.concatenate(resolvedValue, lazy.getSuccessors());
        }
        return resolvedValue;
    }

    private String concatenate(Object value, List<Object> successors) {
        StringBuffer sb = new StringBuffer();
        if (value != null) {
            sb.append(value.toString());
        }
        for (Object o : successors) {
            if (o instanceof String) {
                sb.append((String)o);
                continue;
            }
            if (!(o instanceof Lazy)) continue;
            Object resolved = this.resolveLazy((Lazy)o);
            sb.append(resolved.toString());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Class<?> dataTypeName, String name, String componentName, int sequenceNumber, boolean isMultivalue) {
        String shortTypeName = GroovyDataProvider.getShortTypeName(dataTypeName);
        if (isMultivalue) {
            String tmp;
            shortTypeName = tmp = String.format("multi%s%s", PROPERTY_SEPARATOR, shortTypeName);
        }
        Assert.assertFalse((boolean)this.cache.keySet().contains("param.sequenceNumber"));
        Assert.assertFalse((boolean)this.cache.keySet().contains("param.componentName"));
        Assert.assertFalse((boolean)this.cache.keySet().contains("param.name"));
        Assert.assertFalse((boolean)this.cache.keySet().contains("param.dataTypeName"));
        StringBuffer sbPath = new StringBuffer();
        if (sequenceNumber != -1) {
            sbPath.append("i");
            sbPath.append(sequenceNumber);
            sbPath.append(PROPERTY_SEPARATOR);
            this.cache.put("param.sequenceNumber", "i" + String.valueOf(sequenceNumber));
        }
        sbPath.append(componentName);
        sbPath.append(PROPERTY_SEPARATOR);
        sbPath.append(name);
        LOG.info("getting data for ''{0}'', type: ''{1}''", new Object[]{sbPath, dataTypeName});
        this.cache.put("param.componentName", componentName);
        this.cache.put("param.name", name);
        this.cache.put("param.dataTypeName", shortTypeName);
        try {
            Object obj = this.get(sbPath.toString(), shortTypeName, true);
            LOG.info("Fully resolved ''{0}'' to value ''{1}''", new Object[]{sbPath.toString(), obj});
            Object object = obj;
            return object;
        }
        catch (ObjectNotFoundException ex) {
            LOG.info("Unable to find data for ''{0}''", new Object[]{sbPath.toString()});
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex, "Error occured while resolving property ''{0}''", new Object[]{sbPath.toString()});
        }
        finally {
            this.cache.remove("param.dataTypeName");
            this.cache.remove("param.name");
            this.cache.remove("param.componentName");
            this.cache.remove("param.sequenceNumber");
            Assert.assertFalse((boolean)this.cache.keySet().contains("param.sequenceNumber"));
            Assert.assertFalse((boolean)this.cache.keySet().contains("param.componentName"));
            Assert.assertFalse((boolean)this.cache.keySet().contains("param.name"));
            Assert.assertFalse((boolean)this.cache.keySet().contains("param.dataTypeName"));
        }
        throw new ObjectNotFoundException("Can't find object for key:  " + sbPath.toString());
    }

    @Override
    public Object get(Class<?> dataTypeName, String name, String componentName) {
        return this.get(dataTypeName, name, componentName, -1, false);
    }

    @Override
    public String getString(String name, String componentName, int sequenceNumber) {
        return (String)this.get(String.class, name, componentName, sequenceNumber, false);
    }

    @Override
    public String getString(String name, String componentName) {
        return (String)this.get(String.class, name, componentName);
    }

    @Override
    public Object getTestSuiteAttribute(String propName) {
        return this.get("testsuite." + propName, null, false);
    }

    @Override
    public Object getTestSuiteAttribute(String propName, String testName) {
        return this.get("testsuite." + testName + PROPERTY_SEPARATOR + propName, null, false);
    }

    @Override
    public Object getConnectorAttribute(String propName) {
        return this.get("connector." + propName, null, false);
    }

    @Override
    public Object get(String name) {
        Map<?, Object> result = this.get(name, null, false);
        if (result instanceof Map) {
            Map map = result;
            result = this.resolveMap(map);
        }
        return result;
    }

    @Override
    public Object generate(String pattern, Class<?> clazz) {
        return RandomGenerator.generate(pattern, clazz);
    }

    @Override
    public Object generate(String pattern) {
        return RandomGenerator.generate(pattern);
    }

    @Override
    public Object get(String name, int sequenceNumber) {
        String resolvedName = String.format("i%s%s%s", sequenceNumber, PROPERTY_SEPARATOR, name);
        return this.get(resolvedName);
    }

    private Map<String, Object> getPropertyMap(String setName) {
        Map propMap = (Map)this.get(setName);
        return propMap;
    }

    @Override
    public Set<Attribute> getAttributeSet(String propertySetName) {
        Map<String, Object> propMap = this.getPropertyMap(propertySetName);
        Assert.assertNotNull(propMap);
        LinkedHashSet<Attribute> attrSet = new LinkedHashSet<Attribute>();
        for (Map.Entry<String, Object> entry : propMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                List<Object> list = Arrays.asList(array);
                attrSet.add(AttributeBuilder.build((String)key, list));
                continue;
            }
            if (value instanceof Collection) {
                attrSet.add(AttributeBuilder.build((String)key, (Collection)((Collection)value)));
                continue;
            }
            attrSet.add(AttributeBuilder.build((String)key, (Object[])new Object[]{value}));
        }
        return attrSet;
    }

    @Override
    public void loadConfiguration(String configName, Configuration cfg) {
        Map<String, Object> propMap = this.getPropertyMap(configName);
        Assert.assertNotNull(propMap);
        TestHelpers.fillConfiguration((Configuration)cfg, propMap);
    }

    static String getShortTypeName(Class<?> dataType) {
        String shortName = dataType.getSimpleName();
        boolean isArray = dataType.isArray();
        if (isArray) {
            if (shortName.length() > 2) {
                String tmp;
                shortName = tmp = shortName.replace("[]", ARRAY_MARKER);
            } else {
                LOG.warn("Can't get short type for ''{0}'' (missing array type)", new Object[]{dataType.getName()});
            }
        }
        return String.format("T%s", shortName.toLowerCase());
    }

    Object writeDataToFile() {
        if (this._propertyOutFile == null) {
            return null;
        }
        String result = this.flatten(this.configObject);
        FileWriter fw = null;
        try {
            fw = new FileWriter(this._propertyOutFile, true);
            fw.append("\n\n\n ============================ NEW TEST ==================== \n\n\n");
            fw.append(result);
            fw.close();
        }
        catch (IOException e) {
            LOG.warn("Writing to contract test property out file failed ''{0}''", new Object[]{this._propertyOutFile.getAbsolutePath()});
        }
        return result;
    }

    private String writeQueriedDumpToFile() {
        if (this._queriedPropsOutFile == null) {
            return null;
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(this._queriedPropsOutFile, true);
            fw.append("<dumpSummary>\n");
            fw.append("  <missingProperties>\n");
            String notFoundPropsList = this.dumpBufferNotFound.toString();
            if (StringUtil.isBlank((String)notFoundPropsList)) {
                fw.append("every property was found\n");
            } else {
                fw.append("The following properties WERE NOT FOUND:\n");
            }
            fw.append(this.dumpBufferNotFound.toString() + "\n");
            fw.append("  </missingProperties>\n");
            fw.append("  <defaultValueGeneratedForProperties>\n");
            if (StringUtil.isBlank((String)this.dumpBufferDefaultVal.toString())) {
                fw.append("no default value was used.");
            } else {
                fw.append("the following default values were used.");
            }
            fw.append(this.dumpBufferDefaultVal.toString() + "\n");
            fw.append("  </defaultValueGeneratedForProperties>\n");
            fw.append("</dumpSummary> \n\n\n");
            fw.append("\n\n\n ============================ NEW TEST ==================== \n\n\n");
            fw.append(this.dumpBuffer.toString() + "\n");
            fw.close();
        }
        catch (IOException e) {
            LOG.warn("Writing to contract test property out file failed ''{0}''", new Object[]{this._queriedPropsOutFile.getAbsolutePath()});
        }
        LOG.info("Dump file of queried properties written to: ''{0}''", new Object[]{this._queriedPropsOutFile.getAbsolutePath()});
        return this.dumpBuffer.toString();
    }

    private String flatten(Object obj, Chooser choice, String prefix) {
        String svalue = null;
        if (obj instanceof ConfigObject) {
            svalue = this.flattenCO(obj, prefix);
        } else if (obj instanceof Map) {
            svalue = this.flattenMap(obj);
        } else if (obj instanceof List) {
            svalue = this.flattenList(obj);
        } else if (obj instanceof Lazy) {
            Object resolvedObj = this.flattenLazy((Lazy)obj, prefix);
            svalue = this.quoteLazyIfNeeded(resolvedObj.toString());
        } else {
            String output = obj == null ? "null" : obj.toString();
            switch (choice) {
                case QUOTED: {
                    svalue = String.format("\"%s\"", output);
                    break;
                }
                case NOT_QUOTED: {
                    svalue = output;
                }
            }
        }
        return svalue;
    }

    private String flatten(Object obj) {
        return this.flatten(obj, Chooser.QUOTED, "");
    }

    private String flatten(Object obj, String prefix) {
        return this.flatten(obj, Chooser.QUOTED, prefix);
    }

    private String quoteLazyIfNeeded(String string) {
        if (!string.startsWith("Lazy")) {
            return String.format("\"%s\"", string);
        }
        return string;
    }

    private Object flattenLazy(Lazy lazy, String prefix) {
        Object value = lazy.getValue();
        String resolvedValue = null;
        if (value != null) {
            if (value instanceof Lazy) {
                value = this.flattenLazy((Lazy)value, prefix);
            }
            if (lazy instanceof Get) {
                Assert.assertTrue((boolean)(value instanceof String));
                resolvedValue = "Lazy.get(\"" + value + "\")";
            } else if (lazy instanceof Random) {
                Random randomLazy = (Random)lazy;
                resolvedValue = this.cache.containsKey(prefix) ? this.cache.get(prefix).toString() : "Lazy.random(\"" + randomLazy.getValue() + "\", " + randomLazy.getClazz().getName() + ")";
            }
        }
        if (!lazy.getSuccessors().isEmpty()) {
            return this.concatenate(resolvedValue, lazy.getSuccessors());
        }
        return resolvedValue;
    }

    private String flattenCO(Object obj, String prefix) {
        String svalue = null;
        StringBuilder sb = new StringBuilder();
        boolean first = false;
        Map objMap = (Map)obj;
        for (Map.Entry entry : objMap.entrySet()) {
            String key;
            String value = this.flatten(entry.getValue(), this.concatToPrefix(prefix, entry.getKey()));
            if (entry.getValue() instanceof ConfigObject) {
                key = null;
                key = first ? this.debugStr("FST|") + this.flatten(entry.getKey(), Chooser.NOT_QUOTED, this.concatToPrefix(prefix, entry.getKey())) : this.debugStr("MID|") + this.flatten(entry.getKey(), this.concatToPrefix(prefix, entry.getKey()));
                sb.append(String.format("%s%s%s", key, PROPERTY_SEPARATOR, value));
            } else {
                key = null;
                key = prefix.equals("") ? this.debugStr("LSTinSNGL|") + this.flatten(entry.getKey(), Chooser.NOT_QUOTED, prefix) : this.debugStr("LSTinMULT|") + this.flatten(entry.getKey(), this.concatToPrefix(prefix, entry.getKey()));
                sb.append(String.format("%s%s%s\n", this.batchAddQuotes(first, prefix) + key, ASSIGNMENT_MARK, value));
            }
            first = true;
        }
        svalue = sb.toString();
        return svalue;
    }

    private String batchAddQuotes(boolean first, String prefix) {
        String result = null;
        result = !first || prefix == null || prefix.length() == 0 ? "" : this.debugStr("Pfix:") + this.transformPrefix(prefix) + PROPERTY_SEPARATOR + this.debugStr(":");
        return result;
    }

    private String transformPrefix(String prefix) {
        String[] parts = prefix.split("\\.");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i == 0) {
                result.append(parts[i]);
                continue;
            }
            result.append(String.format("%s\"%s\"", PROPERTY_SEPARATOR, parts[i]));
        }
        return result.toString();
    }

    private String concatToPrefix(String prefix, Object key) {
        return prefix + (prefix == null || prefix.length() == 0 ? "" : PROPERTY_SEPARATOR) + key;
    }

    private String debugStr(String string) {
        return "";
    }

    private String flattenList(Object obj) {
        String svalue = null;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        List list = (List)obj;
        for (Object item : list) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(this.flatten(item));
            first = false;
        }
        svalue = String.format("[ %s ]", sb.toString());
        return svalue;
    }

    private String flattenMap(Object obj) {
        String svalue = null;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Map objMap = (Map)obj;
        for (Map.Entry entry : objMap.entrySet()) {
            String key = this.flatten(entry.getKey());
            String value = this.flatten(entry.getValue());
            if (!first) {
                sb.append(", ");
            }
            sb.append(String.format(" %s : %s ", key, value));
            first = false;
        }
        svalue = String.format("[ %s ]", sb.toString());
        return svalue;
    }

    @Override
    public void dispose() {
        this.writeDataToFile();
        this.writeQueriedDumpToFile();
        this.cache.clear();
    }
}

