/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.data;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class RandomGenerator {
    private static Random rnd = new Random(System.currentTimeMillis());

    public static String generate(String pattern) {
        return RandomGenerator.createRandomString(pattern, RandomGenerator.getDefaultCharacterSetMap());
    }

    public static Object generate(String pattern, Class<?> clazz) {
        String generatedStr = RandomGenerator.createRandomString(pattern, RandomGenerator.getDefaultCharacterSetMap());
        if (clazz.isInstance(new byte[0])) {
            return generatedStr.getBytes();
        }
        if (Character.class.isAssignableFrom(clazz)) {
            char[] arr = generatedStr.toCharArray();
            return Character.valueOf(arr[0]);
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(char[].class);
            return constructor.newInstance(new Object[]{generatedStr.toCharArray()});
        }
        catch (Exception e) {
            try {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(generatedStr);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static Map<Character, Set<Character>> getDefaultCharacterSetMap() {
        HashMap<Character, Set<Character>> characterSetMap = new HashMap<Character, Set<Character>>();
        TreeSet<Character> alpha_lower = new TreeSet<Character>();
        TreeSet<Character> alpha_upper = new TreeSet<Character>();
        TreeSet<Character> alpha_mixed = new TreeSet<Character>();
        TreeSet<Character> alpha_numeric = new TreeSet<Character>();
        TreeSet<Character> numeric = new TreeSet<Character>();
        RandomGenerator.addRange(alpha_lower, 'a', 'z');
        RandomGenerator.addRange(alpha_upper, 'A', 'Z');
        RandomGenerator.addRange(numeric, '0', '9');
        alpha_numeric.addAll(alpha_lower);
        alpha_numeric.addAll(alpha_upper);
        alpha_numeric.addAll(numeric);
        alpha_mixed.addAll(alpha_lower);
        alpha_mixed.addAll(alpha_upper);
        characterSetMap.put(new Character('#'), numeric);
        characterSetMap.put(new Character('a'), alpha_lower);
        characterSetMap.put(new Character('A'), alpha_upper);
        characterSetMap.put(new Character('?'), alpha_mixed);
        characterSetMap.put(new Character('.'), alpha_numeric);
        return characterSetMap;
    }

    private static void addRange(Set<Character> s, char min, char max) {
        if (max < min) {
            char temp = min;
            min = max;
            max = temp;
        }
        for (char i = min; i <= max; i = (char)(i + '\u0001')) {
            s.add(new Character(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char randomCharacter(Random rnd, Set<Character> validChars) {
        int patternRange = validChars.size();
        int next = 0;
        Class<RandomGenerator> clazz = RandomGenerator.class;
        synchronized (RandomGenerator.class) {
            next = rnd.nextInt(patternRange);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            Character[] charArray = validChars.toArray(new Character[0]);
            Character charValue = charArray[next];
            return charValue.charValue();
        }
    }

    private static String createRandomString(String pattern, Map<Character, Set<Character>> characterSetMap) {
        StringBuffer replacement = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            Set<Character> characterSet = characterSetMap.get(new Character(pattern.charAt(i)));
            if (pattern.charAt(i) == '\\') {
                if (++i >= pattern.length()) continue;
                replacement.append(pattern.charAt(i));
                continue;
            }
            if (characterSet == null) {
                replacement.append(pattern.charAt(i));
                continue;
            }
            replacement.append(RandomGenerator.randomCharacter(rnd, characterSet));
        }
        return replacement.toString();
    }
}

