/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.contract.data.DataProvider;
import org.identityconnectors.contract.data.GroovyDataProvider;
import org.identityconnectors.contract.exceptions.ContractException;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.TestApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.junit.Assert;

public class ConnectorHelper {
    private static final Log LOG = Log.getLog(ConnectorHelper.class);
    private static final String JVM_ARG_DATA_PROVIDER = "data-provider";
    private static final Class<? extends DataProvider> DEFAULT_DATA_PROVIDER = GroovyDataProvider.class;

    public static DataProvider createDataProvider() {
        DataProvider dp = null;
        try {
            String customDataProvider = System.getProperty(JVM_ARG_DATA_PROVIDER);
            if (customDataProvider != null) {
                Class<?> dpClass = null;
                dpClass = Class.forName(customDataProvider);
                if (!DataProvider.class.isAssignableFrom(dpClass)) {
                    LOG.info("Class {0} is not assignable as DataProvider", new Object[]{customDataProvider});
                    throw new Exception("Class " + customDataProvider + " is not of type " + DataProvider.class.getName());
                }
                dp = (DataProvider)dpClass.newInstance();
            } else {
                LOG.info("DataProvider class not specified, using default ''{0}''.", new Object[]{DEFAULT_DATA_PROVIDER});
                dp = DEFAULT_DATA_PROVIDER.newInstance();
            }
        }
        catch (Exception ex) {
            throw ContractException.wrap(ex);
        }
        return dp;
    }

    public static ConfigurationProperties getConfigurationProperties(DataProvider dataProvider) {
        ConnectorInfoManager manager = ConnectorHelper.getInfoManager(dataProvider);
        APIConfiguration apiConfig = ConnectorHelper.getDefaultConfigurationProperties(dataProvider, manager);
        ConfigurationProperties properties = apiConfig.getConfigurationProperties();
        return properties;
    }

    private static ConnectorFacade createConnectorFacade(DataProvider dataProvider, String propertyPrefix) {
        ConfigurationProperty prop;
        ConnectorInfoManager manager = ConnectorHelper.getInfoManager(dataProvider);
        junit.framework.Assert.assertNotNull((String)"Manager can't be null, check configuration properties !", (Object)manager);
        APIConfiguration apiConfig = ConnectorHelper.getDefaultConfigurationProperties(dataProvider, manager);
        ConfigurationProperties properties = apiConfig.getConfigurationProperties();
        List propertyNames = properties.getPropertyNames();
        for (String propName : propertyNames) {
            prop = properties.getProperty(propName);
            LOG.info("OldValue = " + propName + " = '" + prop.getValue() + "' type = '" + prop.getType() + "'", new Object[0]);
            try {
                String tmpPropName = propertyPrefix != null ? propertyPrefix + "." + propName : propName;
                Object configObject = dataProvider.getConnectorAttribute(tmpPropName);
                if (configObject != null) {
                    LOG.info("Setting property ''{0}'' to value ''{1}''", new Object[]{propName, configObject.toString()});
                    properties.setPropertyValue(propName, configObject);
                    continue;
                }
                LOG.warn("No value found for connector property ''{0}''", new Object[]{propName});
            }
            catch (ObjectNotFoundException ex) {
                LOG.info("Caught Object not found exception, propName: " + propName, new Object[0]);
            }
        }
        LOG.info("----------------------------------", new Object[0]);
        for (String propName : propertyNames) {
            prop = properties.getProperty(propName);
            LOG.info(propName + " = '" + prop.getValue() + "' type = '" + prop.getType() + "'", new Object[0]);
        }
        ConnectorFacade connector = ConnectorFacadeFactory.getInstance().newInstance(apiConfig);
        junit.framework.Assert.assertNotNull((String)"Unable to create connector", (Object)connector);
        return connector;
    }

    public static ConnectorFacade createConnectorFacadeWithWrongConfiguration(DataProvider dataProvider, Map<?, ?> wrongPropertyMap) {
        ConfigurationProperty prop;
        ConnectorInfoManager manager = ConnectorHelper.getInfoManager(dataProvider);
        junit.framework.Assert.assertNotNull((String)"Manager can't be null, check configuration properties !", (Object)manager);
        APIConfiguration apiConfig = ConnectorHelper.getDefaultConfigurationProperties(dataProvider, manager);
        ConfigurationProperties properties = apiConfig.getConfigurationProperties();
        List propertyNames = properties.getPropertyNames();
        for (String propName : propertyNames) {
            prop = properties.getProperty(propName);
            LOG.info("OldValue = " + propName + " = '" + prop.getValue() + "' type = '" + prop.getType() + "'", new Object[0]);
            Object wrongProp = wrongPropertyMap.get(propName);
            try {
                Object setProperty = !wrongPropertyMap.containsKey(propName) ? dataProvider.getConnectorAttribute(propName) : wrongProp;
                LOG.info("Setting property ''{0}'' to value ''{1}''", new Object[]{propName, setProperty == null ? "null" : setProperty.toString()});
                properties.setPropertyValue(propName, setProperty);
            }
            catch (ObjectNotFoundException ex) {}
        }
        LOG.info("--------------- NEW PROPERTIES -------------------", new Object[0]);
        for (String propName : propertyNames) {
            prop = properties.getProperty(propName);
            LOG.info(propName + " = '" + prop.getValue() + "' type = '" + prop.getType() + "'", new Object[0]);
        }
        ConnectorFacade connector = ConnectorFacadeFactory.getInstance().newInstance(apiConfig);
        junit.framework.Assert.assertNotNull((String)"Unable to create connector", (Object)connector);
        return connector;
    }

    public static ConnectorFacade createConnectorFacade(DataProvider dataProvider) {
        ConnectorFacade connector = ConnectorHelper.createConnectorFacade(dataProvider, null);
        if (connector.getSupportedOperations().contains(TestApiOp.class)) {
            connector.test();
        } else {
            LOG.warn("Unable to test validity of connection.  Connector does not suport the Test API. Trying at least to test validity of configuration.", new Object[0]);
            connector.validate();
        }
        return connector;
    }

    static ConnectorObject findObjectByName(ConnectorFacade connectorFacade, ObjectClass objClass, String name, OperationOptions opOptions) {
        Filter nameFilter = FilterBuilder.equalTo((Attribute)new Name(name));
        final ArrayList foundObjects = new ArrayList();
        connectorFacade.search(objClass, nameFilter, new ResultsHandler(){

            public boolean handle(ConnectorObject obj) {
                foundObjects.add(obj);
                return false;
            }
        }, opOptions);
        if (foundObjects.size() <= 0) {
            return null;
        }
        junit.framework.Assert.assertEquals((String)"Name should be unique, but found multiple objects with the same name", (int)1, (int)foundObjects.size());
        return (ConnectorObject)foundObjects.get(0);
    }

    public static List<ConnectorObject> search(ConnectorFacade connectorFacade, ObjectClass objClass, Filter filter, OperationOptions opOptions) {
        final ArrayList<ConnectorObject> foundObjects = new ArrayList<ConnectorObject>();
        connectorFacade.search(objClass, filter, new ResultsHandler(){

            public boolean handle(ConnectorObject obj) {
                foundObjects.add(obj);
                return true;
            }
        }, opOptions);
        return foundObjects;
    }

    public static Map<Uid, ConnectorObject> search2Map(ConnectorFacade connectorFacade, ObjectClass objClass, Filter filter, OperationOptions opOptions) {
        final Hashtable<Uid, ConnectorObject> foundObjects = new Hashtable<Uid, ConnectorObject>();
        connectorFacade.search(objClass, filter, new ResultsHandler(){

            public boolean handle(ConnectorObject obj) {
                foundObjects.put(obj.getUid(), obj);
                return true;
            }
        }, opOptions);
        return foundObjects;
    }

    public static List<SyncDelta> sync(ConnectorFacade connectorFacade, ObjectClass objClass, SyncToken token, OperationOptions opOptions) {
        final ArrayList<SyncDelta> returnedDeltas = new ArrayList<SyncDelta>();
        connectorFacade.sync(objClass, token, new SyncResultsHandler(){

            public boolean handle(SyncDelta delta) {
                returnedDeltas.add(delta);
                return true;
            }
        }, opOptions);
        return returnedDeltas;
    }

    public static boolean deleteObject(ConnectorFacade connectorFacade, ObjectClass objClass, Uid uid, boolean failOnError, OperationOptions opOptions) {
        boolean deleted;
        block4: {
            deleted = false;
            junit.framework.Assert.assertFalse((String)"Connector helper deleteObject method received a null Uid, when it was told it should not fail", (failOnError && uid == null ? 1 : 0) != 0);
            if (uid == null) {
                return deleted;
            }
            try {
                connectorFacade.delete(objClass, uid, opOptions);
            }
            catch (Throwable t) {
                if (!failOnError) break block4;
                junit.framework.Assert.fail((String)"Connector helper deleteObject method caught an exception, when it was told it should not fail");
            }
        }
        if (failOnError) {
            ConnectorObject obj = connectorFacade.getObject(objClass, uid, opOptions);
            junit.framework.Assert.assertNull((String)"The deleted object was found. It should be no longer on the resource.", (Object)obj);
            deleted = true;
        }
        return deleted;
    }

    public static boolean checkObject(ObjectClassInfo objectClassInfo, ConnectorObject connectorObj, Set<Attribute> requestedAttributes) {
        return ConnectorHelper.checkObject(objectClassInfo, connectorObj, requestedAttributes, true);
    }

    public static boolean checkObject(ObjectClassInfo objectClassInfo, ConnectorObject connectorObj, Set<Attribute> requestedAttributes, boolean checkNotReturnedByDefault) {
        boolean success = true;
        for (Attribute attribute : requestedAttributes) {
            if (!ConnectorHelper.isReadable(objectClassInfo, attribute) || !checkNotReturnedByDefault && !ConnectorHelper.isReturnedByDefault(objectClassInfo, attribute)) continue;
            Attribute createdAttribute = connectorObj.getAttributeByName(attribute.getName());
            if (createdAttribute == null) {
                junit.framework.Assert.fail((String)String.format("Attribute '%s' is missing.", attribute.getName()));
            }
            List fetchedValue = createdAttribute.getValue();
            List requestedValue = attribute.getValue();
            String msg = String.format("Attribute '%s' was not properly created. Requested values: %s Fetched values: %s", attribute.getName(), requestedValue, fetchedValue);
            junit.framework.Assert.assertTrue((String)msg, (boolean)ConnectorHelper.checkValue(fetchedValue, requestedValue));
        }
        return success;
    }

    static <E> boolean checkValue(List<E> fetchedValues, List<E> expectedValues) {
        Iterator<E> e = expectedValues.iterator();
        List fetchedValuesClone = CollectionUtil.newList(fetchedValues);
        while (e.hasNext()) {
            E expected = e.next();
            boolean found = false;
            Iterator f = fetchedValuesClone.iterator();
            while (f.hasNext()) {
                if (!CollectionUtil.equals(expected, f.next())) continue;
                f.remove();
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static void checkSyncDelta(ObjectClassInfo ocInfo, SyncDelta delta, Uid uid, Set<Attribute> attributes, SyncDeltaType deltaType, boolean checkNotReturnedByDefault) {
        String msg = "Sync returned wrong Uid, expected: %s, returned: %s.";
        Assert.assertEquals((String)String.format(msg, uid, delta.getUid()), (Object)delta.getUid(), (Object)uid);
        if (deltaType != SyncDeltaType.DELETE) {
            ConnectorHelper.checkObject(ocInfo, delta.getObject(), attributes, checkNotReturnedByDefault);
        }
        msg = "Sync delta type should be %s, but returned: %s.";
        Assert.assertTrue((String)String.format(msg, deltaType, delta.getDeltaType()), (delta.getDeltaType() == deltaType ? 1 : 0) != 0);
    }

    public static boolean isReadable(ObjectClassInfo objectClassInfo, Attribute attribute) {
        boolean isReadable = false;
        Set attributeInfoSet = objectClassInfo.getAttributeInfo();
        for (AttributeInfo attributeInfo : attributeInfoSet) {
            if (!attributeInfo.is(attribute.getName())) continue;
            isReadable = attributeInfo.isReadable();
            break;
        }
        return isReadable;
    }

    public static boolean isRequired(ObjectClassInfo objectClassInfo, Attribute attribute) {
        boolean isRequired = false;
        Set attributeInfoSet = objectClassInfo.getAttributeInfo();
        for (AttributeInfo attributeInfo : attributeInfoSet) {
            if (!attributeInfo.is(attribute.getName())) continue;
            isRequired = attributeInfo.isRequired();
            break;
        }
        return isRequired;
    }

    public static boolean isCreateable(ObjectClassInfo objectClassInfo, Attribute attribute) {
        boolean isCreateable = false;
        Set attributeInfoSet = objectClassInfo.getAttributeInfo();
        for (AttributeInfo attributeInfo : attributeInfoSet) {
            if (!attributeInfo.is(attribute.getName())) continue;
            isCreateable = attributeInfo.isCreateable();
            break;
        }
        return isCreateable;
    }

    public static boolean isUpdateable(ObjectClassInfo objectClassInfo, Attribute attribute) {
        boolean isUpdateable = false;
        Set attributeInfoSet = objectClassInfo.getAttributeInfo();
        for (AttributeInfo attributeInfo : attributeInfoSet) {
            if (!attributeInfo.is(attribute.getName())) continue;
            isUpdateable = attributeInfo.isUpdateable();
            break;
        }
        return isUpdateable;
    }

    public static boolean isReturnedByDefault(ObjectClassInfo objectClassInfo, Attribute attribute) {
        boolean isReturnedByDefault = false;
        Set attributeInfoSet = objectClassInfo.getAttributeInfo();
        for (AttributeInfo attributeInfo : attributeInfoSet) {
            if (!attributeInfo.is(attribute.getName())) continue;
            isReturnedByDefault = attributeInfo.isReturnedByDefault();
            break;
        }
        return isReturnedByDefault;
    }

    public static boolean isMultiValue(ObjectClassInfo objectClassInfo, String attribute) {
        boolean isMultiValue = false;
        Set attributeInfoSet = objectClassInfo.getAttributeInfo();
        for (AttributeInfo attributeInfo : attributeInfoSet) {
            if (!attributeInfo.is(attribute)) continue;
            isMultiValue = attributeInfo.isMultiValued();
            break;
        }
        return isMultiValue;
    }

    public static boolean isCRU(ObjectClassInfo oinfo, String attribute) {
        boolean cru = false;
        for (AttributeInfo ainfo : oinfo.getAttributeInfo()) {
            if (!ainfo.is(attribute)) continue;
            if (!ainfo.isCreateable() || !ainfo.isUpdateable() || !ainfo.isReadable()) break;
            cru = true;
            break;
        }
        return cru;
    }

    public static boolean isReadable(ObjectClassInfo oinfo, String attribute) {
        for (AttributeInfo ainfo : oinfo.getAttributeInfo()) {
            if (!ainfo.is(attribute)) continue;
            return ainfo.isReadable();
        }
        return false;
    }

    public static boolean isAttrSupported(ObjectClassInfo oinfo, String attribute) {
        for (AttributeInfo ainfo : oinfo.getAttributeInfo()) {
            if (!ainfo.is(attribute)) continue;
            return true;
        }
        return false;
    }

    public static Set<Attribute> getUpdateableAttributes(DataProvider dataProvider, ObjectClassInfo objectClassInfo, String testName, String qualifier, int sequenceNumber, boolean checkRequired, boolean onlyMultiValue) {
        return ConnectorHelper.getAttributes(dataProvider, objectClassInfo, testName, qualifier, sequenceNumber, checkRequired, onlyMultiValue, false, true);
    }

    public static Set<Attribute> getCreateableAttributes(DataProvider dataProvider, ObjectClassInfo objectClassInfo, String testName, int sequenceNumber, boolean checkRequired, boolean onlyMultiValue) {
        return ConnectorHelper.getAttributes(dataProvider, objectClassInfo, testName, "", sequenceNumber, checkRequired, onlyMultiValue, true, false);
    }

    public static Set<String> getReadableAttributesNames(ObjectClassInfo ocInfo) {
        HashSet<String> readableAttrs = new HashSet<String>();
        for (AttributeInfo ainfo : ocInfo.getAttributeInfo()) {
            if (!ainfo.isReadable()) continue;
            readableAttrs.add(ainfo.getName());
        }
        return readableAttrs;
    }

    public static Set<Attribute> getAttributes(DataProvider dataProvider, ObjectClassInfo objectClassInfo, String testName, String qualifier, int sequenceNumber, boolean checkRequired, boolean onlyMultiValue, boolean onlyCreateable, boolean onlyUpdateable) throws ObjectNotFoundException {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        for (AttributeInfo attributeInfo : objectClassInfo.getAttributeInfo()) {
            if (onlyMultiValue && !attributeInfo.isMultiValued() || onlyCreateable && !attributeInfo.isCreateable() || onlyUpdateable && !attributeInfo.isUpdateable()) continue;
            String attributeName = attributeInfo.getName();
            try {
                Object attributeValue;
                if (attributeInfo.is(Uid.NAME)) continue;
                String dataName = attributeName;
                if (qualifier.length() > 0) {
                    dataName = qualifier + "." + dataName;
                }
                if ((attributeValue = ConnectorHelper.get(dataProvider, testName, attributeInfo.getType(), dataName, objectClassInfo.getType(), sequenceNumber, attributeInfo.isMultiValued())) instanceof Collection) {
                    attributes.add(AttributeBuilder.build((String)attributeName, (Collection)((Collection)attributeValue)));
                    continue;
                }
                attributes.add(AttributeBuilder.build((String)attributeName, (Object[])new Object[]{attributeValue}));
            }
            catch (ObjectNotFoundException ex) {
                if (checkRequired && attributeInfo.isRequired()) {
                    LOG.error((Throwable)ex, "Could not find a value of REQUIRED attribute type ''{0}'' for ''{1}''", new Object[]{attributeInfo.getType(), attributeName});
                    throw ex;
                }
                LOG.warn("Could not find a value of type ''{0}'' for ''{1}''", new Object[]{attributeInfo.getType(), attributeName});
            }
        }
        return attributes;
    }

    public static Uid createObject(ConnectorFacade connectorFacade, DataProvider dataProvider, ObjectClassInfo objectClassInfo, String testName, String qualifier, int sequenceNumber, OperationOptions opOptions) throws ObjectNotFoundException {
        Set<Attribute> attributes = ConnectorHelper.getAttributes(dataProvider, objectClassInfo, testName, qualifier, sequenceNumber, true, false, true, false);
        return connectorFacade.create(ConnectorHelper.getObjectClassFromObjectClassInfo(objectClassInfo), attributes, opOptions);
    }

    public static Uid createObject(ConnectorFacade connectorFacade, DataProvider dataProvider, ObjectClassInfo objectClassInfo, String testName, int sequenceNumber, OperationOptions opOptions) throws ObjectNotFoundException {
        Set<Attribute> attributes = ConnectorHelper.getCreateableAttributes(dataProvider, objectClassInfo, testName, sequenceNumber, true, false);
        return connectorFacade.create(ConnectorHelper.getObjectClassFromObjectClassInfo(objectClassInfo), attributes, opOptions);
    }

    public static boolean operationSupported(ConnectorFacade connectorFacade, ObjectClass oClass, Class<? extends APIOperation> operation) {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(operation);
        return ConnectorHelper.operationsSupported(connectorFacade, oClass, s);
    }

    public static boolean operationSupported(ConnectorFacade connectorFacade, ObjectClass oClass, Class<? extends APIOperation> operation1, Class<? extends APIOperation> operation2) {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(operation1);
        s.add(operation2);
        return ConnectorHelper.operationsSupported(connectorFacade, oClass, s);
    }

    public static boolean operationsSupported(ConnectorFacade connectorFacade, ObjectClass oClass, Set<Class<? extends APIOperation>> operations) {
        Boolean bool;
        ArrayList<Boolean> opsSupported = new ArrayList<Boolean>();
        Schema schema = connectorFacade.schema();
        junit.framework.Assert.assertNotNull((String)"Connector did not return a schema", (Object)schema);
        for (Class<? extends APIOperation> op : operations) {
            Set ocInfoSet = schema.getSupportedObjectClassesByOperation(op);
            boolean currentOpSupported = false;
            for (ObjectClassInfo ocInfo : ocInfoSet) {
                if (!ConnectorHelper.getObjectClassFromObjectClassInfo(ocInfo).equals((Object)oClass)) continue;
                currentOpSupported = true;
                break;
            }
            opsSupported.add(currentOpSupported);
        }
        boolean result = true;
        Iterator i$ = opsSupported.iterator();
        while (i$.hasNext() && (result &= (bool = (Boolean)i$.next()).booleanValue())) {
        }
        return result;
    }

    public static boolean operationSupported(ConnectorFacade connectorFacade, Class<? extends APIOperation> operation) {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(operation);
        return ConnectorHelper.operationsSupported(connectorFacade, s);
    }

    public static boolean operationSupported(ConnectorFacade connectorFacade, Class<? extends APIOperation> operations1, Class<? extends APIOperation> operations2) {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(operations1);
        s.add(operations2);
        return ConnectorHelper.operationsSupported(connectorFacade, s);
    }

    public static boolean operationsSupported(ConnectorFacade connectorFacade, Set<Class<? extends APIOperation>> operations) {
        boolean opSupported = false;
        Schema schema = connectorFacade.schema();
        junit.framework.Assert.assertNotNull((String)"Connector did not return a schema", (Object)schema);
        Set objectClassInfoSet = schema.getObjectClassInfo();
        for (ObjectClassInfo objectClassInfo : objectClassInfoSet) {
            if (!ConnectorHelper.operationsSupported(connectorFacade, ConnectorHelper.getObjectClassFromObjectClassInfo(objectClassInfo), operations)) continue;
            opSupported = true;
            break;
        }
        return opSupported;
    }

    public static ConnectorInfoManager getInfoManager(DataProvider dataProvider) {
        ConnectorInfoManagerFactory fact = ConnectorInfoManagerFactory.getInstance();
        ConnectorInfoManager manager = null;
        String useConnectorServer = System.getProperty("useConnectorServer");
        if ("true".equals(useConnectorServer)) {
            LOG.info("TESTING CONNECTOR ON CONNECTOR SERVER.", new Object[0]);
            manager = ConnectorHelper.getRemoteManager(dataProvider, fact);
        } else {
            LOG.info("TESTING LOCAL CONNECTOR.", new Object[0]);
            manager = ConnectorHelper.getLocalManager(dataProvider, fact);
        }
        Assert.assertNotNull((String)"Manager wasn't created - check *MANDATORY* properties.", (Object)manager);
        return manager;
    }

    private static ConnectorInfoManager getLocalManager(DataProvider dataProvider, ConnectorInfoManagerFactory fact) {
        ConnectorInfoManager manager = null;
        File bundleJar = new File(((String)dataProvider.getTestSuiteAttribute("bundleJar")).trim());
        junit.framework.Assert.assertTrue((String)("BundleJar does not exist: " + bundleJar.getAbsolutePath()), (boolean)bundleJar.isFile());
        try {
            manager = fact.getLocalManager(new URL[]{bundleJar.toURI().toURL()});
        }
        catch (MalformedURLException ex) {
            throw ContractException.wrap(ex);
        }
        return manager;
    }

    private static ConnectorInfoManager getRemoteManager(DataProvider dataProvider, ConnectorInfoManagerFactory fact) {
        ConnectorInfoManager manager = null;
        String host = null;
        Integer port = null;
        String key = null;
        try {
            host = (String)dataProvider.getTestSuiteAttribute("serverHost");
        }
        catch (ObjectNotFoundException ex) {
            // empty catch block
        }
        try {
            port = (Integer)dataProvider.getTestSuiteAttribute("serverPort");
        }
        catch (ObjectNotFoundException ex) {
            // empty catch block
        }
        try {
            key = (String)dataProvider.getTestSuiteAttribute("serverKey");
        }
        catch (ObjectNotFoundException ex) {
            // empty catch block
        }
        if (StringUtil.isNotBlank((String)System.getProperty("serverHost"))) {
            host = System.getProperty("serverHost");
        }
        if (StringUtil.isNotBlank((String)System.getProperty("serverPort"))) {
            port = Integer.parseInt(System.getProperty("serverPort"));
        }
        if (StringUtil.isNotBlank((String)System.getProperty("serverKey"))) {
            key = System.getProperty("serverKey");
        }
        junit.framework.Assert.assertTrue((String)"Connector server host not set.", (boolean)StringUtil.isNotBlank((String)host));
        junit.framework.Assert.assertNotNull((String)"Connector server port not set.", (Object)port);
        junit.framework.Assert.assertTrue((String)"Connector server key not set.", (boolean)StringUtil.isNotBlank((String)key));
        try {
            manager = fact.getRemoteManager(new RemoteFrameworkConnectionInfo(host, port.intValue(), new GuardedString(key.toCharArray())));
        }
        catch (Throwable t) {
            throw new ContractException("Cannot create remote manager. Check connector server settings.", t);
        }
        return manager;
    }

    public static APIConfiguration getDefaultConfigurationProperties(DataProvider dataProvider, ConnectorInfoManager manager) throws ObjectNotFoundException {
        String bundleName = (String)dataProvider.getTestSuiteAttribute("bundleName");
        String bundleVersion = (String)dataProvider.getTestSuiteAttribute("bundleVersion");
        String connectorName = (String)dataProvider.getTestSuiteAttribute("connectorName");
        ConnectorKey key = new ConnectorKey(bundleName, bundleVersion, connectorName);
        ConnectorInfo info = manager.findConnectorInfo(key);
        String MSG = "Connector info wasn't found. Check values of bundleName, bundleVersion and connectorName properties.\nbundleName:%s\nbundleVersion:%s\nconnectorName:%s";
        junit.framework.Assert.assertNotNull((String)String.format("Connector info wasn't found. Check values of bundleName, bundleVersion and connectorName properties.\nbundleName:%s\nbundleVersion:%s\nconnectorName:%s", bundleName, bundleVersion, connectorName), (Object)info);
        APIConfiguration apiConfig = info.createDefaultAPIConfiguration();
        return apiConfig;
    }

    private static String formatDataName(String objectClassName, String name) {
        StringBuilder sbPath = new StringBuilder(objectClassName);
        sbPath.append(".");
        sbPath.append(name);
        return sbPath.toString();
    }

    public static String getString(DataProvider dataProvider, String componentName, String name, String objectClassName) throws ObjectNotFoundException {
        return dataProvider.getString(ConnectorHelper.formatDataName(objectClassName, name), componentName);
    }

    public static Object get(DataProvider dataProvider, String componentName, Class<?> dataTypeName, String name, String objectClassName, int sequenceNumber, boolean isMultivalue) throws ObjectNotFoundException {
        return dataProvider.get(dataTypeName, ConnectorHelper.formatDataName(objectClassName, name), componentName, sequenceNumber, isMultivalue);
    }

    public static Object get(DataProvider dataProvider, String componentName, Class<?> dataTypeName, String name, String qualifier, String objectClassName, int sequenceNumber, boolean isMultivalue) throws ObjectNotFoundException {
        return dataProvider.get(dataTypeName, ConnectorHelper.formatDataName(objectClassName, ConnectorHelper.formatDataName(qualifier, name)), componentName, sequenceNumber, isMultivalue);
    }

    public static ObjectClass getObjectClassFromObjectClassInfo(ObjectClassInfo objectClassInfo) {
        return new ObjectClass(objectClassInfo.getType());
    }
}

