/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.HashSet;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ObjectClassRunner;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CreateApiOpTests
extends ObjectClassRunner {
    private static final Log LOG = Log.getLog(CreateApiOpTests.class);
    private static final String TEST_NAME = "Create";
    private static final String NON_EXISTING_PROP_NAME = "unsupportedAttributeName";

    public CreateApiOpTests(ObjectClass oclass) {
        super(oclass);
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> requiredOps = new HashSet<Class<? extends APIOperation>>();
        requiredOps.add(CreateApiOp.class);
        requiredOps.add(GetApiOp.class);
        return requiredOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void testRun() {
        Uid uid = null;
        try {
            Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(CreateApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, true, false);
            uid = this.getConnectorFacade().create(this.getObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
            ConnectorObject obj = this.getConnectorFacade().getObject(this.getObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
            Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)obj);
            ConnectorHelper.checkObject(this.getObjectClassInfo(), obj, attrs);
            if (uid == null) return;
        }
        catch (Throwable throwable) {
            if (uid == null) throw throwable;
            this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
            throw throwable;
        }
        this.getConnectorFacade().delete(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(DeleteApiOp.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateFailUnsupportedAttribute() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) {
            HashSet<Attribute> attrs = new HashSet<Attribute>();
            String unsupportedAttribute = null;
            try {
                unsupportedAttribute = (String)CreateApiOpTests.getDataProvider().getTestSuiteAttribute(NON_EXISTING_PROP_NAME, TEST_NAME);
            }
            catch (ObjectNotFoundException ex) {
                unsupportedAttribute = "nonExistingAndUnlikelyAttrName";
            }
            attrs.add(AttributeBuilder.build((String)unsupportedAttribute));
            Uid uid = null;
            try {
                uid = this.getConnectorFacade().create(this.getObjectClass(), attrs, null);
                Assert.fail((String)"'testCreateFailUnsupportedAttribute': NONEXISTING attribute accepted without throwing a RuntimeException.");
            }
            catch (RuntimeException ex) {
            }
            finally {
                if (uid != null) {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                }
            }
        } else {
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testCreateFailUnsupportedAttribute'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testCreateWithSameAttributes() {
        block10: {
            block11: {
                Uid uid2;
                block9: {
                    if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) break block11;
                    Uid uid1 = null;
                    uid2 = null;
                    try {
                        Set<Attribute> attrs = ConnectorHelper.getCreateableAttributes(CreateApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 1, true, false);
                        uid1 = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
                        ConnectorObject obj1 = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid1, this.getOperationOptionsByOp(GetApiOp.class));
                        Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)obj1);
                        ConnectorHelper.checkObject(this.getObjectClassInfo(), obj1, attrs);
                        uid2 = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs, this.getOperationOptionsByOp(CreateApiOp.class));
                        Assert.assertFalse((String)"Create returned the same Uid as by previous create.", (boolean)uid1.equals((Object)uid2));
                        ConnectorObject obj2 = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid2, this.getOperationOptionsByOp(GetApiOp.class));
                        Assert.assertNotNull((String)"Unable to retrieve newly created object", (Object)obj2);
                        ConnectorHelper.checkObject(this.getObjectClassInfo(), obj2, attrs);
                        if (uid1 == null) break block9;
                    }
                    catch (RuntimeException runtimeException) {
                        if (uid1 != null) {
                            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid1, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                        }
                        if (uid2 != null) {
                            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid2, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                        }
                        break block10;
                        catch (Throwable throwable) {
                            if (uid1 != null) {
                                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid1, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                            }
                            if (uid2 != null) {
                                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid2, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                            }
                            throw throwable;
                        }
                    }
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid1, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                }
                if (uid2 != null) {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid2, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                }
                break block10;
            }
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testCreateWithSameAttributes'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    @Override
    public String getTestName() {
        return TEST_NAME;
    }
}

