/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ContractTestBase;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.ScriptOnResourceApiOp;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.ScriptContext;
import org.junit.Assert;
import org.junit.Test;

public class ScriptOnResourceApiOpTests
extends ContractTestBase {
    private static final Log LOG = Log.getLog(ScriptOnResourceApiOpTests.class);
    private static final String TEST_NAME = "ScriptOnResource";
    private static final String LANGUAGE_PROP_PREFIX = "language";
    private static final String SCRIPT_PROP_PREFIX = "script";
    private static final String ARGUMENTS_PROP_PREFIX = "arguments";
    private static final String RESULT_PROP_PREFIX = "result";

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(ScriptOnResourceApiOp.class);
        return s;
    }

    @Test
    public void testRunScript() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getAPIOperations())) {
            try {
                String language = (String)ScriptOnResourceApiOpTests.getDataProvider().getTestSuiteAttribute(LANGUAGE_PROP_PREFIX, TEST_NAME);
                String script = (String)ScriptOnResourceApiOpTests.getDataProvider().getTestSuiteAttribute(SCRIPT_PROP_PREFIX, TEST_NAME);
                Map arguments = (Map)ScriptOnResourceApiOpTests.getDataProvider().getTestSuiteAttribute(ARGUMENTS_PROP_PREFIX, TEST_NAME);
                Object expResult = ScriptOnResourceApiOpTests.getDataProvider().getTestSuiteAttribute(RESULT_PROP_PREFIX, TEST_NAME);
                Object result = this.getConnectorFacade().runScriptOnResource(new ScriptContext(language, script, arguments), this.getOperationOptionsByOp(ScriptOnResourceApiOp.class));
                String MSG = "Script result was unexpected, expected: '%s', returned: '%s'.";
                Assert.assertEquals((String)String.format("Script result was unexpected, expected: '%s', returned: '%s'.", expResult, result), (Object)expResult, (Object)result);
            }
            catch (ObjectNotFoundException ex) {
                LOG.info("Test properties not set, skipping the test ScriptOnResource", new Object[0]);
            }
        } else {
            LOG.info("---------------------------------", new Object[0]);
            LOG.info("Skipping test ''testRunScript''.", new Object[0]);
            LOG.info("---------------------------------", new Object[0]);
        }
    }

    @Test
    public void testRunScriptFailUnknownLanguage() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getAPIOperations())) {
            try {
                this.getConnectorFacade().runScriptOnResource(new ScriptContext("NONEXISTING LANGUAGE", SCRIPT_PROP_PREFIX, new HashMap()), null);
                Assert.fail((String)"Script language is not supported, should throw an exception.");
            }
            catch (RuntimeException runtimeException) {}
        } else {
            LOG.info("----------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testRunScriptFailUnknownLanguage''.", new Object[0]);
            LOG.info("----------------------------------------------------", new Object[0]);
        }
    }

    @Test
    public void testRunScriptFailEmptyScriptText() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getAPIOperations())) {
            try {
                this.getConnectorFacade().runScriptOnResource(new ScriptContext("LANGUAGE", "", new HashMap()), null);
                Assert.fail((String)"Script text is empty and script language is not probably supported, should throw an exception.");
            }
            catch (RuntimeException runtimeException) {}
        } else {
            LOG.info("----------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testRunScriptFailEmptyScriptText''.", new Object[0]);
            LOG.info("----------------------------------------------------", new Object[0]);
        }
    }

    @Override
    public OperationOptions getOperationOptionsByOp(Class<? extends APIOperation> clazz) {
        if (clazz.equals(ScriptOnResourceApiOp.class)) {
            GuardedString password;
            OperationOptionsBuilder builder = new OperationOptionsBuilder();
            String user = (String)this.getProperty("RUN_AS_USER");
            if (user != null) {
                LOG.info("Using OperationOptions: ''{0}'' value: ''{1}''.", new Object[]{"RUN_AS_USER", user});
                builder.setRunAsUser(user);
            }
            if ((password = (GuardedString)this.getProperty("RUN_WITH_PASSWORD")) != null) {
                LOG.info("Using OperationOptions: ''{0}'' value: ''{1}''.", new Object[]{"RUN_WITH_PASSWORD", password});
                builder.setRunWithPassword(password);
            }
            return builder.build();
        }
        return super.getOperationOptionsByOp(clazz);
    }

    private Object getProperty(String name) {
        Object value = null;
        try {
            value = ScriptOnResourceApiOpTests.getDataProvider().getTestSuiteAttribute(name, TEST_NAME);
            LOG.info("Property ''{0}'' value ''{1}''.", new Object[]{name, value});
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return value;
    }
}

