/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.contract.test;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.contract.exceptions.ObjectNotFoundException;
import org.identityconnectors.contract.test.ConnectorHelper;
import org.identityconnectors.contract.test.ObjectClassRunner;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UpdateApiOpTests
extends ObjectClassRunner {
    private static final Log LOG = Log.getLog(UpdateApiOpTests.class);
    protected static final String MODIFIED = "modified";
    private static final String ADDED = "added";
    private static final String TEST_NAME = "Update";
    private static final String NON_EXISTING_PROP_NAME = "unsupportedAttributeName";

    public UpdateApiOpTests(ObjectClass objectClass) {
        super(objectClass);
    }

    @Override
    public Set<Class<? extends APIOperation>> getAPIOperations() {
        HashSet<Class<? extends APIOperation>> s = new HashSet<Class<? extends APIOperation>>();
        s.add(UpdateApiOp.class);
        s.add(CreateApiOp.class);
        s.add(GetApiOp.class);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRun() {
        ConnectorObject obj = null;
        Uid uid = null;
        try {
            uid = ConnectorHelper.createObject(this.getConnectorFacade(), UpdateApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, this.getOperationOptionsByOp(CreateApiOp.class));
            Assert.assertNotNull((String)"Create returned null Uid.", (Object)uid);
            obj = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
            Assert.assertNotNull((String)"Cannot retrieve created object.", (Object)obj);
            Set<Attribute> replaceAttributes = ConnectorHelper.getUpdateableAttributes(UpdateApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), MODIFIED, 0, false, false);
            if (replaceAttributes.size() > 0 || !this.isObjectClassSupported()) {
                replaceAttributes.add((Attribute)uid);
                Assert.assertTrue((String)"no update attributes were found", (replaceAttributes.size() > 0 ? 1 : 0) != 0);
                Uid newUid = this.getConnectorFacade().update(this.getObjectClass(), uid, AttributeUtil.filterUid(replaceAttributes), this.getOperationOptionsByOp(UpdateApiOp.class));
                if (!newUid.equals((Object)uid)) {
                    replaceAttributes.remove(uid);
                    replaceAttributes.add((Attribute)newUid);
                    uid = newUid;
                }
            }
            obj = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
            Assert.assertNotNull((String)"Cannot retrieve updated object.", (Object)obj);
            ConnectorHelper.checkObject(this.getObjectClassInfo(), obj, replaceAttributes);
            Set<Attribute> addDelAttrs = ConnectorHelper.getUpdateableAttributes(UpdateApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), ADDED, 0, false, true);
            if (addDelAttrs.size() > 0) {
                addDelAttrs.add((Attribute)uid);
                Uid newUid = this.getConnectorFacade().addAttributeValues(this.getObjectClass(), uid, AttributeUtil.filterUid(addDelAttrs), this.getOperationOptionsByOp(UpdateApiOp.class));
                if (!newUid.equals((Object)uid)) {
                    replaceAttributes.remove(uid);
                    addDelAttrs.remove(uid);
                    replaceAttributes.add((Attribute)newUid);
                    addDelAttrs.add((Attribute)newUid);
                    uid = newUid;
                }
                obj = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
                Assert.assertNotNull((String)"Cannot retrieve updated object.", (Object)obj);
                addDelAttrs.remove(uid);
                ConnectorHelper.checkObject(this.getObjectClassInfo(), obj, UpdateApiOpTests.mergeAttributeSets(addDelAttrs, replaceAttributes));
                addDelAttrs.add((Attribute)uid);
                newUid = this.getConnectorFacade().removeAttributeValues(this.getObjectClass(), uid, AttributeUtil.filterUid(addDelAttrs), this.getOperationOptionsByOp(UpdateApiOp.class));
                if (!newUid.equals((Object)uid)) {
                    replaceAttributes.remove(uid);
                    addDelAttrs.remove(uid);
                    replaceAttributes.add((Attribute)newUid);
                    addDelAttrs.add((Attribute)newUid);
                    uid = newUid;
                }
                obj = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
                Assert.assertNotNull((String)"Cannot retrieve updated object.", (Object)obj);
                ConnectorHelper.checkObject(this.getObjectClassInfo(), obj, replaceAttributes);
            }
        }
        finally {
            if (uid != null) {
                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateToNull() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) {
            ConnectorObject obj = null;
            Uid uid = null;
            try {
                uid = ConnectorHelper.createObject(this.getConnectorFacade(), UpdateApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 2, this.getOperationOptionsByOp(CreateApiOp.class));
                Assert.assertNotNull((String)"Create returned null Uid.", (Object)uid);
                Collection<String> skippedAttributesForUpdateToNullValue = UpdateApiOpTests.getSkippedAttributesForUpdateToNullValue();
                for (AttributeInfo attInfo : this.getObjectClassInfo().getAttributeInfo()) {
                    if (!attInfo.isUpdateable() || attInfo.isRequired() || AttributeUtil.isSpecial((AttributeInfo)attInfo) || attInfo.getType().isPrimitive()) continue;
                    if (skippedAttributesForUpdateToNullValue.contains(attInfo.getName())) {
                        LOG.info("Attribute '{0}' was skipped in testUpdateToNull", new Object[]{attInfo.getName()});
                        continue;
                    }
                    HashSet<Attribute> nullAttributes = new HashSet<Attribute>();
                    Attribute attr = AttributeBuilder.build((String)attInfo.getName());
                    nullAttributes.add(attr);
                    try {
                        Uid newUid = this.getConnectorFacade().update(this.getObjectClass(), uid, nullAttributes, this.getOperationOptionsByOp(UpdateApiOp.class));
                        LOG.info("No exception was thrown, attributes should be either removed or their values set to null.", new Object[0]);
                        if (!uid.equals((Object)newUid)) {
                            uid = newUid;
                        }
                        obj = this.getConnectorFacade().getObject(this.getObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
                        Assert.assertNotNull((String)"Cannot retrieve updated object.", (Object)obj);
                        if (!ConnectorHelper.isReadable(this.getObjectClassInfo(), attr)) continue;
                        Attribute checkedAttribute = obj.getAttributeByName(attInfo.getName());
                        String MSG = "Attribute '%s' was neither removed nor its value set to null or empty list. Updated value is : '%s'";
                        Assert.assertTrue((String)String.format("Attribute '%s' was neither removed nor its value set to null or empty list. Updated value is : '%s'", attInfo.getName(), checkedAttribute != null ? checkedAttribute.getValue() : null), (checkedAttribute == null || checkedAttribute.equals((Object)attr) || checkedAttribute.getValue().isEmpty() ? 1 : 0) != 0);
                    }
                    catch (RuntimeException ex) {
                        Assert.assertFalse((String)String.format("Update of attribute '%s' to null thrown NullPointerException.", attInfo.getName()), (boolean)(ex instanceof NullPointerException));
                        LOG.info(String.format("RuntimeException was thrown when trying to update '%s' to null.", attInfo.getName()), new Object[0]);
                    }
                }
            }
            finally {
                if (uid != null) {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                }
            }
        } else {
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testUpdateToNull'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateToSameAttributes() {
        block11: {
            block10: {
                Uid uid2;
                block9: {
                    if (!ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) break block10;
                    Uid uid1 = null;
                    uid2 = null;
                    try {
                        Set<Attribute> attrs1 = ConnectorHelper.getCreateableAttributes(UpdateApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 1, true, false);
                        uid1 = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs1, null);
                        Assert.assertNotNull((String)"Create returned null uid.", (Object)uid1);
                        ConnectorObject obj1 = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid1, this.getOperationOptionsByOp(GetApiOp.class));
                        ConnectorHelper.checkObject(this.getObjectClassInfo(), obj1, attrs1);
                        Set<Attribute> attrs2 = ConnectorHelper.getCreateableAttributes(UpdateApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 2, true, false);
                        uid2 = this.getConnectorFacade().create(this.getSupportedObjectClass(), attrs2, null);
                        Assert.assertNotNull((String)"Create returned null uid.", (Object)uid2);
                        ConnectorObject obj2 = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid2, this.getOperationOptionsByOp(GetApiOp.class));
                        ConnectorHelper.checkObject(this.getObjectClassInfo(), obj2, attrs2);
                        HashSet<Object> replaceAttributes = new HashSet<Object>();
                        for (Attribute attr : attrs1) {
                            if (!ConnectorHelper.isUpdateable(this.getObjectClassInfo(), attr)) continue;
                            replaceAttributes.add(attr);
                        }
                        replaceAttributes.add(uid2);
                        try {
                            Uid newUid = this.getConnectorFacade().update(this.getSupportedObjectClass(), uid2, AttributeUtil.filterUid(replaceAttributes), this.getOperationOptionsByOp(UpdateApiOp.class));
                            if (!uid2.equals((Object)newUid)) {
                                uid2 = newUid;
                            }
                            Assert.assertFalse((String)"Update returned the same uid when tried to update to the same attributes as another object.", (boolean)uid1.equals((Object)uid2));
                        }
                        catch (RuntimeException ex) {
                            // empty catch block
                        }
                        if (uid1 == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (uid1 != null) {
                            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid1, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                        }
                        if (uid2 != null) {
                            ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid2, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                        }
                        throw throwable;
                    }
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid1, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                }
                if (uid2 != null) {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid2, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                }
                break block11;
            }
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
            LOG.info("Skipping test ''testUpdateToSameAttributes'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
            LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        }
    }

    @Override
    public String getTestName() {
        return TEST_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testUpdateFailUnsupportedAttribute() {
        if (ConnectorHelper.operationsSupported(this.getConnectorFacade(), this.getObjectClass(), this.getAPIOperations())) {
            Uid uid = null;
            try {
                uid = ConnectorHelper.createObject(this.getConnectorFacade(), UpdateApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), 0, this.getOperationOptionsByOp(CreateApiOp.class));
                Assert.assertNotNull((String)"Create returned null Uid.", (Object)uid);
                ConnectorObject obj = this.getConnectorFacade().getObject(this.getSupportedObjectClass(), uid, this.getOperationOptionsByOp(GetApiOp.class));
                Assert.assertNotNull((String)"Cannot retrieve created object.", (Object)obj);
                Set<Attribute> replaceAttributes = ConnectorHelper.getUpdateableAttributes(UpdateApiOpTests.getDataProvider(), this.getObjectClassInfo(), this.getTestName(), MODIFIED, 0, false, false);
                if (replaceAttributes.size() <= 0 && this.isObjectClassSupported()) return;
                replaceAttributes.add((Attribute)uid);
                String unsupportedAttribute = null;
                try {
                    unsupportedAttribute = (String)UpdateApiOpTests.getDataProvider().getTestSuiteAttribute(NON_EXISTING_PROP_NAME, TEST_NAME);
                }
                catch (ObjectNotFoundException ex) {
                    unsupportedAttribute = "nonExistingAndUnlikelyAttrName";
                }
                replaceAttributes.add(AttributeBuilder.build((String)unsupportedAttribute));
                Assert.assertTrue((String)"no update attributes were found", (replaceAttributes.size() > 0 ? 1 : 0) != 0);
                Uid uidNew = null;
                try {
                    uidNew = this.getConnectorFacade().update(this.getObjectClass(), uid, AttributeUtil.filterUid(replaceAttributes), null);
                    Assert.fail((String)"'testUpdateFailUnsupportedAttribute': NONEXISTING attribute accepted without throwing a RuntimeException.");
                    if (uidNew == null) return;
                }
                catch (RuntimeException ex) {
                    if (uidNew == null) return;
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uidNew, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                    return;
                    catch (Throwable throwable) {
                        if (uidNew == null) throw throwable;
                        ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uidNew, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                        throw throwable;
                    }
                }
                ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uidNew, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                return;
            }
            finally {
                if (uid != null) {
                    ConnectorHelper.deleteObject(this.getConnectorFacade(), this.getSupportedObjectClass(), uid, false, this.getOperationOptionsByOp(DeleteApiOp.class));
                }
            }
        }
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
        LOG.info("Skipping test ''testCreateFailUnsupportedAttribute'' for object class ''{0}''.", new Object[]{this.getObjectClass()});
        LOG.info("----------------------------------------------------------------------------------------", new Object[0]);
    }

    protected static Set<Attribute> mergeAttributeSets(Set<Attribute> attrSet1, Set<Attribute> attrSet2) {
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        HashMap<String, Attribute> attrMap2 = new HashMap<String, Attribute>();
        for (Attribute attr : attrSet2) {
            attrMap2.put(attr.getName(), attr);
        }
        for (Attribute attr1 : attrSet1) {
            Attribute attr2 = (Attribute)attrMap2.remove(attr1.getName());
            if (attr2 != null) {
                AttributeBuilder attrBuilder = new AttributeBuilder();
                attrBuilder.setName(attr1.getName());
                attrBuilder.addValue((Collection)attr1.getValue());
                attrBuilder.addValue((Collection)attr2.getValue());
                attrs.add(attrBuilder.build());
                continue;
            }
            attrs.add(attr1);
        }
        for (Attribute attr2 : attrMap2.values()) {
            attrs.add(attr2);
        }
        return attrs;
    }

    protected static Collection<String> getSkippedAttributesForUpdateToNullValue() {
        Object skippedAttributes = null;
        try {
            skippedAttributes = UpdateApiOpTests.getDataProvider().getTestSuiteAttribute("updateToNullValue.skippedAttributes", TEST_NAME);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        if (skippedAttributes == null) {
            return Collections.emptyList();
        }
        if (!(skippedAttributes instanceof Collection)) {
            throw new RuntimeException(MessageFormat.format("Testsuite Property '{0}' must be of type Collection , but was of type {1}", "testsuite.Update.updateToNullValue.skippedAttributes", skippedAttributes.getClass()));
        }
        return (Collection)skippedAttributes;
    }
}

