/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.testconnector;

import java.util.Set;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.testcommon.TstCommon;
import org.identityconnectors.testconnector.MyTstConnection;
import org.identityconnectors.testconnector.TstConnectorConfig;

@ConnectorClass(displayNameKey="TestConnector", configurationClass=TstConnectorConfig.class)
public class TstConnector
implements CreateOp,
PoolableConnector,
SchemaOp,
SearchOp<String>,
SyncOp {
    private static int _connectionCount = 0;
    private MyTstConnection _myConnection;
    private TstConnectorConfig _config;

    public static void checkClassLoader() {
        if (Thread.currentThread().getContextClassLoader() != TstConnector.class.getClassLoader()) {
            throw new IllegalStateException("Unexpected classloader");
        }
    }

    public TstConnector() {
        TstConnector.checkClassLoader();
    }

    public Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        TstConnector.checkClassLoader();
        Integer delay = (Integer)options.getOptions().get("delay");
        if (delay != null) {
            try {
                Thread.sleep(delay.intValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (options.getOptions().get("testPooling") != null) {
            return new Uid(String.valueOf(this._myConnection.getConnectionNumber()));
        }
        String version = TstCommon.getVersion();
        return new Uid(version);
    }

    public void init(Configuration cfg) {
        TstConnector.checkClassLoader();
        this._config = (TstConnectorConfig)cfg;
        if (this._config.getResetConnectionCount()) {
            _connectionCount = 0;
        }
        this._myConnection = new MyTstConnection(_connectionCount++);
    }

    public Configuration getConfiguration() {
        return this._config;
    }

    public void dispose() {
        TstConnector.checkClassLoader();
        if (this._myConnection != null) {
            this._myConnection.dispose();
            this._myConnection = null;
        }
    }

    public void checkAlive() {
        TstConnector.checkClassLoader();
        this._myConnection.test();
    }

    public String concat(String s1, String s2) {
        TstConnector.checkClassLoader();
        return s1 + s2;
    }

    public FilterTranslator<String> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        TstConnector.checkClassLoader();
        return new AbstractFilterTranslator<String>(){};
    }

    public void executeQuery(ObjectClass oclass, String query, ResultsHandler handler, OperationOptions options) {
        TstConnector.checkClassLoader();
        for (int i = 0; i < this._config.getNumResults(); ++i) {
            Integer delay = (Integer)options.getOptions().get("delay");
            if (delay != null) {
                try {
                    Thread.sleep(delay.intValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
            builder.setUid(Integer.toString(i));
            builder.setName(Integer.toString(i));
            builder.setObjectClass(oclass);
            for (int j = 0; j < 50; ++j) {
                builder.addAttribute("myattribute" + j, new Object[]{"myvaluevaluevalue" + j});
            }
            ConnectorObject rv = builder.build();
            if (!handler.handle(rv)) break;
        }
    }

    public void sync(ObjectClass objClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        TstConnector.checkClassLoader();
        for (int i = 0; i < this._config.getNumResults(); ++i) {
            ConnectorObjectBuilder obuilder = new ConnectorObjectBuilder();
            obuilder.setUid(Integer.toString(i));
            obuilder.setName(Integer.toString(i));
            obuilder.setObjectClass(objClass);
            SyncDeltaBuilder builder = new SyncDeltaBuilder();
            builder.setObject(obuilder.build());
            builder.setDeltaType(SyncDeltaType.CREATE_OR_UPDATE);
            builder.setToken(new SyncToken((Object)"mytoken"));
            SyncDelta rv = builder.build();
            if (!handler.handle(rv)) break;
        }
    }

    public SyncToken getLatestSyncToken(ObjectClass objClass) {
        TstConnector.checkClassLoader();
        return new SyncToken((Object)"mylatest");
    }

    public Schema schema() {
        TstConnector.checkClassLoader();
        SchemaBuilder builder = new SchemaBuilder(TstConnector.class);
        for (int i = 0; i < 2; ++i) {
            ObjectClassInfoBuilder classBuilder = new ObjectClassInfoBuilder();
            classBuilder.setType("class" + i);
            for (int j = 0; j < 200; ++j) {
                classBuilder.addAttributeInfo(AttributeInfoBuilder.build((String)("attributename" + j), String.class));
            }
            builder.defineObjectClass(classBuilder.build());
        }
        return builder.build();
    }
}

