/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.constretto.ConfigurationDefaultValueFactory;
import org.constretto.ConstrettoConfiguration;
import org.constretto.Property;
import org.constretto.annotation.Configuration;
import org.constretto.annotation.Configure;
import org.constretto.annotation.Tags;
import org.constretto.exception.ConstrettoConversionException;
import org.constretto.exception.ConstrettoException;
import org.constretto.exception.ConstrettoExpressionException;
import org.constretto.internal.converter.ValueConverterRegistry;
import org.constretto.model.ConfigurationNode;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConstrettoConfiguration
implements ConstrettoConfiguration {
    private static final String NULL_STRING = "![![Null]!]!";
    private static final String VARIABLE_PREFIX = "#{";
    private static final String VARIABLE_SUFFIX = "}";
    private List<String> currentTags;
    private final ConfigurationNode configuration;
    private LocalVariableTableParameterNameDiscoverer nameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private Set<WeakReference<Object>> configuredObjects = new HashSet<WeakReference<Object>>();

    public DefaultConstrettoConfiguration(ConfigurationNode configuration, List<String> currentTags) {
        this.configuration = configuration;
        this.currentTags = currentTags;
    }

    public <K> K evaluateTo(String expression, K defaultValue) {
        K value;
        if (!this.hasValue(expression)) {
            return defaultValue;
        }
        try {
            value = (K)this.processAndConvert(defaultValue.getClass(), expression);
        }
        catch (ConstrettoConversionException e) {
            value = null;
        }
        return null != value ? value : (K)defaultValue;
    }

    public <K> K evaluateTo(Class<K> targetClass, String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(targetClass, expression);
    }

    public String evaluateToString(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(String.class, expression);
    }

    public Boolean evaluateToBoolean(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Boolean.class, expression);
    }

    public Double evaluateToDouble(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Double.class, expression);
    }

    public Long evaluateToLong(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Long.class, expression);
    }

    public Float evaluateToFloat(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Float.class, expression);
    }

    public Integer evaluateToInt(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Integer.class, expression);
    }

    public Short evaluateToShort(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Short.class, expression);
    }

    public Byte evaluateToByte(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Byte.class, expression);
    }

    public <T> T as(Class<T> configurationClass) throws ConstrettoException {
        T objectToConfigure;
        try {
            objectToConfigure = configurationClass.newInstance();
        }
        catch (Exception e) {
            throw new ConstrettoException("Could not instansiate class of type: " + configurationClass.getName() + " when trying to inject it with configuration, It may be missing a default constructor", (Throwable)e);
        }
        this.injectConfiguration(objectToConfigure);
        return objectToConfigure;
    }

    public <T> T on(T objectToConfigure) throws ConstrettoException {
        this.injectConfiguration(objectToConfigure);
        return objectToConfigure;
    }

    public ConstrettoConfiguration at(String expression) throws ConstrettoException {
        ConfigurationNode currentConfigurationNode = this.findElementOrThrowException(expression);
        ConfigurationNode.createRootElementOf(currentConfigurationNode);
        return new DefaultConstrettoConfiguration(currentConfigurationNode, this.currentTags);
    }

    public ConstrettoConfiguration from(String expression) throws ConstrettoException {
        return this.at(expression);
    }

    public boolean hasValue(String expression) {
        ConfigurationNode node = this.findElementOrNull(expression);
        return null != node;
    }

    public void addTag(String ... newtags) {
        this.currentTags.addAll(Arrays.asList(newtags));
        this.reconfigure();
    }

    public void removeTag(String ... newTags) {
        for (String newTag : newTags) {
            this.currentTags.remove(newTag);
        }
        this.reconfigure();
    }

    public Iterator<Property> iterator() {
        ArrayList<Property> properties = new ArrayList<Property>();
        Map<String, String> map = this.asMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            properties.add(new Property(entry.getKey(), entry.getValue()));
        }
        return properties.iterator();
    }

    private Map<String, String> asMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.extractProperties(this.configuration, properties);
        return properties;
    }

    private void extractProperties(ConfigurationNode currentNode, Map<String, String> properties) {
        String value = this.evaluateTo(currentNode.getExpression(), NULL_STRING);
        if (!value.equals(NULL_STRING)) {
            properties.put(currentNode.getExpression(), value);
        }
        if (currentNode.hasChildren()) {
            for (ConfigurationNode child : currentNode.children()) {
                this.extractProperties(child, properties);
            }
        }
    }

    private void reconfigure() {
        WeakReference[] references;
        for (WeakReference reference : references = this.configuredObjects.toArray(new WeakReference[this.configuredObjects.size()])) {
            if (reference == null || reference.get() == null) continue;
            this.on(reference.get());
        }
    }

    private ConfigurationNode findElementOrThrowException(String expression) {
        List<ConfigurationNode> node = this.configuration.findAllBy(expression);
        ConfigurationNode resolvedNode = this.resolveMatch(node);
        if (resolvedNode == null) {
            throw new ConstrettoExpressionException(expression, this.currentTags);
        }
        return resolvedNode;
    }

    private <T> T processAndConvert(Class<T> clazz, String expression) throws ConstrettoException {
        String parsedValue = this.processVariablesInProperty(expression, new ArrayList<String>());
        return ValueConverterRegistry.convert(clazz, parsedValue);
    }

    private ConfigurationNode findElementOrNull(String expression) {
        List<ConfigurationNode> node = this.configuration.findAllBy(expression);
        return this.resolveMatch(node);
    }

    private ConfigurationNode resolveMatch(List<ConfigurationNode> node) {
        ConfigurationNode bestMatch = null;
        for (ConfigurationNode configurationNode : node) {
            if ("[default-tag]".equals(configurationNode.getTag())) {
                if (bestMatch != null && !bestMatch.getTag().equals("[default-tag]")) continue;
                bestMatch = configurationNode;
                continue;
            }
            if (this.currentTags.contains(configurationNode.getTag())) {
                int previousFoundPriority;
                if (bestMatch == null) {
                    bestMatch = configurationNode;
                    continue;
                }
                int n = previousFoundPriority = "[default-tag]".equals(bestMatch.getTag()) ? Integer.MAX_VALUE : this.currentTags.indexOf(bestMatch.getTag());
                if (this.currentTags.indexOf(configurationNode.getTag()) > previousFoundPriority) continue;
                bestMatch = configurationNode;
                continue;
            }
            if (!"[all-tag]".equals(configurationNode.getTag())) continue;
            bestMatch = configurationNode;
        }
        return bestMatch;
    }

    private <T> void injectConfiguration(T objectToConfigure) {
        this.injectFields(objectToConfigure);
        this.injectMethods(objectToConfigure);
        boolean found = false;
        for (WeakReference<Object> configuredObject : this.configuredObjects) {
            if (configuredObject.get() != objectToConfigure) continue;
            found = true;
            break;
        }
        if (!found) {
            this.configuredObjects.add(new WeakReference<T>(objectToConfigure));
        }
    }

    private <T> void injectMethods(T objectToConfigure) {
        Method[] methods;
        for (Method method : methods = objectToConfigure.getClass().getMethods()) {
            try {
                if (!method.isAnnotationPresent(Configure.class)) continue;
                Annotation[][] methodAnnotations = method.getParameterAnnotations();
                String[] parameterNames = this.nameDiscoverer.getParameterNames(method);
                Object[] resolvedArguments = new Object[methodAnnotations.length];
                int i = 0;
                for (Annotation[] parameterAnnotations : methodAnnotations) {
                    Object defaultValue = null;
                    boolean required = true;
                    String expression = "";
                    Class<?> parameterTargetClass = method.getParameterTypes()[i];
                    if (parameterAnnotations.length != 0) {
                        for (Annotation parameterAnnotation : parameterAnnotations) {
                            if (parameterAnnotation.annotationType() != Configuration.class) continue;
                            Configuration configurationAnnotation = (Configuration)parameterAnnotation;
                            expression = configurationAnnotation.expression();
                            required = configurationAnnotation.required();
                            if (!this.hasAnnotationDefaults(configurationAnnotation)) continue;
                            if (configurationAnnotation.defaultValueFactory().equals(Configuration.EmptyValueFactory.class)) {
                                defaultValue = ValueConverterRegistry.convert(parameterTargetClass, configurationAnnotation.defaultValue());
                                continue;
                            }
                            ConfigurationDefaultValueFactory valueFactory = (ConfigurationDefaultValueFactory)configurationAnnotation.defaultValueFactory().newInstance();
                            defaultValue = valueFactory.getDefaultValue();
                        }
                    }
                    if (expression.equals("")) {
                        if (parameterNames == null) {
                            throw new ConstrettoException("Could not resolve the expression of the property to look up. The cause of this could be that the class is compiled without debug enabled. when a class is compiled without debug, the @Configuration with a expression attribute is required to correctly resolve the property expression.");
                        }
                        expression = parameterNames[i];
                    }
                    if (this.hasValue(expression)) {
                        ConfigurationNode node = this.findElementOrThrowException(expression);
                        resolvedArguments[i] = this.processAndConvert(parameterTargetClass, node.getExpression());
                    } else if (defaultValue != null || !required) {
                        resolvedArguments[i] = defaultValue;
                    } else {
                        throw new ConstrettoException("Missing value or default value for expression [" + expression + "], in method [" + method.getName() + "], in class [" + objectToConfigure.getClass().getName() + "], with tags " + this.currentTags + ".");
                    }
                    ++i;
                }
                method.setAccessible(true);
                method.invoke(objectToConfigure, resolvedArguments);
            }
            catch (IllegalAccessException e) {
                throw new ConstrettoException("Cold not invoke method [" + method.getName() + "] annotated with @Configured,", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ConstrettoException("Cold not invoke method [" + method.getName() + "] annotated with @Configured,", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ConstrettoException("Cold not invoke method [" + method.getName() + "] annotated with @Configured,", (Throwable)e);
            }
        }
    }

    private <T> void injectFields(T objectToConfigure) {
        Class<?> objectToConfigureClass = objectToConfigure.getClass();
        do {
            Field[] fields;
            for (Field field : fields = objectToConfigureClass.getDeclaredFields()) {
                try {
                    if (field.isAnnotationPresent(Configuration.class)) {
                        Configuration configurationAnnotation = field.getAnnotation(Configuration.class);
                        String expression = "".equals(configurationAnnotation.expression()) ? field.getName() : configurationAnnotation.expression();
                        field.setAccessible(true);
                        Class<?> fieldType = field.getType();
                        if (this.hasValue(expression)) {
                            ConfigurationNode node = this.findElementOrThrowException(expression);
                            field.set(objectToConfigure, this.processAndConvert(fieldType, node.getExpression()));
                            continue;
                        }
                        if (this.hasAnnotationDefaults(configurationAnnotation)) {
                            if (configurationAnnotation.defaultValueFactory().equals(Configuration.EmptyValueFactory.class)) {
                                field.set(objectToConfigure, ValueConverterRegistry.convert(fieldType, configurationAnnotation.defaultValue()));
                                continue;
                            }
                            ConfigurationDefaultValueFactory valueFactory = (ConfigurationDefaultValueFactory)configurationAnnotation.defaultValueFactory().newInstance();
                            field.set(objectToConfigure, valueFactory.getDefaultValue());
                            continue;
                        }
                        if (!configurationAnnotation.required()) continue;
                        throw new ConstrettoException("Missing value or default value for expression [" + expression + "] for field [" + field.getName() + "], in class [" + objectToConfigure.getClass().getName() + "] with tags " + this.currentTags + ".");
                    }
                    if (!field.isAnnotationPresent(Tags.class)) continue;
                    field.setAccessible(true);
                    field.set(objectToConfigure, this.currentTags);
                }
                catch (IllegalAccessException e) {
                    throw new ConstrettoException("Cold not inject configuration into field [" + field.getName() + "] annotated with @Configuration, in class [" + objectToConfigure.getClass().getName() + "] with tags " + this.currentTags, (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new ConstrettoException("Cold not inject configuration into field [" + field.getName() + "] annotated with @Configuration, in class [" + objectToConfigure.getClass().getName() + "] with tags " + this.currentTags, (Throwable)e);
                }
            }
        } while ((objectToConfigureClass = objectToConfigureClass.getSuperclass()) != null);
    }

    private boolean hasAnnotationDefaults(Configuration configurationAnnotation) {
        return !"N/A".equals(configurationAnnotation.defaultValue()) || !configurationAnnotation.defaultValueFactory().equals(Configuration.EmptyValueFactory.class);
    }

    private String processVariablesInProperty(String expression, Collection<String> visitedPlaceholders) {
        visitedPlaceholders.add(expression);
        ConfigurationNode currentNode = this.findElementOrThrowException(expression);
        String value = currentNode.getValue();
        if (this.valueNeedsVariableResolving(value)) {
            value = this.substituteVariablesinValue(value, visitedPlaceholders);
        }
        return value;
    }

    private String substituteVariablesinValue(String value, Collection<String> visitedPlaceholders) {
        while (this.valueNeedsVariableResolving(value)) {
            ConfigurationVariable expresionToLookup = this.extractConfigurationVariable(value);
            if (visitedPlaceholders.contains(expresionToLookup.expression)) {
                throw new ConstrettoException("A cyclic dependency found in a property");
            }
            DefaultConstrettoConfiguration rootConfig = new DefaultConstrettoConfiguration(this.configuration.root(), this.currentTags);
            value = value.substring(0, expresionToLookup.startIndex) + rootConfig.processVariablesInProperty(expresionToLookup.expression, visitedPlaceholders) + value.subSequence(expresionToLookup.endIndex + 1, value.length());
        }
        return value;
    }

    private ConfigurationVariable extractConfigurationVariable(String expression) {
        int startIndex = expression.indexOf(VARIABLE_PREFIX);
        int endindex = expression.indexOf(VARIABLE_SUFFIX, startIndex);
        String parsedExpression = expression.substring(startIndex + 2, endindex);
        return new ConfigurationVariable(startIndex, endindex, parsedExpression);
    }

    private boolean valueNeedsVariableResolving(String value) {
        return null != value && value.contains(VARIABLE_PREFIX) && value.contains(VARIABLE_SUFFIX);
    }

    private static class ConfigurationVariable {
        private final int startIndex;
        private final int endIndex;
        private final String expression;

        public ConfigurationVariable(int startIndex, int endIndex, String expression) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.expression = expression;
        }

        public String toString() {
            return this.expression + ", at: " + this.startIndex + " to: " + this.endIndex;
        }
    }
}

