/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.converter;

import java.util.HashSet;
import java.util.Set;
import org.constretto.exception.ConstrettoConversionException;
import org.constretto.internal.converter.ValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanValueConverter
implements ValueConverter<Boolean> {
    private static Set<String> validStrings = new HashSet<String>(){
        {
            this.add("true");
            this.add("false");
        }
    };

    @Override
    public Boolean fromString(String value) throws ConstrettoConversionException {
        if (!validStrings.contains(value.toLowerCase())) {
            throw new ConstrettoConversionException(value, Boolean.class, "valid values are \"true\" and \"false\" ignoring case.");
        }
        return Boolean.valueOf(value);
    }
}

