/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.constretto.ConfigurationStore;
import org.constretto.exception.ConstrettoException;
import org.constretto.internal.ConstrettoUtils;
import org.constretto.model.TaggedPropertySet;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesStore
implements ConfigurationStore {
    private static final String DEFAULT_TAG_PREFIX = "@";
    private static final String PROPERTY_CONTEXT_SEPARATOR = ".";
    private final Map<String, String> properties = new HashMap<String, String>();
    private String tagPrefix = "@";

    public PropertiesStore addResource(Resource resource) {
        this.addResourcesAsProperties(resource);
        return this;
    }

    public List<TaggedPropertySet> parseConfiguration() {
        return this.getPropertySets();
    }

    private void addPropertiesToMap(Properties ... props) {
        for (Properties p : props) {
            CollectionUtils.mergePropertiesIntoMap((Properties)this.parseProperties(p), this.properties);
        }
    }

    protected Properties parseProperties(Properties props) {
        return props;
    }

    private void addResourcesAsProperties(Resource ... resources) {
        for (Resource r : resources) {
            try {
                if (!r.exists()) continue;
                InputStream is = r.getInputStream();
                Properties props = new Properties();
                props.load(is);
                this.addPropertiesToMap(props);
            }
            catch (IOException e) {
                throw new ConstrettoException((Throwable)e);
            }
        }
    }

    private List<TaggedPropertySet> getPropertySets() {
        ArrayList<TaggedPropertySet> taggedPropertySets = new ArrayList<TaggedPropertySet>();
        Set<String> tags = this.getTags(this.properties);
        for (String tag : tags) {
            taggedPropertySets.add(new TaggedPropertySet(tag, this.getPropertiesByTag(tag, this.properties), this.getClass()));
        }
        Map<String, String> unTaggedProperties = this.getUnTaggedProperties(this.properties);
        if (!unTaggedProperties.isEmpty()) {
            taggedPropertySets.add(new TaggedPropertySet(this.getUnTaggedProperties(this.properties), this.getClass()));
        }
        return taggedPropertySets;
    }

    private boolean isTag(String key) {
        return key.startsWith(this.tagPrefix);
    }

    private Map<String, String> getPropertiesByTag(String nonPrefixedTag, Map<String, String> allProperties) {
        String prefixedTag = this.prefixTag(nonPrefixedTag);
        HashMap<String, String> taggedProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : allProperties.entrySet()) {
            String strippedKey;
            if (!entry.getKey().startsWith(prefixedTag) || (strippedKey = this.stripTag(entry.getKey(), nonPrefixedTag)).equals("")) continue;
            taggedProperties.put(strippedKey, entry.getValue());
        }
        return taggedProperties;
    }

    private Map<String, String> getUnTaggedProperties(Map<String, String> properties) {
        HashMap<String, String> unTagged = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (this.isTag(entry.getKey())) continue;
            unTagged.put(entry.getKey(), entry.getValue());
        }
        return unTagged;
    }

    private Set<String> getTags(Map<String, String> properties) {
        HashSet<String> tags = new HashSet<String>();
        for (String key : properties.keySet()) {
            String tag = this.getTag(key);
            if (tag == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    private String getTag(String key) {
        if (this.isTag(key)) {
            return ConstrettoUtils.substringBetween(key, this.tagPrefix, PROPERTY_CONTEXT_SEPARATOR);
        }
        return null;
    }

    private String prefixTag(String tag) {
        return this.tagPrefix + tag;
    }

    private String stripTag(String key, String tag) {
        return ConstrettoUtils.substringAfter(key, this.tagPrefix + tag + PROPERTY_CONTEXT_SEPARATOR);
    }
}

