/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.constretto.ConstrettoBuilder;
import org.constretto.ConstrettoConfiguration;
import org.constretto.internal.store.IniFileConfigurationStore;
import org.constretto.internal.store.PropertiesStore;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class StaticlyCachedConfiguration {
    private static final ResourceLoader resourceLoader = new DefaultResourceLoader(StaticlyCachedConfiguration.class.getClassLoader());
    private static final Map<CacheKey, ConstrettoConfiguration> cache = new HashMap<CacheKey, ConstrettoConfiguration>();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static int cacheHits = 0;
    private static int cacheMiss = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstrettoConfiguration config(String ... locations) {
        CacheKey key = new CacheKey(locations);
        try {
            lock.readLock().lock();
            if (cache.containsKey(key)) {
                ++cacheHits;
                ConstrettoConfiguration constrettoConfiguration = cache.get(key);
                return constrettoConfiguration;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        try {
            lock.writeLock().lock();
            ++cacheMiss;
            ConstrettoBuilder builder = new ConstrettoBuilder();
            IniFileConfigurationStore iniFileConfigurationStore = new IniFileConfigurationStore();
            PropertiesStore propertyFileConfigurationStore = new PropertiesStore();
            for (String location : locations) {
                if (location.toLowerCase().endsWith(".ini")) {
                    iniFileConfigurationStore.addResource(resourceLoader.getResource(location));
                    continue;
                }
                if (!location.toLowerCase().endsWith(".properties")) continue;
                propertyFileConfigurationStore.addResource(resourceLoader.getResource(location));
            }
            builder = builder.addConfigurationStore(iniFileConfigurationStore);
            builder = builder.addConfigurationStore(propertyFileConfigurationStore);
            ConstrettoConfiguration configuration = builder.getConfiguration();
            cache.put(key, configuration);
            ConstrettoConfiguration constrettoConfiguration = configuration;
            return constrettoConfiguration;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static int cacheHits() {
        return cacheHits;
    }

    public static int cacheMiss() {
        return cacheMiss;
    }

    private static class CacheKey {
        String key = "";

        public CacheKey(String[] locations) {
            for (String location : locations) {
                this.key = this.key + location;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return !(this.key != null ? !this.key.equals(cacheKey.key) : cacheKey.key != null);
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }
    }
}

