/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.converter;

import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.constretto.exception.ConstrettoException;
import org.constretto.internal.converter.BooleanValueConverter;
import org.constretto.internal.converter.ByteValueConverter;
import org.constretto.internal.converter.DoubleValueConverter;
import org.constretto.internal.converter.FileValueConverter;
import org.constretto.internal.converter.FloatValueConverter;
import org.constretto.internal.converter.InetAddressValueConverter;
import org.constretto.internal.converter.InputStreamValueConverter;
import org.constretto.internal.converter.IntegerValueConverter;
import org.constretto.internal.converter.LocaleValueConverter;
import org.constretto.internal.converter.LongValueConverter;
import org.constretto.internal.converter.PropertyFileValueConverter;
import org.constretto.internal.converter.ShortValueConverter;
import org.constretto.internal.converter.SpringResourceValueConverter;
import org.constretto.internal.converter.StringValueConverter;
import org.constretto.internal.converter.UrlValueConverter;
import org.constretto.internal.converter.ValueConverter;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueConverterRegistry {
    private static final Map<Class<?>, ValueConverter<?>> converters = new HashMap<Class<?>, ValueConverter<?>>(){
        {
            this.put(Boolean.class, new BooleanValueConverter());
            this.put(Boolean.TYPE, new BooleanValueConverter());
            this.put(Float.class, new FloatValueConverter());
            this.put(Float.TYPE, new FloatValueConverter());
            this.put(Double.class, new DoubleValueConverter());
            this.put(Double.TYPE, new DoubleValueConverter());
            this.put(Long.class, new LongValueConverter());
            this.put(Long.TYPE, new LongValueConverter());
            this.put(Integer.class, new IntegerValueConverter());
            this.put(Integer.TYPE, new IntegerValueConverter());
            this.put(Byte.class, new ByteValueConverter());
            this.put(Byte.TYPE, new ByteValueConverter());
            this.put(Short.class, new ShortValueConverter());
            this.put(Short.TYPE, new ShortValueConverter());
            this.put(String.class, new StringValueConverter());
            this.put(Resource.class, new SpringResourceValueConverter());
            this.put(File.class, new FileValueConverter());
            this.put(Locale.class, new LocaleValueConverter());
            this.put(Properties.class, new PropertyFileValueConverter());
            this.put(InputStreamValueConverter.class, new InputStreamValueConverter());
            this.put(InetAddress.class, new InetAddressValueConverter());
            this.put(URL.class, new UrlValueConverter());
        }
    };

    public static void registerCustomConverter(Class<?> converterFor, ValueConverter<?> converter) {
        converters.put(converterFor, converter);
    }

    public static <T> T convert(Class<T> clazz, String value) throws ConstrettoException {
        if (!converters.containsKey(clazz)) {
            throw new ConstrettoException("No converter found for class: " + clazz.getName());
        }
        ValueConverter<?> converter = converters.get(clazz);
        return (T)converter.fromString(value);
    }
}

