/*
 * Decompiled with CFR 0.152.
 */
package org.constretto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.constretto.ConfigurationStore;
import org.constretto.ConstrettoConfiguration;
import org.constretto.internal.DefaultConstrettoConfiguration;
import org.constretto.internal.resolver.DefaultConfigurationContextResolver;
import org.constretto.internal.store.EncryptedPropertiesStore;
import org.constretto.internal.store.IniFileConfigurationStore;
import org.constretto.internal.store.JsonStore;
import org.constretto.internal.store.ObjectConfigurationStore;
import org.constretto.internal.store.PropertiesStore;
import org.constretto.internal.store.SystemPropertiesStore;
import org.constretto.model.ConfigurationValue;
import org.constretto.model.GsonParser;
import org.constretto.model.Parser;
import org.constretto.model.Resource;
import org.constretto.model.TaggedPropertySet;
import org.constretto.resolver.ConfigurationContextResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrettoBuilder {
    private final List<ConfigurationStore> configurationStores;
    private final List<String> tags;
    private final boolean enableSystemProps;
    private final Parser parser = new GsonParser();

    public ConstrettoBuilder() {
        this(new DefaultConfigurationContextResolver(), true);
    }

    public ConstrettoBuilder(boolean enableSystemProps) {
        this(new DefaultConfigurationContextResolver(), enableSystemProps);
    }

    public ConstrettoBuilder(ConfigurationContextResolver configurationContextResolver, boolean enableSystemProps) {
        this.configurationStores = new ArrayList<ConfigurationStore>();
        this.tags = new ArrayList<String>();
        this.enableSystemProps = enableSystemProps;
        for (String tag : configurationContextResolver.getTags()) {
            this.addCurrentTag(tag);
        }
        if (enableSystemProps) {
            this.configurationStores.add(new SystemPropertiesStore());
        }
    }

    private ConstrettoBuilder(List<ConfigurationStore> configurationStores, List<String> tags, boolean enableSystemProps) {
        this.enableSystemProps = enableSystemProps;
        this.configurationStores = configurationStores;
        this.tags = tags;
    }

    public ConstrettoConfiguration getConfiguration() {
        HashMap<String, List<ConfigurationValue>> configuration = new HashMap<String, List<ConfigurationValue>>();
        Collection<TaggedPropertySet> taggedPropertySets = this.loadPropertySets();
        for (TaggedPropertySet taggedPropertySet : taggedPropertySets) {
            Map<String, String> properties = taggedPropertySet.getProperties();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                List<ConfigurationValue> values;
                if (configuration.containsKey(entry.getKey())) {
                    values = (List)configuration.get(entry.getKey());
                    if (values == null) {
                        values = new ArrayList();
                    }
                    values.add(new ConfigurationValue(this.parser.parse(entry.getValue()), taggedPropertySet.tag()));
                    configuration.put(entry.getKey(), values);
                    continue;
                }
                values = new ArrayList<ConfigurationValue>();
                values.add(new ConfigurationValue(this.parser.parse(entry.getValue()), taggedPropertySet.tag()));
                configuration.put(entry.getKey(), values);
            }
        }
        return new DefaultConstrettoConfiguration(configuration, this.tags);
    }

    public ConstrettoBuilder addCurrentTag(String tag) {
        this.tags.add(tag);
        return new ConstrettoBuilder(this.configurationStores, this.tags, this.enableSystemProps);
    }

    public ConstrettoBuilder addConfigurationStore(ConfigurationStore configurationStore) {
        this.configurationStores.add(configurationStore);
        return new ConstrettoBuilder(this.configurationStores, this.tags, this.enableSystemProps);
    }

    public PropertiesStoreBuilder createPropertiesStore() {
        return new PropertiesStoreBuilder();
    }

    public EncryptedPropertiesStoreBuilder createEncryptedPropertiesStore(String passwordProperty) {
        return new EncryptedPropertiesStoreBuilder(passwordProperty);
    }

    public IniFileConfigurationStoreBuilder createIniFileConfigurationStore() {
        return new IniFileConfigurationStoreBuilder();
    }

    public JsonStoreBuilder createJsonConfigurationStore() {
        return new JsonStoreBuilder();
    }

    public ConstrettoBuilder createSystemPropertiesStore() {
        this.configurationStores.add(new SystemPropertiesStore());
        return new ConstrettoBuilder(this.configurationStores, this.tags, this.enableSystemProps);
    }

    public ObjectConfigurationStoreBuilder createObjectConfigurationStore() {
        return new ObjectConfigurationStoreBuilder();
    }

    private Collection<TaggedPropertySet> loadPropertySets() {
        ArrayList<TaggedPropertySet> taggedPropertySets = new ArrayList<TaggedPropertySet>();
        for (ConfigurationStore configurationStore : this.configurationStores) {
            taggedPropertySets.addAll(configurationStore.parseConfiguration());
        }
        return taggedPropertySets;
    }

    public class ObjectConfigurationStoreBuilder
    implements StoreBuilder {
        private final ObjectConfigurationStore store;

        public ObjectConfigurationStoreBuilder() {
            this.store = new ObjectConfigurationStore();
        }

        public ObjectConfigurationStoreBuilder(ObjectConfigurationStore store) {
            this.store = store;
        }

        public ObjectConfigurationStoreBuilder addObject(Object object) {
            this.store.addObject(object);
            return new ObjectConfigurationStoreBuilder(this.store);
        }

        public ConstrettoBuilder done() {
            ConstrettoBuilder.this.configurationStores.add(this.store);
            return new ConstrettoBuilder(ConstrettoBuilder.this.configurationStores, ConstrettoBuilder.this.tags, ConstrettoBuilder.this.enableSystemProps);
        }
    }

    public class IniFileConfigurationStoreBuilder
    implements StoreBuilder {
        private final IniFileConfigurationStore store;

        public IniFileConfigurationStoreBuilder() {
            this.store = new IniFileConfigurationStore();
        }

        public IniFileConfigurationStoreBuilder(IniFileConfigurationStore store) {
            this.store = store;
        }

        public IniFileConfigurationStoreBuilder addResource(Resource resource) {
            this.store.addResource(resource);
            return new IniFileConfigurationStoreBuilder(this.store);
        }

        public ConstrettoBuilder done() {
            ConstrettoBuilder.this.configurationStores.add(this.store);
            return new ConstrettoBuilder(ConstrettoBuilder.this.configurationStores, ConstrettoBuilder.this.tags, ConstrettoBuilder.this.enableSystemProps);
        }
    }

    public class EncryptedPropertiesStoreBuilder
    implements StoreBuilder {
        private final EncryptedPropertiesStore store;

        public EncryptedPropertiesStoreBuilder(String passwordProperty) {
            this.store = new EncryptedPropertiesStore(passwordProperty);
        }

        private EncryptedPropertiesStoreBuilder(EncryptedPropertiesStore store) {
            this.store = store;
        }

        public EncryptedPropertiesStoreBuilder addResource(Resource resource) {
            this.store.addResource(resource);
            return new EncryptedPropertiesStoreBuilder(this.store);
        }

        public ConstrettoBuilder done() {
            ConstrettoBuilder.this.configurationStores.add(this.store);
            return new ConstrettoBuilder(ConstrettoBuilder.this.configurationStores, ConstrettoBuilder.this.tags, ConstrettoBuilder.this.enableSystemProps);
        }
    }

    public class JsonStoreBuilder
    implements StoreBuilder {
        private final JsonStore store;

        public JsonStoreBuilder() {
            this.store = new JsonStore();
        }

        private JsonStoreBuilder(JsonStore store) {
            this.store = store;
        }

        public JsonStoreBuilder addResource(Resource resource, String key, String ... tags) {
            return new JsonStoreBuilder(this.store.addResource(resource, key, tags));
        }

        public ConstrettoBuilder done() {
            ConstrettoBuilder.this.configurationStores.add(this.store);
            return new ConstrettoBuilder(ConstrettoBuilder.this.configurationStores, ConstrettoBuilder.this.tags, ConstrettoBuilder.this.enableSystemProps);
        }
    }

    public class PropertiesStoreBuilder
    implements StoreBuilder {
        private final PropertiesStore store;

        public PropertiesStoreBuilder() {
            this.store = new PropertiesStore();
        }

        private PropertiesStoreBuilder(PropertiesStore store) {
            this.store = store;
        }

        public PropertiesStoreBuilder addResource(Resource resource) {
            this.store.addResource(resource);
            return new PropertiesStoreBuilder(this.store);
        }

        public ConstrettoBuilder done() {
            ConstrettoBuilder.this.configurationStores.add(this.store);
            return new ConstrettoBuilder(ConstrettoBuilder.this.configurationStores, ConstrettoBuilder.this.tags, ConstrettoBuilder.this.enableSystemProps);
        }
    }

    private static interface StoreBuilder {
        public ConstrettoBuilder done();
    }
}

