/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodParameter {
    private Method method;
    private Constructor constructor;
    private final int parameterIndex;
    private Class<?> parameterType;
    private Annotation[] parameterAnnotations;
    private int nestingLevel = 1;
    private Map<Integer, Integer> typeIndexesPerLevel;
    Map<TypeVariable, Type> typeVariableMap;

    public MethodParameter(Method method, int parameterIndex) {
        this(method, parameterIndex, 1);
    }

    public MethodParameter(Method method, int parameterIndex, int nestingLevel) {
        this.method = method;
        this.parameterIndex = parameterIndex;
        this.nestingLevel = nestingLevel;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public Class getDeclaringClass() {
        return this.method != null ? this.method.getDeclaringClass() : this.constructor.getDeclaringClass();
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    void setParameterType(Class<?> parameterType) {
        this.parameterType = parameterType;
    }

    public Class<?> getParameterType() {
        if (this.parameterType == null) {
            this.parameterType = this.parameterIndex < 0 ? (this.method != null ? this.method.getReturnType() : null) : (this.method != null ? this.method.getParameterTypes()[this.parameterIndex] : this.constructor.getParameterTypes()[this.parameterIndex]);
        }
        return this.parameterType;
    }

    public Annotation[] getMethodAnnotations() {
        return this.method != null ? this.method.getAnnotations() : this.constructor.getAnnotations();
    }

    public Annotation[] getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            Annotation[][] annotationArray = this.method != null ? this.method.getParameterAnnotations() : this.constructor.getParameterAnnotations();
            this.parameterAnnotations = this.parameterIndex >= 0 && this.parameterIndex < annotationArray.length ? annotationArray[this.parameterIndex] : new Annotation[0];
        }
        return this.parameterAnnotations;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public Integer getTypeIndexForLevel(int nestingLevel) {
        return this.getTypeIndexesPerLevel().get(nestingLevel);
    }

    private Map<Integer, Integer> getTypeIndexesPerLevel() {
        if (this.typeIndexesPerLevel == null) {
            this.typeIndexesPerLevel = new HashMap<Integer, Integer>(4);
        }
        return this.typeIndexesPerLevel;
    }
}

